/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.builders.patterns;

import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.StatementMouseClick;
import buildcraft.core.lib.utils.BCStringUtils;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PatternParameterHollow
implements IStatementParameter {
    @SideOnly(value=Side.CLIENT)
    private static TextureAtlasSprite iconHollow;
    @SideOnly(value=Side.CLIENT)
    private static TextureAtlasSprite iconFilled;
    public boolean filled = false;

    public PatternParameterHollow() {
    }

    public PatternParameterHollow(boolean hollow) {
        this();
        this.filled = !hollow;
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerSprites(TextureMap map) {
        iconFilled = map.func_174942_a(new ResourceLocation("buildcraftcore:filler/parameters/filled"));
        iconHollow = map.func_174942_a(new ResourceLocation("buildcraftcore:filler/parameters/hollow"));
    }

    @Override
    public String getUniqueTag() {
        return "buildcraft:fillerParameterHollow";
    }

    @Override
    public TextureAtlasSprite getIcon() {
        return this.filled ? iconFilled : iconHollow;
    }

    @Override
    public ItemStack getItemStack() {
        return null;
    }

    @Override
    public String getDescription() {
        return BCStringUtils.localize("fillerpattern.parameter." + (this.filled ? "filled" : "hollow"));
    }

    @Override
    public void onClick(IStatementContainer source, IStatement stmt, ItemStack stack, StatementMouseClick mouse) {
        this.filled = !this.filled;
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        this.filled = compound.func_74767_n("filled");
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        compound.func_74757_a("filled", this.filled);
    }

    @Override
    public IStatementParameter rotateLeft() {
        return this;
    }
}

