/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.builders.patterns;

import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.StatementMouseClick;
import buildcraft.core.lib.utils.BCStringUtils;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PatternParameterCenter
implements IStatementParameter {
    private static final int[] shiftLeft = new int[]{6, 3, 0, 7, 4, 1, 8, 5, 2};
    @SideOnly(value=Side.CLIENT)
    private static TextureAtlasSprite[] sprites;
    private int direction;

    public static void registerSprites(TextureMap map) {
        sprites = new TextureAtlasSprite[9];
        for (int i = 0; i < 9; ++i) {
            PatternParameterCenter.sprites[i] = map.func_174942_a(new ResourceLocation("buildcraftcore:filler/parameters/center_" + i));
        }
    }

    public PatternParameterCenter() {
    }

    public PatternParameterCenter(int direction) {
        this();
        this.direction = direction;
    }

    @Override
    public String getUniqueTag() {
        return "buildcraft:fillerParameterCenter";
    }

    @Override
    public TextureAtlasSprite getIcon() {
        return sprites[this.direction % 9];
    }

    @Override
    public ItemStack getItemStack() {
        return null;
    }

    @Override
    public String getDescription() {
        return BCStringUtils.localize("direction.center." + this.direction);
    }

    @Override
    public void onClick(IStatementContainer source, IStatement stmt, ItemStack stack, StatementMouseClick mouse) {
        this.direction = (this.direction + 1) % 9;
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        this.direction = compound.func_74771_c("dir");
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        compound.func_74774_a("dir", (byte)this.direction);
    }

    @Override
    public IStatementParameter rotateLeft() {
        return new PatternParameterCenter(shiftLeft[this.direction % 9]);
    }

    public int getDirection() {
        return this.direction;
    }
}

