/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.blueprints;

import buildcraft.api.blueprints.SchematicBlockBase;
import buildcraft.api.core.BuildCraftAPI;
import buildcraft.api.core.IInvSlot;
import buildcraft.core.blueprints.BlueprintBase;
import buildcraft.core.blueprints.BptBuilderBase;
import buildcraft.core.builders.BuildingSlot;
import buildcraft.core.builders.BuildingSlotBlock;
import buildcraft.core.builders.BuildingSlotIterator;
import buildcraft.core.builders.TileAbstractBuilder;
import buildcraft.core.lib.inventory.InventoryIterator;
import buildcraft.core.lib.utils.BlockUtils;
import buildcraft.core.lib.utils.Utils;
import java.util.LinkedList;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Vec3i;
import net.minecraft.world.World;

public class BptBuilderTemplate
extends BptBuilderBase {
    private LinkedList<BuildingSlotBlock> clearList = new LinkedList();
    private LinkedList<BuildingSlotBlock> buildList = new LinkedList();
    private BuildingSlotIterator iteratorBuild;
    private BuildingSlotIterator iteratorClear;

    public BptBuilderTemplate(BlueprintBase bluePrint, World world, BlockPos pos) {
        super(bluePrint, world, pos);
    }

    @Override
    protected void internalInit() {
        BlockPos bptMax;
        BlockPos worldOffset = this.pos.func_177973_b((Vec3i)this.blueprint.anchor);
        BlockPos bptMin = BlockPos.field_177992_a;
        if (worldOffset.func_177956_o() < 0) {
            bptMin = Utils.withValue(bptMin, EnumFacing.Axis.Y, -worldOffset.func_177956_o());
        }
        if (worldOffset.func_177971_a((Vec3i)(bptMax = this.blueprint.size.func_177973_b((Vec3i)Utils.POS_ONE))).func_177956_o() >= this.context.world().func_72800_K()) {
            bptMax = Utils.withValue(bptMax, EnumFacing.Axis.Y, this.context.world().func_72800_K() - worldOffset.func_177956_o());
        }
        if (Utils.min(bptMin, bptMax).equals((Object)bptMin) && Utils.max(bptMin, bptMax).equals((Object)bptMax)) {
            BuildingSlotBlock b;
            SchematicBlockBase slot;
            BlockPos pointWorldOffset;
            if (this.blueprint.excavate) {
                for (BlockPos bptOffset : BlockPos.func_177980_a((BlockPos)bptMin, (BlockPos)bptMax)) {
                    pointWorldOffset = worldOffset.func_177971_a((Vec3i)bptOffset);
                    slot = this.blueprint.get(bptOffset);
                    if (slot != null || this.isLocationUsed(pointWorldOffset)) continue;
                    b = new BuildingSlotBlock();
                    b.schematic = null;
                    b.pos = pointWorldOffset;
                    b.mode = BuildingSlotBlock.Mode.ClearIfInvalid;
                    b.buildStage = 0;
                    this.clearList.add(b);
                }
            }
            for (BlockPos bptOffset : BlockPos.func_177980_a((BlockPos)bptMin, (BlockPos)bptMax)) {
                pointWorldOffset = worldOffset.func_177971_a((Vec3i)bptOffset);
                slot = this.blueprint.get(bptOffset);
                if (slot == null || this.isLocationUsed(pointWorldOffset)) continue;
                b = new BuildingSlotBlock();
                b.schematic = slot;
                b.pos = pointWorldOffset;
                b.mode = BuildingSlotBlock.Mode.Build;
                b.buildStage = 1;
                this.buildList.add(b);
            }
        }
        this.iteratorBuild = new BuildingSlotIterator(this.buildList);
        this.iteratorClear = new BuildingSlotIterator(this.clearList);
    }

    private void checkDone() {
        this.done = this.buildList.size() == 0 && this.clearList.size() == 0;
    }

    @Override
    public BuildingSlot reserveNextBlock(World world) {
        return null;
    }

    @Override
    public BuildingSlot getNextBlock(World world, TileAbstractBuilder inv) {
        if (this.buildList.size() != 0 || this.clearList.size() != 0) {
            BuildingSlotBlock slot = this.internalGetNextBlock(world, inv);
            this.checkDone();
            if (slot != null) {
                return slot;
            }
        } else {
            this.checkDone();
        }
        return null;
    }

    private BuildingSlotBlock internalGetNextBlock(World world, TileAbstractBuilder builder) {
        BuildingSlotBlock slot;
        BuildingSlotBlock result = null;
        IInvSlot firstSlotToConsume = null;
        for (IInvSlot invSlot : InventoryIterator.getIterable(builder)) {
            ItemStack stack;
            if (!builder.isBuildingMaterialSlot(invSlot.getIndex()) || (stack = invSlot.getStackInSlot()) == null || stack.field_77994_a <= 0) continue;
            firstSlotToConsume = invSlot;
            break;
        }
        this.iteratorClear.startIteration();
        while (this.iteratorClear.hasNext()) {
            slot = this.iteratorClear.next();
            if (slot.buildStage > this.clearList.getFirst().buildStage) {
                this.iteratorClear.reset();
                break;
            }
            if (!this.canDestroy(builder, this.context, slot)) continue;
            if (BlockUtils.isUnbreakableBlock(world, slot.pos) || this.isBlockBreakCanceled(world, slot.pos) || BuildCraftAPI.isSoftBlock(world, slot.pos)) {
                this.iteratorClear.remove();
                this.markLocationUsed(slot.pos);
                continue;
            }
            this.consumeEnergyToDestroy(builder, slot);
            this.createDestroyItems(slot);
            result = slot;
            this.iteratorClear.remove();
            this.markLocationUsed(slot.pos);
            break;
        }
        if (result != null) {
            return result;
        }
        if (firstSlotToConsume == null) {
            return null;
        }
        this.iteratorBuild.startIteration();
        while (this.iteratorBuild.hasNext()) {
            slot = this.iteratorBuild.next();
            if (slot.buildStage > this.buildList.getFirst().buildStage) {
                this.iteratorBuild.reset();
                break;
            }
            if (BlockUtils.isUnbreakableBlock(world, slot.pos) || this.isBlockPlaceCanceled(world, slot.pos, slot.schematic) || !BuildCraftAPI.isSoftBlock(world, slot.pos)) {
                this.iteratorBuild.remove();
                this.markLocationUsed(slot.pos);
                continue;
            }
            if (!builder.consumeEnergy(240)) continue;
            slot.addStackConsumed(firstSlotToConsume.decreaseStackInSlot(1));
            result = slot;
            this.iteratorBuild.remove();
            this.markLocationUsed(slot.pos);
            break;
        }
        return result;
    }
}

