/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.blueprints;

import buildcraft.api.blueprints.Schematic;
import buildcraft.api.blueprints.SchematicBlock;
import buildcraft.api.blueprints.SchematicEntity;
import buildcraft.api.core.BCLog;
import buildcraft.api.core.BuildCraftAPI;
import buildcraft.api.core.IInvSlot;
import buildcraft.api.core.StackKey;
import buildcraft.core.blueprints.Blueprint;
import buildcraft.core.blueprints.BptBuilderBase;
import buildcraft.core.blueprints.BuildingSlotMapIterator;
import buildcraft.core.blueprints.IndexRequirementMap;
import buildcraft.core.blueprints.RequirementItemStack;
import buildcraft.core.blueprints.SchematicRegistry;
import buildcraft.core.builders.BuilderItemMetaPair;
import buildcraft.core.builders.BuildingSlot;
import buildcraft.core.builders.BuildingSlotBlock;
import buildcraft.core.builders.BuildingSlotEntity;
import buildcraft.core.builders.IBuildingItemsProvider;
import buildcraft.core.builders.TileAbstractBuilder;
import buildcraft.core.lib.inventory.InventoryCopy;
import buildcraft.core.lib.inventory.InventoryIterator;
import buildcraft.core.lib.utils.BlockUtils;
import buildcraft.core.lib.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class BptBuilderBlueprint
extends BptBuilderBase {
    protected HashSet<Integer> builtEntities = new HashSet();
    protected HashMap<BuilderItemMetaPair, List<BuildingSlotBlock>> buildList = new HashMap();
    protected int[] buildStageOccurences;
    private ArrayList<RequirementItemStack> neededItems = new ArrayList();
    private LinkedList<BuildingSlotEntity> entityList = new LinkedList();
    private LinkedList<BuildingSlot> postProcessing = new LinkedList();
    private BuildingSlotMapIterator iterator;
    private IndexRequirementMap requirementMap = new IndexRequirementMap();

    public BptBuilderBlueprint(Blueprint bluePrint, World world, BlockPos pos) {
        super(bluePrint, world, pos);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void internalInit() {
        BlockPos bptMax;
        BlockPos worldOffset = this.pos.func_177973_b((Vec3i)this.blueprint.anchor);
        BlockPos bptMin = BlockPos.field_177992_a;
        if (worldOffset.func_177956_o() < 0) {
            bptMin = Utils.withValue(bptMin, EnumFacing.Axis.Y, -worldOffset.func_177956_o());
        }
        if (worldOffset.func_177971_a((Vec3i)(bptMax = this.blueprint.size.func_177973_b((Vec3i)Utils.POS_ONE))).func_177956_o() > this.context.world().func_72800_K()) {
            bptMax = Utils.withValue(bptMax, EnumFacing.Axis.Y, this.context.world().func_72800_K() - worldOffset.func_177956_o());
        }
        if (Utils.min(bptMin, bptMax).equals((Object)bptMin) && Utils.max(bptMin, bptMax).equals((Object)bptMax)) {
            try {
                for (BlockPos bptOffset : Utils.getAllInBox(bptMin, bptMax, this.getOrder())) {
                    void var7_9;
                    SchematicBlock schematicBlock;
                    BlockPos pointWorldOffset = worldOffset.func_177971_a((Vec3i)bptOffset);
                    if (this.isLocationUsed(pointWorldOffset) || (schematicBlock = (SchematicBlock)this.blueprint.get(bptOffset)) == null && !this.blueprint.excavate) continue;
                    if (schematicBlock == null) {
                        SchematicBlock schematicBlock2 = new SchematicBlock();
                        schematicBlock2.state = Blocks.field_150350_a.func_176223_P();
                    }
                    if (!SchematicRegistry.INSTANCE.isAllowedForBuilding(var7_9.state)) continue;
                    BuildingSlotBlock b = new BuildingSlotBlock();
                    b.schematic = var7_9;
                    b.pos = pointWorldOffset;
                    b.mode = BuildingSlotBlock.Mode.ClearIfInvalid;
                    b.buildStage = 0;
                    this.addToBuildList(b);
                }
            }
            catch (ArrayIndexOutOfBoundsException aioobe) {
                BCLog.logger.warn("Attempted to use the positions " + bptMin + ", " + bptMax + " to access a blueprint with a size of " + this.blueprint.size);
                throw (ArrayIndexOutOfBoundsException)BCLog.logger.throwing((Throwable)aioobe);
            }
            LinkedList<BuildingSlotBlock> tmpStandalone = new LinkedList<BuildingSlotBlock>();
            LinkedList<BuildingSlotBlock> tmpExpanding = new LinkedList<BuildingSlotBlock>();
            for (BlockPos blockPos : Utils.getAllInBox(bptMin, bptMax, this.getOrder())) {
                BlockPos pointWorldOffset = worldOffset.func_177971_a((Vec3i)blockPos);
                SchematicBlock slot = (SchematicBlock)this.blueprint.get(blockPos);
                if (slot == null || !SchematicRegistry.INSTANCE.isAllowedForBuilding(slot.state)) continue;
                BuildingSlotBlock b = new BuildingSlotBlock();
                b.schematic = slot;
                b.pos = pointWorldOffset;
                b.mode = BuildingSlotBlock.Mode.Build;
                if (!this.isLocationUsed(pointWorldOffset)) {
                    switch (slot.getBuildStage()) {
                        case STANDALONE: {
                            tmpStandalone.add(b);
                            b.buildStage = 1;
                            break;
                        }
                        case EXPANDING: {
                            tmpExpanding.add(b);
                            b.buildStage = 2;
                        }
                    }
                    continue;
                }
                this.postProcessing.add(b);
            }
            for (BuildingSlotBlock buildingSlotBlock : tmpStandalone) {
                this.addToBuildList(buildingSlotBlock);
            }
            for (BuildingSlotBlock buildingSlotBlock : tmpExpanding) {
                this.addToBuildList(buildingSlotBlock);
            }
        }
        int seqId = 0;
        for (SchematicEntity e : ((Blueprint)this.blueprint).entities) {
            BuildingSlotEntity buildingSlotEntity = new BuildingSlotEntity();
            buildingSlotEntity.schematic = e;
            buildingSlotEntity.sequenceNumber = seqId;
            if (!this.builtEntities.contains(seqId)) {
                this.entityList.add(buildingSlotEntity);
            } else {
                this.postProcessing.add(buildingSlotEntity);
            }
            ++seqId;
        }
        this.recomputeNeededItems();
    }

    public void deploy() {
        this.initialize();
        for (List<BuildingSlotBlock> lb : this.buildList.values()) {
            for (BuildingSlotBlock b : lb) {
                if (b.mode == BuildingSlotBlock.Mode.ClearIfInvalid) {
                    this.context.world.func_175698_g(b.pos);
                    continue;
                }
                if (b.schematic.doNotBuild()) continue;
                b.stackConsumed = new LinkedList();
                try {
                    for (ItemStack stk : b.getRequirements(this.context)) {
                        if (stk == null) continue;
                        b.stackConsumed.add(stk.func_77946_l());
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    BCLog.logger.throwing(t);
                }
                b.writeToWorld(this.context);
            }
        }
        for (BuildingSlotEntity e : this.entityList) {
            e.stackConsumed = new LinkedList();
            try {
                for (ItemStack stk : e.getRequirements(this.context)) {
                    if (stk == null) continue;
                    e.stackConsumed.add(stk.func_77946_l());
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                BCLog.logger.throwing(t);
            }
            e.writeToWorld(this.context);
        }
        for (List<BuildingSlotBlock> lb : this.buildList.values()) {
            for (BuildingSlotBlock b : lb) {
                if (b.mode == BuildingSlotBlock.Mode.ClearIfInvalid) continue;
                b.postProcessing(this.context);
            }
        }
        for (BuildingSlotEntity e : this.entityList) {
            e.postProcessing(this.context);
        }
    }

    private void checkDone() {
        this.done = this.getBuildListCount() == 0 && this.entityList.size() == 0;
    }

    private int getBuildListCount() {
        int out = 0;
        if (this.buildStageOccurences != null) {
            for (int i = 0; i < this.buildStageOccurences.length; ++i) {
                out += this.buildStageOccurences[i];
            }
        }
        return out;
    }

    @Override
    public BuildingSlot reserveNextBlock(World world) {
        if (this.getBuildListCount() != 0) {
            BuildingSlot slot = this.internalGetNextBlock(world, null);
            this.checkDone();
            if (slot != null) {
                slot.reserved = true;
            }
            return slot;
        }
        return null;
    }

    private void addToBuildList(BuildingSlotBlock b) {
        if (b != null) {
            BuilderItemMetaPair imp = new BuilderItemMetaPair(this.context, b);
            if (!this.buildList.containsKey(imp)) {
                this.buildList.put(imp, new ArrayList());
            }
            this.buildList.get(imp).add(b);
            if (this.buildStageOccurences == null) {
                this.buildStageOccurences = new int[Math.max(3, b.buildStage + 1)];
            } else if (this.buildStageOccurences.length <= b.buildStage) {
                int[] newBSO = new int[b.buildStage + 1];
                System.arraycopy(this.buildStageOccurences, 0, newBSO, 0, this.buildStageOccurences.length);
                this.buildStageOccurences = newBSO;
            }
            int n = b.buildStage;
            this.buildStageOccurences[n] = this.buildStageOccurences[n] + 1;
            if (b.mode == BuildingSlotBlock.Mode.Build) {
                this.requirementMap.add(b, this.context);
                b.internalRequirementRemovalListener = this.requirementMap;
            }
        }
    }

    @Override
    public BuildingSlot getNextBlock(World world, TileAbstractBuilder inv) {
        if (this.getBuildListCount() != 0) {
            BuildingSlot slot = this.internalGetNextBlock(world, inv);
            this.checkDone();
            return slot;
        }
        if (this.entityList.size() != 0) {
            BuildingSlot slot = this.internalGetNextEntity(world, inv);
            this.checkDone();
            return slot;
        }
        this.checkDone();
        return null;
    }

    protected boolean readyForSlotLookup(TileAbstractBuilder builder) {
        return builder == null || builder.energyAvailable() >= 160;
    }

    private BuildingSlot internalGetNextBlock(World world, TileAbstractBuilder builder) {
        BuildingSlotBlock slot;
        if (!this.readyForSlotLookup(builder)) {
            return null;
        }
        if (this.iterator == null) {
            this.iterator = new BuildingSlotMapIterator(this, builder);
        }
        this.iterator.refresh(builder);
        while (this.readyForSlotLookup(builder) && (slot = this.iterator.next()) != null) {
            if (!world.func_175667_e(this.pos)) continue;
            boolean skipped = false;
            for (int i = 0; i < slot.buildStage; ++i) {
                if (this.buildStageOccurences[i] <= 0) continue;
                this.iterator.skipKey();
                skipped = true;
                break;
            }
            if (skipped) continue;
            if (slot.built) {
                this.iterator.remove();
                this.markLocationUsed(slot.pos);
                this.postProcessing.add(slot);
                continue;
            }
            if (slot.reserved) continue;
            try {
                if (slot.isAlreadyBuilt(this.context)) {
                    if (slot.mode == BuildingSlotBlock.Mode.Build) {
                        this.requirementMap.remove(slot);
                        this.postProcessing.add(slot);
                    }
                    this.iterator.remove();
                    continue;
                }
                if (BlockUtils.isUnbreakableBlock(world, slot.pos)) {
                    this.iterator.remove();
                    this.markLocationUsed(slot.pos);
                    this.requirementMap.remove(slot);
                    continue;
                }
                if (slot.mode == BuildingSlotBlock.Mode.ClearIfInvalid) {
                    if (BuildCraftAPI.isSoftBlock(world, slot.pos) || this.isBlockBreakCanceled(world, slot.pos)) {
                        this.iterator.remove();
                        this.markLocationUsed(slot.pos);
                        continue;
                    }
                    if (builder == null) {
                        this.createDestroyItems(slot);
                        return slot;
                    }
                    if (!this.canDestroy(builder, this.context, slot)) continue;
                    this.consumeEnergyToDestroy(builder, slot);
                    this.createDestroyItems(slot);
                    this.iterator.remove();
                    this.markLocationUsed(slot.pos);
                    return slot;
                }
                if (!slot.schematic.doNotBuild()) {
                    if (builder == null) {
                        return slot;
                    }
                    if (!this.checkRequirements(builder, slot.schematic) || !BuildCraftAPI.isSoftBlock(world, slot.pos) || this.requirementMap.contains(slot.pos)) continue;
                    if (this.isBlockPlaceCanceled(world, slot.pos, slot.schematic)) {
                        this.iterator.remove();
                        this.requirementMap.remove(slot);
                        this.markLocationUsed(slot.pos);
                        continue;
                    }
                    builder.consumeEnergy(slot.getEnergyRequirement());
                    this.useRequirements(builder, slot);
                    this.iterator.remove();
                    this.markLocationUsed(slot.pos);
                    this.postProcessing.add(slot);
                    return slot;
                }
                this.postProcessing.add(slot);
                this.requirementMap.remove(slot);
                this.iterator.remove();
            }
            catch (Throwable t) {
                t.printStackTrace();
                BCLog.logger.throwing(t);
                this.iterator.remove();
                this.requirementMap.remove(slot);
            }
        }
        return null;
    }

    private BuildingSlot internalGetNextEntity(World world, TileAbstractBuilder builder) {
        Iterator it = this.entityList.iterator();
        while (it.hasNext()) {
            BuildingSlotEntity slot = (BuildingSlotEntity)it.next();
            if (slot.isAlreadyBuilt(this.context)) {
                it.remove();
                this.recomputeNeededItems();
                continue;
            }
            if (!this.checkRequirements(builder, slot.schematic)) continue;
            builder.consumeEnergy(slot.getEnergyRequirement());
            this.useRequirements(builder, slot);
            it.remove();
            this.recomputeNeededItems();
            this.postProcessing.add(slot);
            this.builtEntities.add(slot.sequenceNumber);
            return slot;
        }
        return null;
    }

    public boolean checkRequirements(TileAbstractBuilder builder, Schematic slot) {
        LinkedList<ItemStack> tmpReq = new LinkedList<ItemStack>();
        try {
            LinkedList<ItemStack> req = new LinkedList<ItemStack>();
            slot.getRequirementsForPlacement(this.context, req);
            for (ItemStack stk : req) {
                if (stk == null) continue;
                tmpReq.add(stk.func_77946_l());
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            BCLog.logger.throwing(t);
        }
        LinkedList<ItemStack> stacksUsed = new LinkedList<ItemStack>();
        if (this.context.world().func_72912_H().func_76077_q() == WorldSettings.GameType.CREATIVE) {
            for (ItemStack s : tmpReq) {
                stacksUsed.add(s);
            }
            return builder.energyAvailable() >= slot.getEnergyRequirement(stacksUsed);
        }
        for (ItemStack reqStk : tmpReq) {
            Fluid fluid;
            boolean itemBlock = reqStk.func_77973_b() instanceof ItemBlock;
            Fluid fluid2 = fluid = itemBlock ? FluidRegistry.lookupFluidForBlock((Block)((ItemBlock)reqStk.func_77973_b()).field_150939_a) : null;
            if (fluid != null && builder.drainBuild(new FluidStack(fluid, 1000), true)) continue;
            for (IInvSlot slotInv : InventoryIterator.getIterable(new InventoryCopy(builder))) {
                boolean compatibleContainer;
                ItemStack invStk;
                if (!builder.isBuildingMaterialSlot(slotInv.getIndex()) || (invStk = slotInv.getStackInSlot()) == null || invStk.field_77994_a == 0) continue;
                FluidStack fluidStack = fluid != null ? FluidContainerRegistry.getFluidForFilledItem((ItemStack)invStk) : null;
                boolean bl = compatibleContainer = fluidStack != null && fluidStack.getFluid() == fluid && fluidStack.amount >= 1000;
                if (!slot.isItemMatchingRequirement(invStk, reqStk) && !compatibleContainer) continue;
                try {
                    stacksUsed.add(slot.useItem(this.context, reqStk, slotInv));
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    BCLog.logger.throwing(t);
                }
                if (reqStk.field_77994_a != 0) continue;
                break;
            }
            if (reqStk.field_77994_a == 0) continue;
            return false;
        }
        return builder.energyAvailable() >= slot.getEnergyRequirement(stacksUsed);
    }

    @Override
    public void useRequirements(IInventory inv, BuildingSlot slot) {
        if (slot instanceof BuildingSlotBlock && ((BuildingSlotBlock)slot).mode == BuildingSlotBlock.Mode.ClearIfInvalid) {
            return;
        }
        LinkedList<ItemStack> tmpReq = new LinkedList<ItemStack>();
        try {
            for (ItemStack stk : slot.getRequirements(this.context)) {
                if (stk == null) continue;
                tmpReq.add(stk.func_77946_l());
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            BCLog.logger.throwing(t);
        }
        if (this.context.world().func_72912_H().func_76077_q() == WorldSettings.GameType.CREATIVE) {
            for (ItemStack s : tmpReq) {
                slot.addStackConsumed(s);
            }
            return;
        }
        ListIterator<ItemStack> itr = tmpReq.listIterator();
        while (itr.hasNext()) {
            Fluid fluid;
            ItemStack reqStk = (ItemStack)itr.next();
            boolean smallStack = reqStk.field_77994_a == 1;
            ItemStack usedStack = reqStk;
            boolean itemBlock = reqStk.func_77973_b() instanceof ItemBlock;
            Fluid fluid2 = fluid = itemBlock ? FluidRegistry.lookupFluidForBlock((Block)((ItemBlock)reqStk.func_77973_b()).field_150939_a) : null;
            if (fluid != null && inv instanceof TileAbstractBuilder && ((TileAbstractBuilder)inv).drainBuild(new FluidStack(fluid, 1000), true)) continue;
            for (IInvSlot slotInv : InventoryIterator.getIterable(inv)) {
                boolean fluidFound;
                ItemStack invStk;
                if (inv instanceof TileAbstractBuilder && !((TileAbstractBuilder)inv).isBuildingMaterialSlot(slotInv.getIndex()) || (invStk = slotInv.getStackInSlot()) == null || invStk.field_77994_a == 0) continue;
                FluidStack fluidStack = fluid != null ? FluidContainerRegistry.getFluidForFilledItem((ItemStack)invStk) : null;
                boolean bl = fluidFound = fluidStack != null && fluidStack.getFluid() == fluid && fluidStack.amount >= 1000;
                if (!fluidFound && !slot.getSchematic().isItemMatchingRequirement(invStk, reqStk)) continue;
                try {
                    usedStack = slot.getSchematic().useItem(this.context, reqStk, slotInv);
                    slot.addStackConsumed(usedStack);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    BCLog.logger.throwing(t);
                }
                if (reqStk.field_77994_a != 0) continue;
                break;
            }
            if (reqStk.field_77994_a != 0) {
                return;
            }
            if (!smallStack) continue;
            itr.set(usedStack);
        }
    }

    public List<RequirementItemStack> getNeededItems() {
        return this.neededItems;
    }

    protected void onRemoveBuildingSlotBlock(BuildingSlotBlock slot) {
        Integer num;
        int n = slot.buildStage;
        this.buildStageOccurences[n] = this.buildStageOccurences[n] - 1;
        List<Object> stacks = new ArrayList();
        try {
            stacks = slot.getRequirements(this.context);
        }
        catch (Throwable t) {
            t.printStackTrace();
            BCLog.logger.throwing(t);
        }
        HashMap<StackKey, Integer> computeStacks = new HashMap<StackKey, Integer>();
        for (ItemStack itemStack : stacks) {
            if (itemStack == null || itemStack.func_77973_b() == null || itemStack.field_77994_a == 0) continue;
            StackKey key = new StackKey(itemStack);
            if (!computeStacks.containsKey(key)) {
                computeStacks.put(key, itemStack.field_77994_a);
                continue;
            }
            num = (Integer)computeStacks.get(key);
            num = num + itemStack.field_77994_a;
            computeStacks.put(key, num);
        }
        for (RequirementItemStack requirementItemStack : this.neededItems) {
            StackKey stackKey = new StackKey(requirementItemStack.stack);
            if (!computeStacks.containsKey(stackKey)) continue;
            num = (Integer)computeStacks.get(stackKey);
            if (requirementItemStack.size <= num) {
                this.recomputeNeededItems();
                return;
            }
            this.neededItems.set(this.neededItems.indexOf(requirementItemStack), new RequirementItemStack(requirementItemStack.stack, requirementItemStack.size - num));
        }
        this.sortNeededItems();
    }

    private void sortNeededItems() {
        Collections.sort(this.neededItems, new Comparator<RequirementItemStack>(){

            @Override
            public int compare(RequirementItemStack o1, RequirementItemStack o2) {
                if (o1.size != o2.size) {
                    return o1.size < o2.size ? 1 : -1;
                }
                ItemStack os1 = o1.stack;
                ItemStack os2 = o2.stack;
                if (Item.func_150891_b((Item)os1.func_77973_b()) > Item.func_150891_b((Item)os2.func_77973_b())) {
                    return -1;
                }
                if (Item.func_150891_b((Item)os1.func_77973_b()) < Item.func_150891_b((Item)os2.func_77973_b())) {
                    return 1;
                }
                if (os1.func_77952_i() > os2.func_77952_i()) {
                    return -1;
                }
                if (os1.func_77952_i() < os2.func_77952_i()) {
                    return 1;
                }
                return 0;
            }
        });
    }

    private void recomputeNeededItems() {
        this.neededItems.clear();
        HashMap<StackKey, Integer> computeStacks = new HashMap<StackKey, Integer>();
        for (List<BuildingSlotBlock> list : this.buildList.values()) {
            for (BuildingSlotBlock slot : list) {
                if (slot == null) continue;
                List<Object> stacks = new ArrayList();
                try {
                    stacks = slot.getRequirements(this.context);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    BCLog.logger.throwing(t);
                }
                for (ItemStack itemStack : stacks) {
                    if (itemStack == null || itemStack.func_77973_b() == null || itemStack.field_77994_a == 0) continue;
                    StackKey key = new StackKey(itemStack);
                    if (!computeStacks.containsKey(key)) {
                        computeStacks.put(key, itemStack.field_77994_a);
                        continue;
                    }
                    Integer num = (Integer)computeStacks.get(key);
                    num = num + itemStack.field_77994_a;
                    computeStacks.put(key, num);
                }
            }
        }
        for (BuildingSlotEntity buildingSlotEntity : this.entityList) {
            List stacks = new LinkedList();
            try {
                stacks = buildingSlotEntity.getRequirements(this.context);
            }
            catch (Throwable t) {
                t.printStackTrace();
                BCLog.logger.throwing(t);
            }
            for (ItemStack stack : stacks) {
                if (stack == null || stack.func_77973_b() == null || stack.field_77994_a == 0) continue;
                StackKey key = new StackKey(stack);
                if (!computeStacks.containsKey(key)) {
                    computeStacks.put(key, stack.field_77994_a);
                    continue;
                }
                Integer n2 = (Integer)computeStacks.get(key);
                n2 = n2 + stack.field_77994_a;
                computeStacks.put(key, n2);
            }
        }
        for (Map.Entry entry : computeStacks.entrySet()) {
            this.neededItems.add(new RequirementItemStack(((StackKey)entry.getKey()).stack.func_77946_l(), (Integer)entry.getValue()));
        }
        this.sortNeededItems();
    }

    @Override
    public void postProcessing(World world) {
        for (BuildingSlot s : this.postProcessing) {
            try {
                s.postProcessing(this.context);
            }
            catch (Throwable t) {
                t.printStackTrace();
                BCLog.logger.throwing(t);
            }
        }
    }

    @Override
    public void saveBuildStateToNBT(NBTTagCompound nbt, IBuildingItemsProvider builder) {
        super.saveBuildStateToNBT(nbt, builder);
        int[] entitiesBuiltArr = new int[this.builtEntities.size()];
        int id = 0;
        for (Integer i : this.builtEntities) {
            entitiesBuiltArr[id] = i;
            ++id;
        }
        nbt.func_74783_a("builtEntities", entitiesBuiltArr);
    }

    @Override
    public void loadBuildStateToNBT(NBTTagCompound nbt, IBuildingItemsProvider builder) {
        super.loadBuildStateToNBT(nbt, builder);
        int[] entitiesBuiltArr = nbt.func_74759_k("builtEntities");
        for (int i = 0; i < entitiesBuiltArr.length; ++i) {
            this.builtEntities.add(i);
        }
    }
}

