/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.blueprints;

import buildcraft.api.blueprints.BuildingPermission;
import buildcraft.api.blueprints.IBuilderContext;
import buildcraft.api.blueprints.MappingNotFoundException;
import buildcraft.api.blueprints.Schematic;
import buildcraft.api.blueprints.SchematicBlock;
import buildcraft.api.blueprints.SchematicBlockBase;
import buildcraft.api.blueprints.SchematicEntity;
import buildcraft.api.core.BCLog;
import buildcraft.core.blueprints.BlueprintBase;
import buildcraft.core.blueprints.BptContext;
import buildcraft.core.blueprints.BptError;
import buildcraft.core.blueprints.SchematicRegistry;
import buildcraft.core.lib.utils.BCStringUtils;
import buildcraft.core.lib.utils.NBTUtils;
import buildcraft.core.lib.utils.Utils;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.util.Vec3i;

public class Blueprint
extends BlueprintBase {
    public LinkedList<SchematicEntity> entities = new LinkedList();

    public Blueprint() {
        this.id.extension = "bpt";
    }

    public Blueprint(BlockPos size) {
        super(size);
        this.id.extension = "bpt";
    }

    @Override
    public void rotateLeft(BptContext context) {
        for (SchematicEntity e : this.entities) {
            e.rotateLeft(context);
        }
        super.rotateLeft(context);
    }

    @Override
    public void translateToBlueprint(Vec3 transform) {
        super.translateToBlueprint(transform);
        for (SchematicEntity e : this.entities) {
            e.translateToBlueprint(transform);
        }
    }

    @Override
    public void translateToWorld(Vec3 transform) {
        super.translateToWorld(transform);
        for (SchematicEntity e : this.entities) {
            e.translateToWorld(transform);
        }
    }

    @Override
    public void readFromWorld(IBuilderContext context, TileEntity anchorTile, BlockPos pos) {
        BptContext bptContext = (BptContext)context;
        IBlockState state = anchorTile.func_145831_w().func_180495_p(pos);
        if (context.world().func_175623_d(pos)) {
            return;
        }
        SchematicBlock slot = SchematicRegistry.INSTANCE.createSchematicBlock(state);
        if (slot == null) {
            return;
        }
        BlockPos contextPos = pos.func_177973_b((Vec3i)context.surroundingBox().min());
        slot.state = state;
        if (!SchematicRegistry.INSTANCE.isSupported(state)) {
            return;
        }
        try {
            slot.initializeFromObjectAt(context, pos);
            slot.storeRequirements(context, pos);
            this.set(contextPos, slot);
        }
        catch (Throwable t) {
            t.printStackTrace();
            BCLog.logger.throwing(t);
        }
        switch (slot.getBuildingPermission()) {
            case ALL: {
                break;
            }
            case CREATIVE_ONLY: {
                if (bptContext.readConfiguration.allowCreative) {
                    if (this.buildingPermission != BuildingPermission.ALL) break;
                    this.buildingPermission = BuildingPermission.CREATIVE_ONLY;
                    break;
                }
                this.set(contextPos, null);
                break;
            }
            case NONE: {
                this.buildingPermission = BuildingPermission.NONE;
            }
        }
    }

    @Override
    public void readEntitiesFromWorld(IBuilderContext context, TileEntity anchorTile) {
        BptContext bptContext = (BptContext)context;
        Vec3 transform = new Vec3(0.0, 0.0, 0.0).func_178788_d(Utils.convert((Vec3i)context.surroundingBox().min()));
        for (Object o : context.world().field_72996_f) {
            SchematicEntity s;
            Entity e = (Entity)o;
            if (!context.surroundingBox().contains(new Vec3(e.field_70165_t, e.field_70163_u, e.field_70161_v)) || (s = SchematicRegistry.INSTANCE.createSchematicEntity(e.getClass())) == null) continue;
            s.readFromWorld(context, e);
            switch (s.getBuildingPermission()) {
                case ALL: {
                    this.entities.add(s);
                    break;
                }
                case CREATIVE_ONLY: {
                    if (!bptContext.readConfiguration.allowCreative) break;
                    if (this.buildingPermission == BuildingPermission.ALL) {
                        this.buildingPermission = BuildingPermission.CREATIVE_ONLY;
                    }
                    this.entities.add(s);
                    break;
                }
                case NONE: {
                    this.buildingPermission = BuildingPermission.NONE;
                }
            }
        }
    }

    @Override
    public void saveContents(NBTTagCompound nbt) {
        NBTTagCompound nbtContents = new NBTTagCompound();
        for (Object pos : BlockPos.func_177980_a((BlockPos)BlockPos.field_177992_a, (BlockPos)this.size.func_177973_b((Vec3i)Utils.POS_ONE))) {
            SchematicBlockBase schematic = null;
            NBTTagCompound cpt = new NBTTagCompound();
            try {
                schematic = this.get((BlockPos)pos);
                if (schematic == null) continue;
                schematic.idsToBlueprint(this.mapping);
                schematic.writeSchematicToNBT(cpt, this.mapping);
                nbtContents.func_74782_a(BCStringUtils.blockPosToShortString((BlockPos)pos), (NBTBase)cpt);
            }
            catch (Throwable t) {
                CrashReport crash = t instanceof ReportedException ? ((ReportedException)t).func_71575_a() : new CrashReport("Failed to save the contents of a blueprint!", t);
                CrashReportCategory cat = crash.func_85058_a("Block Being Saved");
                cat.func_71507_a("Block Position (In schematic)", pos);
                cat.func_71507_a("Schematic type", schematic == null ? "~~NULL~~" : schematic.getClass());
                this.mapping.addToCrashReport(crash.func_85058_a("Mapping Registry"));
                throw new ReportedException(crash);
            }
        }
        nbt.func_74782_a("contents", (NBTBase)nbtContents);
        NBTTagList entitiesNBT = new NBTTagList();
        for (SchematicEntity s : this.entities) {
            NBTTagCompound subNBT = new NBTTagCompound();
            s.idsToBlueprint(this.mapping);
            s.writeSchematicToNBT(subNBT, this.mapping);
            entitiesNBT.func_74742_a((NBTBase)subNBT);
        }
        nbt.func_74782_a("entities", (NBTBase)entitiesNBT);
        NBTTagCompound contextNBT = new NBTTagCompound();
        this.mapping.write(contextNBT);
        nbt.func_74782_a("idMapping", (NBTBase)contextNBT);
    }

    private void loadSingleSchematicFromNBT(BlockPos pos, NBTTagCompound cpt) {
        if (cpt.func_74764_b("blockId")) {
            Block block;
            try {
                block = this.mapping.getBlockForId(cpt.func_74762_e("blockId"));
            }
            catch (MappingNotFoundException e) {
                block = null;
                this.isComplete = false;
            }
            if (block != null) {
                int meta = cpt.func_74762_e("blockMeta");
                SchematicBlock schematic = SchematicRegistry.INSTANCE.createSchematicBlock(block.func_176203_a(meta));
                if (schematic != null) {
                    ((Schematic)schematic).readSchematicFromNBT(cpt, this.mapping);
                    if (!((Schematic)schematic).doNotUse()) {
                        schematic.idsToWorld(this.mapping);
                        switch (((Schematic)schematic).getBuildingPermission()) {
                            case ALL: {
                                break;
                            }
                            case CREATIVE_ONLY: {
                                if (this.buildingPermission != BuildingPermission.ALL) break;
                                this.buildingPermission = BuildingPermission.CREATIVE_ONLY;
                                break;
                            }
                            case NONE: {
                                this.buildingPermission = BuildingPermission.NONE;
                            }
                        }
                    } else {
                        schematic = null;
                        this.isComplete = false;
                    }
                }
                this.set(pos, schematic);
            } else {
                this.set(pos, null);
                this.isComplete = false;
            }
        } else {
            this.set(pos, null);
        }
    }

    @Override
    public void loadContents(NBTTagCompound nbt) throws BptError {
        this.mapping.read(nbt.func_74775_l("idMapping"));
        NBTBase base = nbt.func_74781_a("contents");
        if (base instanceof NBTTagCompound) {
            NBTTagCompound contents = (NBTTagCompound)base;
            for (BlockPos pos : BlockPos.func_177980_a((BlockPos)BlockPos.field_177992_a, (BlockPos)this.size.func_177973_b((Vec3i)Utils.POS_ONE))) {
                NBTTagCompound single = contents.func_74775_l(BCStringUtils.blockPosToShortString(pos));
                this.loadSingleSchematicFromNBT(pos, single);
            }
        } else {
            NBTTagList nbtContents = nbt.func_150295_c("contents", 10);
            int index = 0;
            for (int x = 0; x < this.size.func_177958_n(); ++x) {
                for (int y = 0; y < this.size.func_177956_o(); ++y) {
                    for (int z = 0; z < this.size.func_177952_p(); ++z) {
                        NBTTagCompound cpt = nbtContents.func_150305_b(index);
                        this.loadSingleSchematicFromNBT(new BlockPos(x, y, z), cpt);
                        ++index;
                    }
                }
            }
        }
        NBTTagList entitiesNBT = nbt.func_150295_c("entities", 10);
        for (int i = 0; i < entitiesNBT.func_74745_c(); ++i) {
            Class<? extends Entity> entity;
            NBTTagCompound cpt = entitiesNBT.func_150305_b(i);
            if (!cpt.func_74764_b("entityId")) continue;
            try {
                entity = this.mapping.getEntityForId(cpt.func_74762_e("entityId"));
            }
            catch (MappingNotFoundException e) {
                entity = null;
                this.isComplete = false;
            }
            if (entity != null) {
                SchematicEntity s = SchematicRegistry.INSTANCE.createSchematicEntity(entity);
                s.readSchematicFromNBT(cpt, this.mapping);
                s.idsToWorld(this.mapping);
                this.entities.add(s);
                continue;
            }
            this.isComplete = false;
        }
    }

    @Override
    public ItemStack getStack() {
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("BuildCraft|Builders:blueprintItem"));
        if (item == null) {
            throw new Error("Could not find the blueprint item! Did you attempt to use this without buildcraft builders installed?");
        }
        ItemStack stack = new ItemStack(item, 1, 1);
        NBTTagCompound nbt = NBTUtils.getItemData(stack);
        this.id.write(nbt);
        nbt.func_74778_a("author", this.author);
        nbt.func_74778_a("name", this.id.name);
        nbt.func_74774_a("permission", (byte)this.buildingPermission.ordinal());
        nbt.func_74757_a("isComplete", this.isComplete);
        return stack;
    }
}

