/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core;

import buildcraft.api.tools.IToolWrench;
import buildcraft.core.lib.items.ItemBuildCraft;
import buildcraft.core.lib.utils.BlockUtils;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockButton;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockLever;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class ItemWrench
extends ItemBuildCraft
implements IToolWrench {
    private final Set<Class<? extends Block>> shiftRotations = new HashSet<Class<? extends Block>>();
    private final Set<Class<? extends Block>> blacklistedRotations = new HashSet<Class<? extends Block>>();

    public ItemWrench() {
        this.func_77664_n();
        this.func_77625_d(1);
        this.shiftRotations.add(BlockLever.class);
        this.shiftRotations.add(BlockButton.class);
        this.shiftRotations.add(BlockChest.class);
        this.blacklistedRotations.add(BlockBed.class);
        this.setHarvestLevel("wrench", 0);
    }

    private boolean isClass(Set<Class<? extends Block>> set, Class<? extends Block> cls) {
        for (Class<? extends Block> shift : set) {
            if (!shift.isAssignableFrom(cls)) continue;
            return true;
        }
        return false;
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block == null || this.isClass(this.blacklistedRotations, block.getClass())) {
            return false;
        }
        if (player.func_70093_af() != this.isClass(this.shiftRotations, block.getClass())) {
            return false;
        }
        if (block instanceof BlockChest && BlockUtils.getOtherDoubleChest(world.func_175625_s(pos)) != null) {
            return false;
        }
        if (block.rotateBlock(world, pos, side)) {
            player.func_71038_i();
            return !world.field_72995_K;
        }
        return false;
    }

    @Override
    public boolean canWrench(EntityPlayer player, BlockPos pos) {
        return true;
    }

    @Override
    public void wrenchUsed(EntityPlayer player, BlockPos pos) {
        player.func_71038_i();
    }

    @Override
    public boolean doesSneakBypassUse(World world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    @Override
    public boolean canWrench(EntityPlayer player, Entity entity) {
        return true;
    }

    @Override
    public void wrenchUsed(EntityPlayer player, Entity entity) {
        player.func_71038_i();
    }
}

