/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core;

import buildcraft.api.core.IAreaProvider;
import buildcraft.api.core.IBox;
import buildcraft.api.core.ISerializable;
import buildcraft.core.LaserData;
import buildcraft.core.lib.utils.Matrix4i;
import buildcraft.core.lib.utils.NBTUtils;
import buildcraft.core.lib.utils.NetworkUtils;
import buildcraft.core.lib.utils.Utils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.Vec3;
import net.minecraft.util.Vec3i;

public class Box
implements IBox,
ISerializable {
    public Kind kind = Kind.LASER_RED;
    public boolean isVisible = true;
    public LaserData[] lasersData;
    private BlockPos min;
    private BlockPos max;

    public Box() {
        this.reset();
    }

    public Box(BlockPos min, BlockPos max) {
        this();
        this.min = Utils.min(min, max);
        this.max = Utils.max(min, max);
    }

    public Box(TileEntity e) {
        this(e.func_174877_v(), e.func_174877_v().func_177971_a((Vec3i)Utils.POS_ONE));
    }

    public void reset() {
        this.min = null;
        this.max = null;
    }

    public boolean isInitialized() {
        return this.min != null && this.max != null;
    }

    public void extendToEncompassBoth(BlockPos min, BlockPos max) {
        this.min = Utils.min(this.min, Utils.min(min, max));
        this.max = Utils.max(this.max, Utils.max(min, max));
    }

    public void setMin(BlockPos min) {
        if (min == null) {
            return;
        }
        this.min = min;
        this.max = Utils.max(min, this.max);
    }

    public void setMax(BlockPos max) {
        if (max == null) {
            return;
        }
        this.min = Utils.min(this.min, max);
        this.max = max;
    }

    public void initialize(Box box) {
        this.reset();
        this.extendToEncompassBoth(box.min(), box.max());
    }

    public void initialize(IAreaProvider a) {
        this.reset();
        this.extendToEncompassBoth(a.min(), a.max());
    }

    public void initialize(NBTTagCompound nbt) {
        BlockPos max;
        BlockPos min;
        this.kind = Kind.values()[nbt.func_74765_d("kind")];
        if (nbt.func_74764_b("xMin")) {
            min = new BlockPos(nbt.func_74762_e("xMin"), nbt.func_74762_e("yMin"), nbt.func_74762_e("zMin"));
            max = new BlockPos(nbt.func_74762_e("xMax"), nbt.func_74762_e("yMax"), nbt.func_74762_e("zMax"));
        } else {
            min = NBTUtils.readBlockPos(nbt.func_74781_a("min"));
            max = NBTUtils.readBlockPos(nbt.func_74781_a("max"));
        }
        this.extendToEncompassBoth(min, max);
    }

    public void initializeCenter(BlockPos center, int size) {
        this.initializeCenter(center, (Vec3i)Utils.vec3i(size));
    }

    public void initializeCenter(BlockPos center, Vec3i size) {
        this.extendToEncompassBoth(center.func_177973_b(size), center.func_177971_a(size));
    }

    public List<BlockPos> getBlocksInArea() {
        ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
        for (BlockPos pos : BlockPos.func_177980_a((BlockPos)this.min, (BlockPos)this.max.func_177971_a((Vec3i)Utils.POS_ONE))) {
            blocks.add(pos);
        }
        return blocks;
    }

    @Override
    public Box expand(int amount) {
        if (!this.isInitialized()) {
            return this;
        }
        BlockPos am = Utils.vec3i(amount);
        this.setMin(this.min().func_177973_b((Vec3i)am));
        this.setMax(this.max().func_177971_a((Vec3i)am));
        return this;
    }

    @Override
    public IBox contract(int amount) {
        return this.expand(-amount);
    }

    @Override
    public boolean contains(Vec3 p) {
        AxisAlignedBB bb = this.getBoundingBox();
        if (p.field_72450_a < bb.field_72340_a || p.field_72450_a >= bb.field_72336_d) {
            return false;
        }
        if (p.field_72448_b < bb.field_72338_b || p.field_72448_b >= bb.field_72337_e) {
            return false;
        }
        return !(p.field_72449_c < bb.field_72339_c) && !(p.field_72449_c >= bb.field_72334_f);
    }

    public boolean contains(BlockPos i) {
        return this.contains(Utils.convert((Vec3i)i));
    }

    @Override
    public BlockPos min() {
        return this.min;
    }

    @Override
    public BlockPos max() {
        return this.max;
    }

    public BlockPos size() {
        if (!this.isInitialized()) {
            return BlockPos.field_177992_a;
        }
        return this.max.func_177973_b((Vec3i)this.min).func_177971_a((Vec3i)Utils.POS_ONE);
    }

    public BlockPos center() {
        return Utils.convertFloor(this.centerExact());
    }

    public Vec3 centerExact() {
        return Utils.convert((Vec3i)this.min()).func_178787_e(Utils.multiply(Utils.convert((Vec3i)this.size()), 0.5));
    }

    public Box rotateLeft() {
        Matrix4i mat = Matrix4i.makeRotLeftTranslatePositive(this);
        BlockPos newMin = mat.multiplyPosition((Vec3i)this.min);
        BlockPos newMax = mat.multiplyPosition((Vec3i)this.max);
        return new Box(newMin, newMax);
    }

    @Override
    public void createLaserData() {
        this.lasersData = Utils.createLaserDataBox(Utils.convert((Vec3i)this.min()), Utils.convert((Vec3i)this.max()));
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74774_a("kind", (byte)this.kind.ordinal());
        if (this.min != null) {
            nbt.func_74782_a("min", NBTUtils.writeBlockPos(this.min));
        }
        if (this.max != null) {
            nbt.func_74782_a("max", NBTUtils.writeBlockPos(this.max));
        }
    }

    public String toString() {
        return "Box[min = " + this.min + ", max = " + this.max + "]";
    }

    public Box extendToEncompass(IBox toBeContained) {
        if (toBeContained == null) {
            return this;
        }
        this.extendToEncompassBoth(toBeContained.min(), toBeContained.max());
        return this;
    }

    public AxisAlignedBB getBoundingBox() {
        return new AxisAlignedBB(this.min, this.max.func_177971_a((Vec3i)Utils.POS_ONE));
    }

    public Box extendToEncompass(Vec3 toBeContained) {
        this.setMin(Utils.min(this.min, Utils.convertFloor(toBeContained)));
        this.setMax(Utils.max(this.max, Utils.convertCeiling(toBeContained)));
        return this;
    }

    public Box extendToEncompass(BlockPos toBeContained) {
        this.setMin(Utils.min(this.min, toBeContained));
        this.setMax(Utils.max(this.max, toBeContained));
        return this;
    }

    @Override
    public double distanceTo(BlockPos index) {
        return Math.sqrt(this.distanceToSquared(index));
    }

    @Override
    public double distanceToSquared(BlockPos index) {
        return this.closestInsideTo(index).func_177951_i((Vec3i)index);
    }

    public BlockPos closestInsideTo(BlockPos toTest) {
        return Utils.max(this.min(), Utils.min(this.max(), toTest));
    }

    @Override
    public BlockPos getRandomBlockPos(Random rand) {
        return this.min().func_177971_a((Vec3i)Utils.randomBlockPos(rand, this.size().func_177971_a((Vec3i)Utils.POS_ONE)));
    }

    @Override
    public void readData(ByteBuf stream) {
        byte flags = stream.readByte();
        this.kind = Kind.values()[flags & 0x1F];
        boolean initialized = (flags & 0x40) != 0;
        boolean bl = this.isVisible = (flags & 0x20) != 0;
        if (initialized) {
            this.min = NetworkUtils.readBlockPos(stream);
            this.max = NetworkUtils.readBlockPos(stream);
        } else {
            this.min = null;
            this.max = null;
        }
    }

    @Override
    public void writeData(ByteBuf stream) {
        stream.writeByte((this.isInitialized() ? 64 : 0) | (this.isVisible ? 32 : 0) | this.kind.ordinal());
        if (this.isInitialized()) {
            NetworkUtils.writeBlockPos(stream, this.min);
            NetworkUtils.writeBlockPos(stream, this.max);
        }
    }

    public static enum Kind {
        LASER_RED,
        LASER_YELLOW,
        LASER_GREEN,
        LASER_BLUE,
        STRIPES,
        BLUE_STRIPES;

    }
}

