/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core;

import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatCrafting;
import net.minecraft.stats.StatList;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;

public enum BCStatCollector {
    INSTANCE;

    private final Map<Block, StatCrafting> blockMined = new IdentityHashMap<Block, StatCrafting>();
    private final Map<Item, StatCrafting> itemCrafted = new IdentityHashMap<Item, StatCrafting>();
    private final Map<Item, StatCrafting> itemUsed = new IdentityHashMap<Item, StatCrafting>();

    public static void registerStats(Block block) {
        if (!block.func_149652_G()) {
            return;
        }
        Item item = Item.func_150898_a((Block)block);
        if (item == null) {
            return;
        }
        String statName = BCStatCollector.toStatName(item);
        StatCrafting mineBlock = BCStatCollector.createCrafting("stat.mineBlock", statName, new ItemStack(block));
        StatList.field_75939_e.add(mineBlock);
        BCStatCollector.INSTANCE.blockMined.put(block, mineBlock);
        BCStatCollector.registerStats(item);
    }

    public static void registerStats(Item item) {
        String statName = BCStatCollector.toStatName(item);
        StatCrafting used = BCStatCollector.createCrafting("stat.useItem", statName, new ItemStack(item));
        StatCrafting craft = BCStatCollector.createCrafting("stat.craftItem", statName, new ItemStack(item));
        if (!(item instanceof ItemBlock)) {
            StatList.field_75938_d.add(used);
        }
        BCStatCollector.INSTANCE.itemUsed.put(item, used);
        BCStatCollector.INSTANCE.itemCrafted.put(item, craft);
    }

    public static StatCrafting createCrafting(String start, String statName, ItemStack stack) {
        Object[] translation = new Object[]{stack.func_151000_E()};
        StatCrafting stat = new StatCrafting(start + ".", statName, (IChatComponent)new ChatComponentTranslation(start, translation), stack.func_77973_b());
        stat.func_75971_g();
        return stat;
    }

    private static String toStatName(Item item) {
        ResourceLocation resourcelocation = (ResourceLocation)Item.field_150901_e.func_177774_c((Object)item);
        return resourcelocation != null ? resourcelocation.toString().replace(':', '.') : null;
    }

    public void serverStarting() {
        for (Map.Entry<Item, StatCrafting> crafted : this.itemUsed.entrySet()) {
            StatList.field_75929_E[Item.func_150891_b((Item)crafted.getKey())] = (StatBase)crafted.getValue();
        }
        for (Map.Entry<Item, StatCrafting> crafted : this.itemCrafted.entrySet()) {
            StatList.field_75928_D[Item.func_150891_b((Item)crafted.getKey())] = (StatBase)crafted.getValue();
        }
    }
}

