/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.gui;

import buildcraft.BuildCraftCore;
import buildcraft.api.filler.FillerManager;
import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.StatementMouseClick;
import buildcraft.api.tiles.IControllable;
import buildcraft.builders.TileFiller;
import buildcraft.builders.gui.ContainerFiller;
import buildcraft.core.builders.patterns.FillerPattern;
import buildcraft.core.client.CoreIconProvider;
import buildcraft.core.lib.config.OverridableConfigOption;
import buildcraft.core.lib.gui.AdvancedSlot;
import buildcraft.core.lib.gui.GuiAdvancedInterface;
import buildcraft.core.lib.gui.GuiTools;
import buildcraft.core.lib.gui.StatementParameterSlot;
import buildcraft.core.lib.gui.StatementSlot;
import buildcraft.core.lib.gui.buttons.ButtonTextureSet;
import buildcraft.core.lib.gui.buttons.GuiBetterButton;
import buildcraft.core.lib.gui.buttons.IButtonTextureSet;
import buildcraft.core.lib.gui.buttons.StandardButtonTextureSets;
import buildcraft.core.lib.gui.tooltips.ToolTip;
import buildcraft.core.lib.gui.tooltips.ToolTipLine;
import buildcraft.core.lib.network.command.CommandWriter;
import buildcraft.core.lib.network.command.PacketCommand;
import buildcraft.core.lib.utils.BCStringUtils;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;

public class GuiFiller
extends GuiAdvancedInterface {
    private static final OverridableConfigOption OPTION_EXTRA_MODE_FIRST = new OverridableConfigOption("gui.filler", "extra.modefirst", "true");
    private static final OverridableConfigOption OPTION_EXTRA_X_POS = new OverridableConfigOption("gui.filler", "extra.x", "38");
    private static final OverridableConfigOption OPTION_EXTRA_Y_POS = new OverridableConfigOption("gui.filler", "extra.y", "9");
    private static final ResourceLocation TEXTURE = new ResourceLocation("buildcraftbuilders:textures/gui/filler.png");
    private static final IButtonTextureSet EXCAVATE_OFF = new ButtonTextureSet(240, -16, 16, 16, TEXTURE);
    private static final IButtonTextureSet EXCAVATE_ON = new ButtonTextureSet(224, -16, 16, 16, TEXTURE);
    private final TileFiller filler;
    private final GuiFiller instance;
    private final StatementSlot fakeStatementSlot;

    public GuiFiller(EntityPlayer player, TileFiller filler) {
        super(new ContainerFiller(player, filler), filler, TEXTURE);
        this.filler = filler;
        this.instance = this;
        this.fakeStatementSlot = new StatementSlot(this.instance, -1, -1, 0){

            @Override
            public IStatement getStatement() {
                return ((GuiFiller)((GuiFiller)GuiFiller.this).instance).filler.currentPattern;
            }
        };
        this.field_146999_f = 175;
        this.field_147000_g = 240;
    }

    private IButtonTextureSet getExcavateTexture() {
        return this.filler.isExcavate() ? EXCAVATE_ON : EXCAVATE_OFF;
    }

    private GuiBetterButton getExcavateButton() {
        return new GuiBetterButton(2, this.field_147003_i + 150, this.field_147009_r + 30, 16, this.getExcavateTexture(), "").setToolTip(new ToolTip(500, new ToolTipLine(StatCollector.func_74838_a((String)("tip.filler.excavate." + (this.filler.isExcavate() ? "on" : "off"))))));
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.field_146292_n.add(new GuiBetterButton(0, this.field_147003_i + 38 - 18, this.field_147009_r + 30, 10, StandardButtonTextureSets.LEFT_BUTTON, ""));
        this.field_146292_n.add(new GuiBetterButton(1, this.field_147003_i + 38 + 16 + 8, this.field_147009_r + 30, 10, StandardButtonTextureSets.RIGHT_BUTTON, ""));
        this.field_146292_n.add(this.getExcavateButton());
        this.slots.clear();
        for (int i = 0; i < 4; ++i) {
            this.slots.add(new FillerParameterSlot(77 + i * 18, 30, i));
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button.field_146127_k == 0 && !this.filler.isPatternLocked()) {
            this.filler.currentPattern = (FillerPattern)FillerManager.registry.getPreviousPattern(this.filler.currentPattern);
        } else if (button.field_146127_k == 1 && !this.filler.isPatternLocked()) {
            this.filler.currentPattern = (FillerPattern)FillerManager.registry.getNextPattern(this.filler.currentPattern);
        } else if (button.field_146127_k == 2) {
            this.filler.setExcavate(!this.filler.isExcavate());
            this.field_146292_n.set(2, this.getExcavateButton());
            BuildCraftCore.instance.sendToServer(new PacketCommand(this.filler, "setFlags", new CommandWriter(){

                @Override
                public void write(ByteBuf data) {
                    data.writeBoolean(GuiFiller.this.filler.isExcavate());
                }
            }));
        }
        this.filler.rpcSetPatternFromString(this.filler.currentPattern.getUniqueTag());
    }

    @Override
    protected void func_73864_a(int x, int y, int k) throws IOException {
        int i;
        super.func_73864_a(x, y, k);
        AdvancedSlot slot = this.getSlotAtLocation(x, y);
        if (slot != null && !this.filler.isPatternLocked() && (i = ((FillerParameterSlot)slot).slot) < this.filler.patternParameters.length) {
            if (this.filler.patternParameters[i] != null) {
                this.filler.patternParameters[i].onClick(this.filler, this.filler.currentPattern, this.field_146297_k.field_71439_g.field_71071_by.func_70445_o(), new StatementMouseClick(k, GuiFiller.func_146272_n()));
            } else {
                this.filler.patternParameters[i] = this.filler.currentPattern.createParameter(i);
            }
            this.filler.rpcSetParameter(i, this.filler.patternParameters[i]);
        }
    }

    @Override
    protected void func_146976_a(float f, int mx, int my) {
        super.func_146976_a(f, mx, my);
        this.drawBackgroundSlots(mx, my);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        CoreIconProvider[] sprites = new CoreIconProvider[2];
        int count = 0;
        CoreIconProvider sprite = CoreIconProvider.getForControlMode(this.filler.getControlMode());
        if (this.filler.getControlMode() != IControllable.Mode.On && sprite != null) {
            sprites[count++] = sprite;
        }
        if (this.filler.isPatternLocked()) {
            sprites[count++] = CoreIconProvider.LOCK;
        }
        int xPos = OPTION_EXTRA_X_POS.getAsInt();
        int yPos = OPTION_EXTRA_Y_POS.getAsInt();
        if (count == 1) {
            CoreIconProvider first = sprites[0] == null ? sprites[1] : sprites[0];
            this.func_175175_a(this.field_147003_i + xPos, this.field_147009_r + yPos, first.getSprite(), 16, 16);
        } else if (count == 2) {
            if (!OPTION_EXTRA_MODE_FIRST.getAsBoolean()) {
                sprite = sprites[0];
                sprites[0] = sprites[1];
                sprites[1] = sprite;
            }
            this.func_175175_a(this.field_147003_i + xPos - 8, this.field_147009_r + yPos, sprites[0].getSprite(), 16, 16);
            this.func_175175_a(this.field_147003_i + xPos + 8, this.field_147009_r + yPos, sprites[1].getSprite(), 16, 16);
        }
    }

    @Override
    protected void func_146979_b(int mx, int my) {
        super.func_146979_b(mx, my);
        String title = BCStringUtils.localize("tile.fillerBlock.name");
        this.field_146289_q.func_78276_b(title, this.getCenteredOffset(title), 6, 0x404040);
        this.field_146289_q.func_78276_b(BCStringUtils.localize("gui.filling.resources"), 8, 74, 0x404040);
        this.field_146289_q.func_78276_b(BCStringUtils.localize("gui.inventory"), 8, 142, 0x404040);
        GuiTools.drawCenteredString(this.field_146289_q, this.filler.currentPattern.getDescription(), 56);
        this.drawTooltipForSlotAt(mx, my);
    }

    class FillerParameterSlot
    extends StatementParameterSlot {
        public FillerParameterSlot(int x, int y, int slot) {
            super(GuiFiller.this.instance, x, y, slot, GuiFiller.this.fakeStatementSlot);
        }

        @Override
        public IStatementParameter getParameter() {
            if (((GuiFiller)((GuiFiller)GuiFiller.this).instance).filler.patternParameters == null || this.slot >= ((GuiFiller)((GuiFiller)GuiFiller.this).instance).filler.patternParameters.length) {
                return null;
            }
            return ((GuiFiller)((GuiFiller)GuiFiller.this).instance).filler.patternParameters[this.slot];
        }

        @Override
        public void setParameter(IStatementParameter param, boolean notifyServer) {
        }
    }
}

