/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.gui;

import buildcraft.api.library.LibraryAPI;
import buildcraft.builders.TileBlueprintLibrary;
import buildcraft.builders.gui.ContainerBlueprintLibrary;
import buildcraft.core.blueprints.LibraryId;
import buildcraft.core.lib.gui.GuiBuildCraft;
import buildcraft.core.lib.utils.BCStringUtils;
import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiBlueprintLibrary
extends GuiBuildCraft {
    private static final ResourceLocation TEXTURE = new ResourceLocation("buildcraftbuilders:textures/gui/library_rw.png");
    private GuiButton deleteButton;
    private TileBlueprintLibrary library;

    public GuiBlueprintLibrary(EntityPlayer player, TileBlueprintLibrary library) {
        super(new ContainerBlueprintLibrary(player, library), library, TEXTURE);
        this.field_146999_f = 244;
        this.field_147000_g = 220;
        this.library = library;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.deleteButton = new GuiButton(2, this.field_147003_i + 174, this.field_147009_r + 109, 25, 20, BCStringUtils.localize("gui.del"));
        this.field_146292_n.add(this.deleteButton);
        this.library.refresh();
        this.checkDelete();
    }

    private ContainerBlueprintLibrary getLibraryContainer() {
        return (ContainerBlueprintLibrary)this.getContainer();
    }

    @Override
    protected void func_146979_b(int par1, int par2) {
        int off;
        String title = BCStringUtils.localize("tile.libraryBlock.name");
        this.field_146289_q.func_78276_b(title, this.getCenteredOffset(title), 6, 0x404040);
        for (int i = off = this.getLibraryContainer().scrollbarWidget.getPosition(); i < off + 12 && i < this.library.entries.size(); ++i) {
            LibraryId bpt = this.library.entries.get(i);
            String name = bpt.name;
            if (name.length() > 32) {
                name = name.substring(0, 32);
            }
            if (i == this.library.selected) {
                int l1 = 8;
                int i2 = 22;
                this.func_73733_a(l1, i2 + 9 * (i - off), l1 + 146, i2 + 9 * (i - off + 1), -2130706433, -2130706433);
            }
            while (this.field_146289_q.func_78256_a(name) > 151) {
                name = name.substring(0, name.length() - 1);
            }
            this.field_146289_q.func_78276_b(name, 9, 23 + 9 * (i - off), LibraryAPI.getHandlerFor(bpt.extension).getTextColor());
        }
    }

    @Override
    protected void func_146976_a(float f, int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(TEXTURE);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        this.getLibraryContainer().scrollbarWidget.hidden = this.library.entries.size() <= 12;
        this.getLibraryContainer().scrollbarWidget.setLength(Math.max(0, this.library.entries.size() - 12));
        this.drawWidgets(x, y);
        int inP = this.library.progressIn * 22 / 100;
        int outP = this.library.progressOut * 22 / 100;
        this.func_73729_b(this.field_147003_i + 194 + 22 - inP, this.field_147009_r + 57, 256 - inP, 240, inP, 16);
        this.func_73729_b(this.field_147003_i + 194, this.field_147009_r + 79, 234, 224, outP, 16);
    }

    protected void func_146284_a(GuiButton button) {
        if (this.deleteButton != null && button == this.deleteButton) {
            this.library.deleteSelectedBpt();
        }
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        int ySlot;
        super.func_73864_a(mouseX, mouseY, mouseButton);
        int x = mouseX - this.field_147003_i;
        int y = mouseY - this.field_147009_r;
        if (x >= 8 && x <= 161 && (ySlot = (y - 22) / 9 + this.getLibraryContainer().scrollbarWidget.getPosition()) > -1 && ySlot < this.library.entries.size()) {
            this.library.selectBlueprint(ySlot);
        }
        this.checkDelete();
    }

    protected void checkDelete() {
        this.deleteButton.field_146124_l = this.library.selected != -1;
    }
}

