/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.blueprints;

import buildcraft.BuildCraftBuilders;
import buildcraft.api.properties.BuildCraftProperties;
import buildcraft.builders.ItemBlueprint;
import buildcraft.builders.ItemBlueprintStandard;
import buildcraft.builders.ItemBlueprintTemplate;
import buildcraft.builders.TileArchitect;
import buildcraft.builders.TileBuilder;
import buildcraft.builders.TileConstructionMarker;
import buildcraft.core.blueprints.Blueprint;
import buildcraft.core.blueprints.BlueprintBase;
import buildcraft.core.blueprints.BptContext;
import buildcraft.core.blueprints.Template;
import buildcraft.core.lib.utils.BlockScanner;
import buildcraft.core.lib.utils.Utils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Vec3;
import net.minecraft.util.Vec3i;
import net.minecraft.world.World;

public class RecursiveBlueprintReader {
    private static final int SCANNER_ITERATION = 100;
    public TileArchitect architect;
    private BlockScanner blockScanner;
    private BlueprintBase writingBlueprint;
    private BptContext writingContext;
    private int subIndex = 0;
    private RecursiveBlueprintReader currentSubReader;
    private float computingTime = 0.0f;
    private boolean done = false;
    private BlueprintBase parentBlueprint;

    public RecursiveBlueprintReader(TileArchitect iArchitect) {
        this.architect = iArchitect;
        ItemStack stack = this.architect.func_70301_a(0);
        if (stack != null && stack.func_77973_b() instanceof ItemBlueprint && this.architect.box.isInitialized()) {
            this.blockScanner = new BlockScanner(this.architect.box, this.architect.func_145831_w(), 100);
            if (stack.func_77973_b() instanceof ItemBlueprintStandard) {
                this.writingBlueprint = new Blueprint(this.architect.box.size());
            } else if (stack.func_77973_b() instanceof ItemBlueprintTemplate) {
                this.writingBlueprint = new Template(this.architect.box.size());
            }
            this.writingContext = this.writingBlueprint.getContext(this.architect.func_145831_w(), this.architect.box);
            this.writingContext.readConfiguration = this.architect.readConfiguration;
            this.writingBlueprint.id.name = this.architect.name;
            this.writingBlueprint.author = this.architect.currentAuthorName;
            this.writingBlueprint.anchor = this.architect.func_174877_v().func_177973_b((Vec3i)this.architect.box.min());
        } else {
            this.done = true;
        }
    }

    protected RecursiveBlueprintReader(TileArchitect iArchitect, BlueprintBase iParentBlueprint) {
        this.parentBlueprint = iParentBlueprint;
        this.architect = iArchitect;
        if (this.architect.box.isInitialized()) {
            this.blockScanner = new BlockScanner(this.architect.box, this.architect.func_145831_w(), 100);
            if (this.parentBlueprint instanceof Blueprint) {
                this.writingBlueprint = new Blueprint(this.architect.box.size());
            } else if (this.parentBlueprint instanceof Template) {
                this.writingBlueprint = new Template(this.architect.box.size());
            }
            this.writingContext = this.writingBlueprint.getContext(this.architect.func_145831_w(), this.architect.box);
            this.writingContext.readConfiguration = this.architect.readConfiguration;
            this.writingBlueprint.id.name = this.architect.name;
            this.writingBlueprint.author = this.architect.currentAuthorName;
            this.writingBlueprint.anchor = this.architect.func_174877_v().func_177973_b((Vec3i)this.architect.box.min());
        }
    }

    public void iterate() {
        if (this.done) {
            return;
        }
        if (this.currentSubReader == null && this.subIndex < this.architect.subBlueprints.size()) {
            BlockPos subBlock = this.architect.subBlueprints.get(this.subIndex);
            TileEntity subTile = this.architect.func_145831_w().func_175625_s(subBlock);
            if (subTile instanceof TileArchitect) {
                TileArchitect subArchitect = (TileArchitect)subTile;
                this.currentSubReader = new RecursiveBlueprintReader(subArchitect, this.writingBlueprint);
            } else if (subTile instanceof TileConstructionMarker || subTile instanceof TileBuilder) {
                BlueprintBase blueprint = null;
                EnumFacing orientation = EnumFacing.EAST;
                if (subTile instanceof TileConstructionMarker) {
                    TileConstructionMarker marker = (TileConstructionMarker)subTile;
                    blueprint = ItemBlueprint.loadBlueprint(marker.itemBlueprint);
                    orientation = marker.direction;
                } else if (subTile instanceof TileBuilder) {
                    TileBuilder builder = (TileBuilder)subTile;
                    blueprint = ItemBlueprint.loadBlueprint(builder.func_70301_a(0));
                    orientation = ((EnumFacing)this.architect.func_145831_w().func_180495_p(subBlock).func_177229_b(BuildCraftProperties.BLOCK_FACING)).func_176734_d();
                }
                if (blueprint != null) {
                    BlockPos nPos = subTile.func_174877_v().func_177973_b((Vec3i)this.architect.getBox().min());
                    this.writingBlueprint.addSubBlueprint(blueprint, nPos, orientation);
                }
                ++this.subIndex;
            } else {
                ++this.subIndex;
            }
        } else if (this.currentSubReader != null) {
            this.currentSubReader.iterate();
            World world = this.currentSubReader.architect.func_145831_w();
            EnumFacing facing = ((EnumFacing)world.func_180495_p(this.currentSubReader.architect.func_174877_v()).func_177229_b(BuildCraftProperties.BLOCK_FACING)).func_176734_d();
            BlockPos pos = this.currentSubReader.architect.func_174877_v().func_177973_b((Vec3i)this.architect.getBox().min());
            if (this.currentSubReader.isDone()) {
                this.writingBlueprint.addSubBlueprint(this.currentSubReader.getBlueprint(), pos, facing);
                this.currentSubReader = null;
                ++this.subIndex;
            }
        } else if (this.blockScanner != null && this.blockScanner.blocksLeft() != 0) {
            for (BlockPos index : this.blockScanner) {
                this.writingBlueprint.readFromWorld(this.writingContext, this.architect, index);
            }
            this.computingTime = 1.0f - (float)this.blockScanner.blocksLeft() / (float)this.blockScanner.totalBlocks();
            if (this.blockScanner.blocksLeft() == 0) {
                this.writingBlueprint.readEntitiesFromWorld(this.writingContext, this.architect);
                Vec3 transform = Utils.VEC_ZERO.func_178788_d(Utils.convert((Vec3i)this.writingContext.surroundingBox().min()));
                this.writingBlueprint.translateToBlueprint(transform);
                EnumFacing o = ((EnumFacing)this.architect.func_145831_w().func_180495_p(this.architect.func_174877_v()).func_177229_b(BuildCraftProperties.BLOCK_FACING)).func_176734_d();
                this.writingBlueprint.rotate = this.architect.readConfiguration.rotate;
                this.writingBlueprint.excavate = this.architect.readConfiguration.excavate;
                if (this.writingBlueprint.rotate && o != EnumFacing.EAST) {
                    if (o == EnumFacing.SOUTH) {
                        this.writingBlueprint.rotateLeft(this.writingContext);
                        this.writingBlueprint.rotateLeft(this.writingContext);
                        this.writingBlueprint.rotateLeft(this.writingContext);
                    } else if (o == EnumFacing.WEST) {
                        this.writingBlueprint.rotateLeft(this.writingContext);
                        this.writingBlueprint.rotateLeft(this.writingContext);
                    } else if (o == EnumFacing.NORTH) {
                        this.writingBlueprint.rotateLeft(this.writingContext);
                    }
                }
            }
        } else if (this.blockScanner != null) {
            this.createBlueprint();
            this.done = true;
        }
    }

    private BlueprintBase getBlueprint() {
        return this.writingBlueprint;
    }

    public void createBlueprint() {
        this.writingBlueprint.id.name = this.architect.name;
        this.writingBlueprint.author = this.architect.currentAuthorName;
        NBTTagCompound nbt = this.writingBlueprint.getNBT();
        BuildCraftBuilders.serverDB.add(this.writingBlueprint.id, nbt);
        if (this.parentBlueprint == null) {
            this.architect.storeBlueprintStack(this.writingBlueprint.getStack());
        }
    }

    public boolean isDone() {
        return this.done;
    }

    public float getComputingProgressScaled() {
        float sections = this.architect.subBlueprints.size() + 1;
        float processed = this.subIndex;
        if (this.currentSubReader != null) {
            processed += this.currentSubReader.getComputingProgressScaled();
        }
        return (processed += this.computingTime) / sections;
    }
}

