/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.blueprints;

import buildcraft.core.Box;
import buildcraft.core.blueprints.Blueprint;
import buildcraft.core.blueprints.BlueprintBase;
import buildcraft.core.blueprints.BptBuilderBase;
import buildcraft.core.blueprints.BptBuilderBlueprint;
import buildcraft.core.blueprints.BptBuilderTemplate;
import buildcraft.core.blueprints.Template;
import java.util.ArrayList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class RecursiveBlueprintBuilder {
    private boolean returnedThis = false;
    private BlueprintBase blueprint;
    private RecursiveBlueprintBuilder current;
    private int nextSubBlueprint = 0;
    private ArrayList<NBTTagCompound> subBlueprints = new ArrayList();
    private BlockPos pos;
    private EnumFacing dir;
    private World world;
    private Box box = new Box();

    public RecursiveBlueprintBuilder(BlueprintBase iBlueprint, World iWorld, BlockPos pos, EnumFacing iDir) {
        this.blueprint = iBlueprint;
        this.subBlueprints = iBlueprint.subBlueprintsNBT;
        this.world = iWorld;
        this.pos = pos;
        this.dir = iDir;
    }

    public BptBuilderBase nextBuilder() {
        BptBuilderBase builder;
        if (!this.returnedThis) {
            BptBuilderBase builder2;
            this.blueprint = this.blueprint.adjustToWorld(this.world, this.pos, this.dir);
            this.returnedThis = true;
            if (this.blueprint instanceof Blueprint) {
                builder2 = new BptBuilderBlueprint((Blueprint)this.blueprint, this.world, this.pos);
            } else if (this.blueprint instanceof Template) {
                builder2 = new BptBuilderTemplate(this.blueprint, this.world, this.pos);
            } else {
                return null;
            }
            this.box.initialize(builder2);
            return builder2;
        }
        this.blueprint = null;
        if (this.current != null && (builder = this.current.nextBuilder()) != null) {
            return builder;
        }
        if (this.nextSubBlueprint >= this.subBlueprints.size()) {
            return null;
        }
        NBTTagCompound nbt = this.subBlueprints.get(this.nextSubBlueprint);
        BlueprintBase bpt = BlueprintBase.loadBluePrint(nbt.func_74775_l("bpt"));
        int nx = this.box.min().func_177958_n() + nbt.func_74762_e("x");
        int ny = this.box.min().func_177956_o() + nbt.func_74762_e("y");
        int nz = this.box.min().func_177952_p() + nbt.func_74762_e("z");
        EnumFacing nbtDir = EnumFacing.values()[nbt.func_74771_c("dir")];
        this.current = new RecursiveBlueprintBuilder(bpt, this.world, new BlockPos(nx, ny, nz), nbtDir);
        ++this.nextSubBlueprint;
        return this.current.nextBuilder();
    }
}

