/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.blueprints;

import buildcraft.api.blueprints.BlueprintDeployer;
import buildcraft.builders.LibraryDatabase;
import buildcraft.core.blueprints.Blueprint;
import buildcraft.core.blueprints.BlueprintBase;
import buildcraft.core.blueprints.BptBuilderBlueprint;
import buildcraft.core.blueprints.BptContext;
import buildcraft.core.blueprints.LibraryId;
import buildcraft.core.lib.utils.NBTUtils;
import buildcraft.core.lib.utils.Utils;
import java.io.File;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Vec3;
import net.minecraft.util.Vec3i;
import net.minecraft.world.World;

public class RealBlueprintDeployer
extends BlueprintDeployer {
    public static final RealBlueprintDeployer realInstance = new RealBlueprintDeployer();

    @Override
    public void deployBlueprint(World world, BlockPos pos, EnumFacing dir, File file) {
        this.deployBlueprint(world, pos, dir, (Blueprint)BlueprintBase.loadBluePrint(LibraryDatabase.load(file)));
    }

    @Override
    public void deployBlueprintFromFileStream(World world, BlockPos pos, EnumFacing dir, byte[] data) {
        this.deployBlueprint(world, pos, dir, (Blueprint)BlueprintBase.loadBluePrint(NBTUtils.load(data)));
    }

    public void deployBlueprint(World world, BlockPos pos, EnumFacing dir, Blueprint bpt) {
        bpt.id = new LibraryId();
        bpt.id.extension = "bpt";
        BptContext context = bpt.getContext(world, bpt.getBoxForPos(pos));
        if (bpt.rotate && dir != EnumFacing.EAST) {
            if (dir == EnumFacing.SOUTH) {
                bpt.rotateLeft(context);
            } else if (dir == EnumFacing.WEST) {
                bpt.rotateLeft(context);
                bpt.rotateLeft(context);
            } else if (dir == EnumFacing.NORTH) {
                bpt.rotateLeft(context);
                bpt.rotateLeft(context);
                bpt.rotateLeft(context);
            }
        }
        Vec3 transform = Utils.convert((Vec3i)pos).func_178788_d(Utils.convert((Vec3i)bpt.anchor));
        bpt.translateToWorld(transform);
        new BptBuilderBlueprint(bpt, world, pos).deploy();
    }
}

