/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders;

import buildcraft.BuildCraftBuilders;
import buildcraft.api.tools.IToolWrench;
import buildcraft.builders.TileQuarry;
import buildcraft.core.lib.block.BlockBuildCraft;
import buildcraft.core.lib.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockQuarry
extends BlockBuildCraft {
    public BlockQuarry() {
        super(Material.field_151573_f, FACING_PROP, LED_DONE, LED_POWER, CONNECTED_UP, CONNECTED_DOWN, CONNECTED_EAST, CONNECTED_WEST, CONNECTED_NORTH, CONNECTED_SOUTH);
        this.func_149711_c(10.0f);
        this.func_149752_b(10.0f);
        this.func_149672_a(field_149788_p);
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entityliving, ItemStack stack) {
        TileEntity tile;
        super.func_180633_a(world, pos, state, entityliving, stack);
        if (entityliving instanceof EntityPlayer && (tile = world.func_175625_s(pos)) instanceof TileQuarry) {
            ((TileQuarry)tile).placedBy = (EntityPlayer)entityliving;
        }
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileQuarry();
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess access, BlockPos pos) {
        state = super.func_176221_a(state, access, pos);
        TileEntity tile = access.func_175625_s(pos);
        if (tile == null | !(tile instanceof TileQuarry)) {
            return state;
        }
        TileQuarry quarry = (TileQuarry)tile;
        for (EnumFacing face : EnumFacing.field_82609_l) {
            TileEntity other = access.func_175625_s(pos.func_177972_a(face));
            boolean hasPipe = Utils.checkPipesConnections(quarry, other);
            state = state.func_177226_a((IProperty)CONNECTED_MAP.get(face), (Comparable)Boolean.valueOf(hasPipe));
        }
        return state;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        if (BuildCraftBuilders.quarryOneTimeUse) {
            return new ArrayList<ItemStack>();
        }
        return super.getDrops(world, pos, state, fortune);
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if (world.field_72995_K) {
            return;
        }
        BuildCraftBuilders.frameBlock.removeNeighboringFrames(world, pos);
        super.func_180663_b(world, pos, state);
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer entityplayer, EnumFacing facing, float hitX, float hitY, float hitZ) {
        Item equipped;
        if (super.func_180639_a(world, pos, state, entityplayer, facing, hitX, hitY, hitZ)) {
            return true;
        }
        TileQuarry tile = (TileQuarry)world.func_175625_s(pos);
        if (entityplayer.func_70093_af()) {
            return false;
        }
        Item item = equipped = entityplayer.func_71045_bC() != null ? entityplayer.func_71045_bC().func_77973_b() : null;
        if (equipped instanceof IToolWrench && ((IToolWrench)equipped).canWrench(entityplayer, pos)) {
            tile.reinitalize();
            ((IToolWrench)equipped).wrenchUsed(entityplayer, pos);
            return true;
        }
        return false;
    }

    public boolean isSideSolid(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }
}

