/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders;

import buildcraft.api.properties.BuildCraftProperty;
import buildcraft.builders.schematics.SchematicFrame;
import buildcraft.core.lib.block.BlockBuildCraftBase;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.util.IStringSerializable;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockFrame
extends BlockBuildCraftBase {
    private static final Map<EnumFacing[], EFrameConnection> connectionMap = Maps.newHashMap();
    public static final BuildCraftProperty<EFrameConnection> CONNECTIONS = BuildCraftProperty.create("connections", EFrameConnection.class);

    public BlockFrame() {
        super(Material.field_151592_s, CONNECTIONS);
        this.func_149647_a(null);
        this.func_149711_c(0.5f);
        this.func_149713_g(0);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if (world.field_72995_K) {
            return;
        }
        this.removeNeighboringFrames(world, pos);
    }

    public void removeNeighboringFrames(World world, BlockPos pos) {
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            BlockPos nPos = pos.func_177972_a(dir);
            Block nBlock = world.func_180495_p(nPos).func_177230_c();
            if (nBlock != this) continue;
            world.func_175698_g(nPos);
        }
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return 3;
    }

    public Item func_180660_a(IBlockState state, Random random, int fortune) {
        return null;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return Lists.newArrayList();
    }

    @Override
    public AxisAlignedBB getBox(IBlockAccess world, BlockPos pos, IBlockState state) {
        return ((EFrameConnection)((Object)state.func_177229_b(BlockFrame.CONNECTIONS))).boundingBox;
    }

    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        list.add(new ItemStack((Block)this));
    }

    @SideOnly(value=Side.CLIENT)
    public EnumWorldBlockLayer func_180664_k() {
        return EnumWorldBlockLayer.CUTOUT;
    }

    public static enum EFrameConnection implements IStringSerializable
    {
        UP_DOWN(EnumFacing.UP, EnumFacing.DOWN),
        EAST_WEST(EnumFacing.EAST, EnumFacing.WEST),
        NORTH_SOUTH(EnumFacing.NORTH, EnumFacing.SOUTH),
        NORTH_EAST_UP(EnumFacing.NORTH, EnumFacing.EAST, EnumFacing.UP),
        NORTH_EAST_DOWN(EnumFacing.NORTH, EnumFacing.EAST, EnumFacing.DOWN),
        NORTH_WEST_UP(EnumFacing.NORTH, EnumFacing.WEST, EnumFacing.UP),
        NORTH_WEST_DOWN(EnumFacing.NORTH, EnumFacing.WEST, EnumFacing.DOWN),
        SOUTH_EAST_UP(EnumFacing.SOUTH, EnumFacing.EAST, EnumFacing.UP),
        SOUTH_EAST_DOWN(EnumFacing.SOUTH, EnumFacing.EAST, EnumFacing.DOWN),
        SOUTH_WEST_UP(EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.UP),
        SOUTH_WEST_DOWN(EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.DOWN);

        final AxisAlignedBB boundingBox;
        private final EnumFacing[] facings;
        private EFrameConnection left;
        private SchematicFrame schematic;

        private EFrameConnection(EnumFacing ... facings) {
            this.facings = facings;
            AxisAlignedBB bb = new AxisAlignedBB(0.25, 0.25, 0.25, 0.75, 0.75, 0.75);
            for (EnumFacing face : facings) {
                bb = bb.func_72321_a((double)face.func_82601_c() * 0.25, (double)face.func_96559_d() * 0.25, (double)face.func_82599_e() * 0.25);
            }
            this.boundingBox = bb;
            connectionMap.put(facings, this);
        }

        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public EFrameConnection rotateLeft() {
            if (this.left != null) {
                return this.left;
            }
            EnumFacing[] nArray = new EnumFacing[this.facings.length];
            int i = 0;
            for (EnumFacing face : this.facings) {
                nArray[i] = face.func_176740_k() != EnumFacing.Axis.Y ? face.func_176732_a(EnumFacing.Axis.Y) : face;
                ++i;
            }
            this.left = (EFrameConnection)((Object)connectionMap.get(nArray));
            return this.left;
        }

        public SchematicFrame getSchematic() {
            if (this.schematic == null) {
                this.schematic = new SchematicFrame(this);
            }
            return this.schematic;
        }
    }
}

