/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.transport.pluggable;

import buildcraft.api.transport.pluggable.IPluggableModelBaker;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;

public abstract class PluggableModelKey<K extends PluggableModelKey<K>> {
    public final EnumWorldBlockLayer layer;
    public final IPluggableModelBaker<K> baker;
    public final EnumFacing side;
    private final int hash;

    public PluggableModelKey(EnumWorldBlockLayer layer, IPluggableModelBaker<K> baker, EnumFacing side) {
        this.layer = layer;
        if (layer != EnumWorldBlockLayer.CUTOUT && layer != EnumWorldBlockLayer.TRANSLUCENT) {
            throw new IllegalArgumentException("Can only use CUTOUT or TRANSLUCENT at the moment (was " + layer + ")");
        }
        if (baker == null) {
            throw new NullPointerException("baker");
        }
        this.baker = baker;
        this.side = side;
        this.hash = Arrays.hashCode(new int[]{System.identityHashCode(baker), Objects.hashCode(side)});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PluggableModelKey other = (PluggableModelKey)obj;
        if (this.baker != other.baker) {
            return false;
        }
        return this.side == other.side;
    }

    public int hashCode() {
        return this.hash;
    }
}

