/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.transport;

import buildcraft.api.transport.IStripesHandler;
import buildcraft.api.transport.pluggable.PipePluggable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;

public abstract class PipeManager {
    public static List<IStripesHandler> stripesHandlers = new ArrayList<IStripesHandler>();
    public static ArrayList<Class<? extends PipePluggable>> pipePluggables = new ArrayList();
    private static Map<String, Class<? extends PipePluggable>> pipePluggableNames = new HashMap<String, Class<? extends PipePluggable>>();
    private static Map<Class<? extends PipePluggable>, String> pipePluggableByNames = new HashMap<Class<? extends PipePluggable>, String>();
    private static Map<IStripesHandler, Integer> stripesHandlerPriorities = new HashMap<IStripesHandler, Integer>();

    @Deprecated
    public static boolean canExtractItems(Object extractor, World world, BlockPos pos) {
        return true;
    }

    @Deprecated
    public static boolean canExtractFluids(Object extractor, World world, BlockPos pos) {
        return true;
    }

    @Deprecated
    public static void registerStripesHandler(IStripesHandler handler) {
        PipeManager.registerStripesHandler(handler, 0);
    }

    public static void registerStripesHandler(IStripesHandler handler, int priority) {
        stripesHandlers.add(handler);
        stripesHandlerPriorities.put(handler, priority);
        Collections.sort(stripesHandlers, new Comparator<IStripesHandler>(){

            @Override
            public int compare(IStripesHandler o1, IStripesHandler o2) {
                return (Integer)stripesHandlerPriorities.get(o2) - (Integer)stripesHandlerPriorities.get(o1);
            }
        });
    }

    public static void registerPipePluggable(Class<? extends PipePluggable> pluggable, String name) {
        pipePluggables.add(pluggable);
        pipePluggableNames.put(name, pluggable);
        pipePluggableByNames.put(pluggable, name);
    }

    public static Class<?> getPluggableByName(String pluggableName) {
        return pipePluggableNames.get(pluggableName);
    }

    public static String getPluggableName(Class<? extends PipePluggable> aClass) {
        return pipePluggableByNames.get(aClass);
    }
}

