/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.properties;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.properties.PropertyHelper;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.MathHelper;

public class BuildCraftProperty<T extends Comparable<T>>
extends PropertyHelper<T> {
    private final String name;
    private final Class<T> clazz;
    protected final List<T> values;

    public BuildCraftProperty(String name, Class<T> clazz, T[] values) {
        this(name, clazz, Arrays.asList(values));
    }

    public BuildCraftProperty(String name, Class<T> clazz, List<T> values) {
        super(name, clazz);
        this.name = name;
        this.clazz = clazz;
        this.values = values;
    }

    protected BuildCraftProperty(String name, Class<T> clazz) {
        super(name, clazz);
        this.name = name;
        this.clazz = clazz;
        this.values = Collections.emptyList();
    }

    public static <E extends Enum<E>> BuildCraftProperty<E> create(String name, Class<E> enumeration) {
        List<E> values = Arrays.asList(enumeration.getEnumConstants());
        return new BuildCraftProperty<E>(name, enumeration, values);
    }

    public static <E extends Enum<E>> BuildCraftProperty<E> create(String name, E ... values) {
        Class<E> clazz = ((Enum)values[0]).getDeclaringClass();
        List<E> list = Arrays.asList(values);
        return new BuildCraftProperty<E>(name, clazz, list);
    }

    public static BuildCraftProperty<Boolean> create(String name, boolean first) {
        return new BuildCraftProperty(name, Boolean.class, (Comparable[])new Boolean[]{first, !first});
    }

    public static BuildCraftProperty<Integer> create(String name, int first, int last) {
        return BuildCraftProperty.create(name, first, last, 1);
    }

    public static BuildCraftProperty<Integer> create(String name, int first, int last, int difference) {
        int actualDiff = Math.abs(difference);
        int number = MathHelper.func_76141_d((float)((float)Math.abs(first - last) / (float)actualDiff + 1.0f));
        Comparable[] array = new Integer[number];
        int addedDiff = actualDiff * (first > last ? -1 : 1);
        int current = first;
        for (int i = 0; i < array.length; ++i) {
            array[i] = current;
            current += addedDiff;
        }
        return new BuildCraftProperty(name, Integer.class, array);
    }

    public static BuildCraftProperty<Double> create(String name, double first, double last) {
        return BuildCraftProperty.create(name, first, last, 1.0);
    }

    public static BuildCraftProperty<Double> create(String name, double first, double last, double difference) {
        double actualDiff = Math.abs(difference);
        Comparable[] array = new Double[(int)(Math.abs(first - last) / actualDiff)];
        double addedDiff = actualDiff * (double)(first > last ? -1 : 1);
        for (int i = 0; i <= array.length; ++i) {
            array[i] = Double.valueOf(first + (first - last) / addedDiff * (double)i);
        }
        return new BuildCraftProperty(name, Double.class, array);
    }

    public String func_177701_a() {
        return this.name;
    }

    public List<T> getAllowedValues() {
        return this.values;
    }

    public Class<T> func_177699_b() {
        return this.clazz;
    }

    public String func_177702_a(Comparable value) {
        return this.valueName(value);
    }

    protected String valueName(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof IStringSerializable) {
            return ((IStringSerializable)value).func_176610_l();
        }
        if (value instanceof Enum) {
            return ((Enum)value).name();
        }
        return value.toString();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BuildCraftProperty [name=");
        builder.append(this.name);
        builder.append(", clazz=");
        builder.append(this.clazz);
        builder.append(", values=");
        builder.append(this.values);
        builder.append("]");
        return builder.toString();
    }
}

