/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.properties;

import buildcraft.api.properties.BuildCraftProperty;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class BuildCraftExtendedProperty<T extends Comparable<T>>
extends BuildCraftProperty<T>
implements IUnlistedProperty<T> {
    private final Predicate<T> function;

    public BuildCraftExtendedProperty(String name, Class<T> clazz, Predicate<T> allowingFunction) {
        super(name, clazz);
        this.function = allowingFunction;
    }

    public BuildCraftExtendedProperty(String name, Class<T> clazz, List<T> allowedValues) {
        super(name, clazz, allowedValues);
        this.function = null;
    }

    public static BuildCraftExtendedProperty<Double> create(String name, final double min, final double max) {
        return new BuildCraftExtendedProperty<Double>(name, Double.class, new Predicate<Double>(){

            public boolean apply(Double input) {
                return input >= min && input <= max;
            }
        });
    }

    public static <T extends Comparable<T>> BuildCraftExtendedProperty<T> createExtended(String name, Class clazz) {
        return new BuildCraftExtendedProperty<T>(name, clazz, Predicates.alwaysTrue());
    }

    public boolean isValid(T value) {
        if (this.function == null) {
            return this.values.contains(value);
        }
        return this.function.apply(value);
    }

    public Class<T> getType() {
        return this.func_177699_b();
    }

    public String valueToString(T value) {
        return this.valueName(value);
    }

    public T getUnlistedValue(IExtendedBlockState state) {
        return (T)((Comparable)state.getValue(this.asUnlistedProperty()));
    }

    public IUnlistedProperty<T> asUnlistedProperty() {
        return this;
    }
}

