/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.blueprints;

import buildcraft.api.blueprints.IBuilderContext;
import buildcraft.api.blueprints.MappingRegistry;
import buildcraft.api.blueprints.SchematicBlockBase;
import buildcraft.api.core.BuildCraftAPI;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.WorldServer;

public class SchematicMask
extends SchematicBlockBase {
    public boolean isConcrete = true;

    public SchematicMask() {
    }

    public SchematicMask(boolean isConcrete) {
        this.isConcrete = isConcrete;
    }

    @Override
    public void placeInWorld(IBuilderContext context, BlockPos pos, List<ItemStack> stacks) {
        if (this.isConcrete) {
            if (stacks.size() == 0 || !BuildCraftAPI.isSoftBlock(context.world(), pos)) {
                return;
            }
            ItemStack stack = stacks.get(0);
            EntityPlayer player = (EntityPlayer)BuildCraftAPI.proxy.getBuildCraftPlayer((WorldServer)context.world(), pos).get();
            context.world().func_175698_g(pos);
            EnumFacing solidFace = null;
            for (EnumFacing face : EnumFacing.values()) {
                BlockPos offset = pos.func_177972_a(face);
                if (BuildCraftAPI.isSoftBlock(context.world(), offset)) continue;
                solidFace = face;
                break;
            }
            ItemBlock itemBlock = (ItemBlock)stack.func_77973_b();
            IBlockState state = itemBlock.field_150939_a.func_180642_a(context.world(), pos, solidFace, 0.0f, 0.0f, 0.0f, stack.func_77960_j(), (EntityLivingBase)player);
            itemBlock.placeBlockAt(stack, player, context.world(), pos, solidFace, 0.0f, 0.0f, 0.0f, state);
        } else {
            context.world().func_175698_g(pos);
        }
    }

    @Override
    public boolean isAlreadyBuilt(IBuilderContext context, BlockPos pos) {
        if (this.isConcrete) {
            return !BuildCraftAPI.getWorldProperty("replaceable").get(context.world(), pos);
        }
        return BuildCraftAPI.getWorldProperty("replaceable").get(context.world(), pos);
    }

    @Override
    public void writeSchematicToNBT(NBTTagCompound nbt, MappingRegistry registry) {
        nbt.func_74757_a("isConcrete", this.isConcrete);
    }

    @Override
    public void readSchematicFromNBT(NBTTagCompound nbt, MappingRegistry registry) {
        this.isConcrete = nbt.func_74767_n("isConcrete");
    }
}

