/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api;

import buildcraft.api.core.BCLog;
import java.util.Arrays;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import org.apache.commons.lang3.StringUtils;

public class APIHelper {
    public static <T> T getInstance(String clsName, Class<T> baseVersion) {
        return APIHelper.getNamedInstance(clsName, "INSTANCE", baseVersion);
    }

    public static <T> T getInstance(String clsName, Class<T> baseVersion, T nullVersion) {
        return APIHelper.getNamedInstance(clsName, "INSTANCE", baseVersion, nullVersion);
    }

    public static <T> T getNamedInstance(String clsName, String enumName, Class<T> baseVersion) {
        T instance = APIHelper.getNamedInstance(clsName, enumName, baseVersion, null);
        if (instance != null) {
            return instance;
        }
        Class<?>[] types = baseVersion.getClasses();
        Class<?> voidType = null;
        for (Class<?> class1 : types) {
            if (!baseVersion.isAssignableFrom(class1)) continue;
            voidType = class1;
        }
        if (voidType != null) {
            Enum[] eArr;
            T[] arr = voidType.getEnumConstants();
            if (arr == null) {
                return null;
            }
            for (Enum e : eArr = (Enum[])voidType.getEnumConstants()) {
                if (!e.name().equals(enumName) || !baseVersion.isInstance(e)) continue;
                return (T)e;
            }
        }
        return null;
    }

    public static <T> T getNamedInstance(String clsName, String enumName, Class<T> baseVersion, T nullVersion) {
        if (!Loader.instance().hasReachedState(LoaderState.PREINITIALIZATION)) {
            throw new IllegalStateException("Called this API too early, you are not allowed to use BC api before pre init!");
        }
        try {
            Enum[] enumArr;
            Class<?> cls = Class.forName(clsName);
            ?[] arr = cls.getEnumConstants();
            if (arr == null) {
                return APIHelper.fail(clsName, nullVersion);
            }
            for (Enum e : enumArr = (Enum[])cls.getEnumConstants()) {
                if (!e.name().equals(enumName) || !baseVersion.isInstance(e)) continue;
                return (T)e;
            }
            return APIHelper.fail(clsName, nullVersion);
        }
        catch (ClassNotFoundException e) {
            return APIHelper.fail(clsName, nullVersion);
        }
    }

    private static <M> M fail(String clsName, M failure) {
        String module;
        Object[] split = clsName.split("\\.");
        if (split.length < 2) {
            BCLog.logger.warn("Tried and failed to get the module name from " + Arrays.toString(split) + " (" + clsName + ")!");
            module = "invalid";
        } else {
            module = split[1];
        }
        module = StringUtils.capitalize((String)module);
        String bcMod = "BuildCraft|" + module;
        if (Loader.isModLoaded((String)bcMod)) {
            BCLog.logger.warn("Failed to load the  " + clsName + " dispite the appropriate buildcraft module being installed (" + module + ")");
        }
        return failure;
    }
}

