/*
 * Decompiled with CFR 0.152.
 */
package buildcraft;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftMod;
import buildcraft.api.recipes.BuildcraftRecipeRegistry;
import buildcraft.core.BCRegistry;
import buildcraft.core.CompatHooks;
import buildcraft.core.InterModComms;
import buildcraft.core.config.ConfigManager;
import buildcraft.core.lib.items.ItemBuildCraft;
import buildcraft.core.lib.network.base.ChannelHandler;
import buildcraft.core.lib.network.base.PacketHandler;
import buildcraft.silicon.BlockLaser;
import buildcraft.silicon.BlockLaserTable;
import buildcraft.silicon.ItemLaserTable;
import buildcraft.silicon.ItemRedstoneChipset;
import buildcraft.silicon.SiliconGuiHandler;
import buildcraft.silicon.SiliconProxy;
import buildcraft.silicon.TileAdvancedCraftingTable;
import buildcraft.silicon.TileAssemblyTable;
import buildcraft.silicon.TileChargingTable;
import buildcraft.silicon.TileIntegrationTable;
import buildcraft.silicon.TileLaser;
import buildcraft.silicon.TileProgrammingTable;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Achievement;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLMissingMappingsEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;

@Mod(name="BuildCraft Silicon", version="7.2.7", useMetadata=false, modid="BuildCraft|Silicon", dependencies="required-after:BuildCraft|Core@7.2.7", acceptedMinecraftVersions="[1.8.9]")
public class BuildCraftSilicon
extends BuildCraftMod {
    @Mod.Instance(value="BuildCraft|Silicon")
    public static BuildCraftSilicon instance;
    public static ItemRedstoneChipset redstoneChipset;
    public static BlockLaser laserBlock;
    public static BlockLaserTable assemblyTableBlock;
    public static Item redstoneCrystal;
    public static Achievement timeForSomeLogicAchievement;
    public static Achievement tinglyLaserAchievement;
    public static float chipsetCostMultiplier;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        BuildCraftCore.mainConfigManager.register("power.chipsetCostMultiplier", 1.0, "The cost multiplier for Chipsets", ConfigManager.RestartRequirement.GAME);
        BuildCraftCore.mainConfiguration.save();
        chipsetCostMultiplier = (float)BuildCraftCore.mainConfigManager.get("power.chipsetCostMultiplier").getDouble();
        if (BuildCraftCore.mainConfiguration.hasChanged()) {
            BuildCraftCore.mainConfiguration.save();
        }
        laserBlock = (BlockLaser)CompatHooks.INSTANCE.getBlock(BlockLaser.class);
        laserBlock.func_149663_c("laserBlock");
        BCRegistry.INSTANCE.registerBlock(laserBlock, false);
        assemblyTableBlock = (BlockLaserTable)CompatHooks.INSTANCE.getBlock(BlockLaserTable.class);
        assemblyTableBlock.func_149663_c("laserTableBlock");
        BCRegistry.INSTANCE.registerBlock(assemblyTableBlock, ItemLaserTable.class, false);
        redstoneChipset = new ItemRedstoneChipset();
        redstoneChipset.func_77655_b("redstoneChipset");
        BCRegistry.INSTANCE.registerItem(redstoneChipset, false);
        redstoneChipset.registerItemStacks();
        redstoneCrystal = new ItemBuildCraft().func_77655_b("redstoneCrystal");
        if (BCRegistry.INSTANCE.registerItem(redstoneCrystal, false)) {
            OreDictionary.registerOre((String)"redstoneCrystal", (ItemStack)new ItemStack(redstoneCrystal));
            OreDictionary.registerOre((String)"crystalRedstone", (ItemStack)new ItemStack(redstoneCrystal));
        }
        SiliconProxy.proxy.preInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        this.channels = NetworkRegistry.INSTANCE.newChannel("BC-SILICON", new io.netty.channel.ChannelHandler[]{new ChannelHandler(), new PacketHandler()});
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new SiliconGuiHandler());
        BCRegistry.INSTANCE.registerTileEntity(TileLaser.class, "buildcraft.silicon.TileLaser", "net.minecraft.src.buildcraft.factory.TileLaser");
        BCRegistry.INSTANCE.registerTileEntity(TileAssemblyTable.class, "buildcraft.silicon.TileAssemblyTable", "net.minecraft.src.buildcraft.factory.TileAssemblyTable");
        BCRegistry.INSTANCE.registerTileEntity(TileAdvancedCraftingTable.class, "buildcraft.silicon.TileAdvancedCraftingTable", "net.minecraft.src.buildcraft.factory.TileAssemblyAdvancedWorkbench");
        BCRegistry.INSTANCE.registerTileEntity(TileIntegrationTable.class, "buildcraft.silicon.TileIntegrationTable", "net.minecraft.src.buildcraft.factory.TileIntegrationTable");
        BCRegistry.INSTANCE.registerTileEntity(TileChargingTable.class, "buildcraft.silicon.TileChargingTable", "net.minecraft.src.buildcraft.factory.TileChargingTable");
        BCRegistry.INSTANCE.registerTileEntity(TileProgrammingTable.class, "buildcraft.silicon.TileProgrammingTable", "net.minecraft.src.buildcraft.factory.TileProgrammingTable");
        timeForSomeLogicAchievement = BuildCraftCore.achievementManager.registerAchievement(new Achievement("buildcraft|silicon:achievement.timeForSomeLogic", "timeForSomeLogicAchievement", 9, -2, (Block)assemblyTableBlock, BuildCraftCore.diamondGearAchievement));
        tinglyLaserAchievement = BuildCraftCore.achievementManager.registerAchievement(new Achievement("buildcraft|silicon:achievement.tinglyLaser", "tinglyLaserAchievement", 11, -2, (Block)laserBlock, timeForSomeLogicAchievement));
        if (BuildCraftCore.loadDefaultRecipes) {
            BuildCraftSilicon.loadRecipes();
        }
        SiliconProxy.proxy.registerRenderers();
    }

    public static void loadRecipes() {
        BCRegistry.INSTANCE.addCraftingRecipe(new ItemStack((Block)laserBlock), "ORR", "DDR", "ORR", Character.valueOf('O'), Blocks.field_150343_Z, Character.valueOf('R'), "dustRedstone", Character.valueOf('D'), "gemDiamond");
        BCRegistry.INSTANCE.addCraftingRecipe(new ItemStack((Block)laserBlock), "RRO", "RDD", "RRO", Character.valueOf('O'), Blocks.field_150343_Z, Character.valueOf('R'), "dustRedstone", Character.valueOf('D'), "gemDiamond");
        BCRegistry.INSTANCE.addCraftingRecipe(new ItemStack((Block)laserBlock), "RRR", "RDR", "ODO", Character.valueOf('O'), Blocks.field_150343_Z, Character.valueOf('R'), "dustRedstone", Character.valueOf('D'), "gemDiamond");
        BCRegistry.INSTANCE.addCraftingRecipe(new ItemStack((Block)laserBlock), "ODO", "RDR", "RRR", Character.valueOf('O'), Blocks.field_150343_Z, Character.valueOf('R'), "dustRedstone", Character.valueOf('D'), "gemDiamond");
        BCRegistry.INSTANCE.addCraftingRecipe(new ItemStack((Block)assemblyTableBlock, 1, 0), "ODO", "ORO", "OGO", Character.valueOf('O'), Blocks.field_150343_Z, Character.valueOf('R'), "dustRedstone", Character.valueOf('D'), "gemDiamond", Character.valueOf('G'), "gearDiamond");
        BCRegistry.INSTANCE.addCraftingRecipe(new ItemStack((Block)assemblyTableBlock, 1, 1), "OWO", "OCO", "ORO", Character.valueOf('O'), Blocks.field_150343_Z, Character.valueOf('W'), Blocks.field_150462_ai, Character.valueOf('C'), Blocks.field_150486_ae, Character.valueOf('R'), new ItemStack((Item)redstoneChipset, 1, 0));
        BCRegistry.INSTANCE.addCraftingRecipe(new ItemStack((Block)assemblyTableBlock, 1, 2), "OIO", "OCO", "OGO", Character.valueOf('O'), Blocks.field_150343_Z, Character.valueOf('I'), "ingotGold", Character.valueOf('C'), new ItemStack((Item)redstoneChipset, 1, 0), Character.valueOf('G'), "gearDiamond");
        BCRegistry.INSTANCE.addCraftingRecipe(new ItemStack((Block)assemblyTableBlock, 1, 3), "OIO", "OCO", "OGO", Character.valueOf('O'), Blocks.field_150343_Z, Character.valueOf('I'), "dustRedstone", Character.valueOf('C'), new ItemStack((Item)redstoneChipset, 1, 0), Character.valueOf('G'), "gearGold");
        BCRegistry.INSTANCE.addCraftingRecipe(new ItemStack((Block)assemblyTableBlock, 1, 4), "OCO", "ORO", "OGO", Character.valueOf('O'), Blocks.field_150343_Z, Character.valueOf('R'), new ItemStack((Item)redstoneChipset, 1, 0), Character.valueOf('C'), "gemEmerald", Character.valueOf('G'), "gearDiamond");
        BuildcraftRecipeRegistry.assemblyTable.addRecipe("buildcraft:redstoneChipset", Math.round(100000.0f * chipsetCostMultiplier), ItemRedstoneChipset.Chipset.RED.getStack(), "dustRedstone");
        BuildcraftRecipeRegistry.assemblyTable.addRecipe("buildcraft:ironChipset", Math.round(200000.0f * chipsetCostMultiplier), ItemRedstoneChipset.Chipset.IRON.getStack(), "dustRedstone", "ingotIron");
        BuildcraftRecipeRegistry.assemblyTable.addRecipe("buildcraft:goldChipset", Math.round(400000.0f * chipsetCostMultiplier), ItemRedstoneChipset.Chipset.GOLD.getStack(), "dustRedstone", "ingotGold");
        BuildcraftRecipeRegistry.assemblyTable.addRecipe("buildcraft:diamondChipset", Math.round(800000.0f * chipsetCostMultiplier), ItemRedstoneChipset.Chipset.DIAMOND.getStack(), "dustRedstone", "gemDiamond");
        BuildcraftRecipeRegistry.assemblyTable.addRecipe("buildcraft:emeraldChipset", Math.round(1200000.0f * chipsetCostMultiplier), ItemRedstoneChipset.Chipset.EMERALD.getStack(), "dustRedstone", "gemEmerald");
        BuildcraftRecipeRegistry.assemblyTable.addRecipe("buildcraft:pulsatingChipset", Math.round(400000.0f * chipsetCostMultiplier), ItemRedstoneChipset.Chipset.PULSATING.getStack(2), "dustRedstone", Items.field_151079_bi);
        BuildcraftRecipeRegistry.assemblyTable.addRecipe("buildcraft:quartzChipset", Math.round(600000.0f * chipsetCostMultiplier), ItemRedstoneChipset.Chipset.QUARTZ.getStack(), "dustRedstone", "gemQuartz");
        BuildcraftRecipeRegistry.assemblyTable.addRecipe("buildcraft:compChipset", Math.round(600000.0f * chipsetCostMultiplier), ItemRedstoneChipset.Chipset.COMP.getStack(), "dustRedstone", Items.field_151132_bS);
        BuildcraftRecipeRegistry.assemblyTable.addRecipe("buildcraft:redstoneCrystal", 10000000, new ItemStack(redstoneCrystal), new ItemStack(Blocks.field_150451_bX));
    }

    @Mod.EventHandler
    public void processIMCRequests(FMLInterModComms.IMCEvent event) {
        InterModComms.processIMC(event);
    }

    @Mod.EventHandler
    public void whiteListAppliedEnergetics(FMLInitializationEvent event) {
        FMLInterModComms.sendMessage((String)"appliedenergistics2", (String)"whitelist-spatial", (String)TileLaser.class.getCanonicalName());
        FMLInterModComms.sendMessage((String)"appliedenergistics2", (String)"whitelist-spatial", (String)TileAssemblyTable.class.getCanonicalName());
        FMLInterModComms.sendMessage((String)"appliedenergistics2", (String)"whitelist-spatial", (String)TileAdvancedCraftingTable.class.getCanonicalName());
        FMLInterModComms.sendMessage((String)"appliedenergistics2", (String)"whitelist-spatial", (String)TileIntegrationTable.class.getCanonicalName());
    }

    @Mod.EventHandler
    public void remap(FMLMissingMappingsEvent event) {
        for (FMLMissingMappingsEvent.MissingMapping mapping : event.get()) {
            if (mapping.name.equals("BuildCraft|Silicon:null")) {
                if (mapping.type == GameRegistry.Type.ITEM) {
                    mapping.remap(Item.func_150898_a((Block)assemblyTableBlock));
                } else {
                    mapping.remap((Block)assemblyTableBlock);
                }
            }
            if (mapping.type == GameRegistry.Type.ITEM) {
                if (mapping.name.equals("BuildCraft|Silicon:robot")) {
                    mapping.remap((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("BuildCraft|Robotics:robot")));
                    continue;
                }
                if (mapping.name.equals("BuildCraft|Silicon:redstone_board")) {
                    mapping.remap((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("BuildCraft|Robotics:redstone_board")));
                    continue;
                }
                if (mapping.name.equals("BuildCraft|Silicon:requester")) {
                    mapping.remap((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("BuildCraft|Robotics:requester")));
                    continue;
                }
                if (!mapping.name.equals("BuildCraft|Silicon:zonePlan")) continue;
                mapping.remap((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("BuildCraft|Robotics:zonePlan")));
                continue;
            }
            if (mapping.type != GameRegistry.Type.BLOCK) continue;
            if (mapping.name.equals("BuildCraft|Silicon:requester")) {
                mapping.remap(Block.func_149684_b((String)"BuildCraft|Robotics:requester"));
                continue;
            }
            if (!mapping.name.equals("BuildCraft|Silicon:zonePlan")) continue;
            mapping.remap(Block.func_149684_b((String)"BuildCraft|Robotics:zonePlan"));
        }
    }

    static {
        chipsetCostMultiplier = 1.0f;
    }
}

