/*
 * Decompiled with CFR 0.152.
 */
package buildcraft;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftMod;
import buildcraft.BuildCraftTransport;
import buildcraft.api.blueprints.BuilderAPI;
import buildcraft.api.blueprints.SchematicTile;
import buildcraft.api.core.BCLog;
import buildcraft.api.recipes.BuildcraftRecipeRegistry;
import buildcraft.core.BCRegistry;
import buildcraft.core.CompatHooks;
import buildcraft.core.DefaultProps;
import buildcraft.core.InterModComms;
import buildcraft.core.builders.schematics.SchematicFree;
import buildcraft.core.config.ConfigManager;
import buildcraft.core.lib.items.ItemBuildCraft;
import buildcraft.core.lib.network.base.ChannelHandler;
import buildcraft.core.lib.network.base.PacketHandler;
import buildcraft.factory.BlockAutoWorkbench;
import buildcraft.factory.BlockChute;
import buildcraft.factory.BlockFloodGate;
import buildcraft.factory.BlockMiningWell;
import buildcraft.factory.BlockPlainPipe;
import buildcraft.factory.BlockPump;
import buildcraft.factory.BlockRefinery;
import buildcraft.factory.BlockTank;
import buildcraft.factory.FactoryGuiHandler;
import buildcraft.factory.FactoryProxy;
import buildcraft.factory.FactoryProxyClient;
import buildcraft.factory.PumpDimensionList;
import buildcraft.factory.TileAutoWorkbench;
import buildcraft.factory.TileChute;
import buildcraft.factory.TileFloodGate;
import buildcraft.factory.TileMiningWell;
import buildcraft.factory.TilePump;
import buildcraft.factory.TileRefinery;
import buildcraft.factory.TileTank;
import buildcraft.factory.blocks.BlockDistiller;
import buildcraft.factory.blocks.BlockEnergyHeater;
import buildcraft.factory.blocks.BlockHeatExchange;
import buildcraft.factory.refining.ComplexRefineryRecipeManager;
import buildcraft.factory.refining.ComplexRefiningManager;
import buildcraft.factory.render.ChuteRenderModel;
import buildcraft.factory.schematics.SchematicAutoWorkbench;
import buildcraft.factory.schematics.SchematicPump;
import buildcraft.factory.schematics.SchematicRefinery;
import buildcraft.factory.schematics.SchematicTileIgnoreState;
import buildcraft.factory.tile.TileDistiller;
import buildcraft.factory.tile.TileEnergyHeater;
import buildcraft.factory.tile.TileHeatExchange;
import com.google.common.base.Throwables;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Achievement;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLMissingMappingsEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod(name="BuildCraft Factory", version="7.2.7", useMetadata=false, modid="BuildCraft|Factory", dependencies="required-after:BuildCraft|Core@7.2.7;after:BuildCraft|Energy", acceptedMinecraftVersions="[1.8.9]")
public class BuildCraftFactory
extends BuildCraftMod {
    @Mod.Instance(value="BuildCraft|Factory")
    public static BuildCraftFactory instance;
    public static BlockMiningWell miningWellBlock;
    public static BlockAutoWorkbench autoWorkbenchBlock;
    public static BlockPlainPipe plainPipeBlock;
    public static BlockPump pumpBlock;
    public static BlockFloodGate floodGateBlock;
    public static BlockTank tankBlock;
    public static BlockRefinery refineryBlock;
    public static BlockChute chuteBlock;
    public static BlockDistiller distillerBlock;
    public static BlockEnergyHeater energyHeaterBlock;
    public static BlockHeatExchange heatExchangeBlock;
    public static ItemBuildCraft plasticSheetItem;
    public static Achievement aLotOfCraftingAchievement;
    public static Achievement straightDownAchievement;
    public static Achievement refineAndRedefineAchievement;
    public static int miningDepth;
    public static int rfPerHeatPerMB;
    public static boolean pumpsNeedRealPower;
    public static PumpDimensionList pumpDimensionList;

    @Mod.EventHandler
    public void fmlPreInit(FMLPreInitializationEvent evt) {
        this.channels = NetworkRegistry.INSTANCE.newChannel("BC-FACTORY", new io.netty.channel.ChannelHandler[]{new ChannelHandler(), new PacketHandler()});
        BuildcraftRecipeRegistry.complexRefinery = ComplexRefineryRecipeManager.INSTANCE;
        String plc = "Allows admins to whitelist or blacklist pumping of specific fluids in specific dimensions.\nEg. \"-/-1/Lava\" will disable lava in the nether. \"-/*/Lava\" will disable lava in any dimension. \"+/0/*\" will enable any fluid in the overworld.\nEntries are comma seperated, banned fluids have precedence over allowed ones.Default is \"+/*/*,+/-1/Lava\" - the second redundant entry (\"+/-1/lava\") is there to show the format.";
        BuildCraftCore.mainConfigManager.register("general.miningDepth", 256, "Should the mining well only be usable once after placing?", ConfigManager.RestartRequirement.NONE);
        BuildCraftCore.mainConfigManager.get("general.miningDepth").setMinValue(2).setMaxValue(256);
        BuildCraftCore.mainConfigManager.register("general.pumpDimensionControl", DefaultProps.PUMP_DIMENSION_LIST, plc, ConfigManager.RestartRequirement.NONE);
        BuildCraftCore.mainConfigManager.register("general.pumpsNeedRealPower", false, "Do pumps need real (non-redstone) power?", ConfigManager.RestartRequirement.WORLD);
        this.reloadConfig(ConfigManager.RestartRequirement.GAME);
        miningWellBlock = (BlockMiningWell)CompatHooks.INSTANCE.getBlock(BlockMiningWell.class);
        if (BCRegistry.INSTANCE.registerBlock(miningWellBlock.func_149663_c("miningWellBlock"), false)) {
            plainPipeBlock = new BlockPlainPipe();
            BCRegistry.INSTANCE.registerBlock(plainPipeBlock.func_149663_c("plainPipeBlock"), true);
        }
        autoWorkbenchBlock = (BlockAutoWorkbench)CompatHooks.INSTANCE.getBlock(BlockAutoWorkbench.class);
        BCRegistry.INSTANCE.registerBlock(autoWorkbenchBlock.func_149663_c("autoWorkbenchBlock"), false);
        tankBlock = (BlockTank)CompatHooks.INSTANCE.getBlock(BlockTank.class);
        BCRegistry.INSTANCE.registerBlock(tankBlock.func_149663_c("tankBlock"), false);
        pumpBlock = (BlockPump)CompatHooks.INSTANCE.getBlock(BlockPump.class);
        BCRegistry.INSTANCE.registerBlock(pumpBlock.func_149663_c("pumpBlock"), false);
        floodGateBlock = (BlockFloodGate)CompatHooks.INSTANCE.getBlock(BlockFloodGate.class);
        BCRegistry.INSTANCE.registerBlock(floodGateBlock.func_149663_c("floodGateBlock"), false);
        refineryBlock = (BlockRefinery)CompatHooks.INSTANCE.getBlock(BlockRefinery.class);
        BCRegistry.INSTANCE.registerBlock(refineryBlock.func_149663_c("refineryBlock"), false);
        chuteBlock = (BlockChute)CompatHooks.INSTANCE.getBlock(BlockChute.class);
        BCRegistry.INSTANCE.registerBlock(chuteBlock.func_149663_c("blockChute"), false);
        if (Loader.isModLoaded((String)"BuildCraft|Energy") && BuildCraftCore.DEVELOPER_MODE) {
            energyHeaterBlock = (BlockEnergyHeater)CompatHooks.INSTANCE.getBlock(BlockEnergyHeater.class);
            BCRegistry.INSTANCE.registerBlock(energyHeaterBlock.func_149663_c("blockEnergyHeater"), false);
            heatExchangeBlock = (BlockHeatExchange)CompatHooks.INSTANCE.getBlock(BlockHeatExchange.class);
            BCRegistry.INSTANCE.registerBlock(heatExchangeBlock.func_149663_c("blockHeatExchange"), false);
            distillerBlock = (BlockDistiller)CompatHooks.INSTANCE.getBlock(BlockDistiller.class);
            BCRegistry.INSTANCE.registerBlock(distillerBlock.func_149663_c("blockDistiller"), false);
            plasticSheetItem = new ItemBuildCraft();
            plasticSheetItem.func_77655_b("plasticSheet");
            plasticSheetItem.setLocalizationRuleArray("item.plasticSheet.singular", "item.plasticSheet.plural");
            plasticSheetItem.setLocalizationRule(stack -> stack == null ? 0 : (stack.field_77994_a > 1 ? 1 : 0));
            BCRegistry.INSTANCE.registerItem(plasticSheetItem, false);
            ComplexRefiningManager.preInit();
        }
        FactoryProxy.proxy.preInit();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static void loadRecipes() {
        if (miningWellBlock != null) {
            BCRegistry.INSTANCE.addCraftingRecipe(new ItemStack((Block)miningWellBlock, 1), "ipi", "igi", "iPi", Character.valueOf('p'), "dustRedstone", Character.valueOf('i'), "ingotIron", Character.valueOf('g'), "gearIron", Character.valueOf('P'), Items.field_151035_b);
        }
        if (pumpBlock != null) {
            BCRegistry.INSTANCE.addCraftingRecipe(new ItemStack((Block)pumpBlock), "ipi", "igi", "TBT", Character.valueOf('p'), "dustRedstone", Character.valueOf('i'), "ingotIron", Character.valueOf('T'), tankBlock, Character.valueOf('g'), "gearIron", Character.valueOf('B'), Items.field_151133_ar);
        }
        if (autoWorkbenchBlock != null) {
            BCRegistry.INSTANCE.addCraftingRecipe(new ItemStack((Block)autoWorkbenchBlock), "gwg", Character.valueOf('w'), "craftingTableWood", Character.valueOf('g'), "gearStone");
            BCRegistry.INSTANCE.addCraftingRecipe(new ItemStack((Block)autoWorkbenchBlock), "g", "w", "g", Character.valueOf('w'), "craftingTableWood", Character.valueOf('g'), "gearStone");
        }
        if (tankBlock != null) {
            BCRegistry.INSTANCE.addCraftingRecipe(new ItemStack((Block)tankBlock), "ggg", "g g", "ggg", Character.valueOf('g'), "blockGlass");
        }
        if (refineryBlock != null) {
            BCRegistry.INSTANCE.addCraftingRecipe(new ItemStack((Block)refineryBlock), "RTR", "TGT", Character.valueOf('T'), tankBlock != null ? tankBlock : "blockGlass", Character.valueOf('G'), "gearDiamond", Character.valueOf('R'), Blocks.field_150429_aA);
        }
        if (chuteBlock != null) {
            BCRegistry.INSTANCE.addCraftingRecipe(new ItemStack((Block)chuteBlock), "ICI", " G ", Character.valueOf('I'), "ingotIron", Character.valueOf('C'), "chestWood", Character.valueOf('G'), "gearStone");
            BCRegistry.INSTANCE.addShapelessRecipe(new ItemStack((Block)chuteBlock), Blocks.field_150438_bZ, "gearStone");
        }
        if (floodGateBlock != null) {
            BCRegistry.INSTANCE.addCraftingRecipe(new ItemStack((Block)floodGateBlock), "IGI", "FTF", "IFI", Character.valueOf('I'), "ingotIron", Character.valueOf('T'), tankBlock != null ? tankBlock : "blockGlass", Character.valueOf('G'), "gearIron", Character.valueOf('F'), new ItemStack(Blocks.field_150411_aY));
        }
        if (Loader.isModLoaded((String)"BuildCraft|Energy") && BuildCraftCore.DEVELOPER_MODE) {
            if (distillerBlock != null) {
                BCRegistry.INSTANCE.addCraftingRecipe(new ItemStack((Block)distillerBlock), "gpi", "ptd", "gpi", Character.valueOf('i'), "gearIron", Character.valueOf('t'), tankBlock != null ? tankBlock : "blockGlass", Character.valueOf('p'), "paneGlassColorless", Character.valueOf('g'), "gearGold", Character.valueOf('d'), "gearDiamond");
            }
            if (heatExchangeBlock != null) {
                BCRegistry.INSTANCE.addCraftingRecipe(new ItemStack((Block)heatExchangeBlock), "gpg", "ptp", "gpg", Character.valueOf('g'), "gearGold", Character.valueOf('t'), tankBlock != null ? tankBlock : "blockGlass", Character.valueOf('p'), "paneGlassColorless");
            }
            if (energyHeaterBlock != null) {
                BCRegistry.INSTANCE.addCraftingRecipe(new ItemStack((Block)energyHeaterBlock), "iri", "ptp", "rgr", Character.valueOf('i'), "gearIron", Character.valueOf('t'), tankBlock != null ? tankBlock : "blockGlass", Character.valueOf('r'), "dustRedstone", Character.valueOf('p'), "paneGlassColorless", Character.valueOf('g'), "gearGold");
            }
            ItemStack residueBucket = FluidContainerRegistry.fillFluidContainer((FluidStack)ComplexRefiningManager.oilResidue[0].createFluidStack(1000), (ItemStack)new ItemStack(Items.field_151133_ar));
            ItemStack tarBucket = FluidContainerRegistry.fillFluidContainer((FluidStack)ComplexRefiningManager.tar.createFluidStack(1000), (ItemStack)new ItemStack(Items.field_151133_ar));
            tarBucket.field_77994_a = 2;
            BCRegistry.INSTANCE.addShapelessRecipe(new ItemStack((Item)plasticSheetItem, 16), residueBucket, Items.field_151131_as, Items.field_151131_as);
            if (Loader.isModLoaded((String)"BuildCraft|Transport")) {
                BuildCraftFactory.loadTransportRefiningRecipes();
            }
        }
    }

    private static void loadTransportRefiningRecipes() {
        BCRegistry.INSTANCE.addCraftingRecipe(new ItemStack(BuildCraftTransport.pipeWaterproof, 8), "PP", "PP", Character.valueOf('P'), new ItemStack((Item)plasticSheetItem));
    }

    @Mod.EventHandler
    public void fmlInit(FMLInitializationEvent evt) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new FactoryGuiHandler());
        BCRegistry.INSTANCE.registerTileEntity(TileMiningWell.class, "buildcraft.factory.MiningWell", "MiningWell");
        BCRegistry.INSTANCE.registerTileEntity(TileAutoWorkbench.class, "buildcraft.factory.AutoWorkbench", "AutoWorkbench");
        BCRegistry.INSTANCE.registerTileEntity(TilePump.class, "buildcraft.factory.Pump", "net.minecraft.src.buildcraft.factory.TilePump");
        BCRegistry.INSTANCE.registerTileEntity(TileFloodGate.class, "buildcraft.factory.FloodGate", "net.minecraft.src.buildcraft.factory.TileFloodGate");
        BCRegistry.INSTANCE.registerTileEntity(TileTank.class, "buildcraft.factory.Tank", "net.minecraft.src.buildcraft.factory.TileTank");
        BCRegistry.INSTANCE.registerTileEntity(TileRefinery.class, "buildcraft.factory.Refinery", "net.minecraft.src.buildcraft.factory.Refinery");
        BCRegistry.INSTANCE.registerTileEntity(TileChute.class, "buildcraft.factory.Chute", "net.minecraft.src.buildcraft.factory.TileHopper");
        BCRegistry.INSTANCE.registerTileEntity(TileEnergyHeater.class, "buildcraft.factory.TileEnergyHeater");
        BCRegistry.INSTANCE.registerTileEntity(TileHeatExchange.class, "buildcraft.factory.TileHeatExchange");
        BCRegistry.INSTANCE.registerTileEntity(TileDistiller.class, "buildcraft.factory.TileDistiller");
        if (Loader.isModLoaded((String)"BuildCraft|Energy") && BuildCraftCore.DEVELOPER_MODE) {
            ComplexRefiningManager.init();
        }
        FactoryProxy.proxy.fmlInit();
        BuilderAPI.schematicRegistry.registerSchematicBlock(refineryBlock, SchematicRefinery.class, new Object[0]);
        BuilderAPI.schematicRegistry.registerSchematicBlock(tankBlock, SchematicTileIgnoreState.class, new Object[0]);
        BuilderAPI.schematicRegistry.registerSchematicBlock(pumpBlock, SchematicPump.class, new Object[0]);
        BuilderAPI.schematicRegistry.registerSchematicBlock(floodGateBlock, SchematicTileIgnoreState.class, new Object[0]);
        BuilderAPI.schematicRegistry.registerSchematicBlock(autoWorkbenchBlock, SchematicAutoWorkbench.class, new Object[0]);
        BuilderAPI.schematicRegistry.registerSchematicBlock(chuteBlock, SchematicTile.class, new Object[0]);
        BuilderAPI.schematicRegistry.registerSchematicBlock(plainPipeBlock, SchematicFree.class, new Object[0]);
        aLotOfCraftingAchievement = BuildCraftCore.achievementManager.registerAchievement(new Achievement("buildcraft|factory:achievement.aLotOfCrafting", "aLotOfCraftingAchievement", 1, 2, (Block)autoWorkbenchBlock, BuildCraftCore.woodenGearAchievement));
        straightDownAchievement = BuildCraftCore.achievementManager.registerAchievement(new Achievement("buildcraft|factory:achievement.straightDown", "straightDownAchievement", 5, 2, (Block)miningWellBlock, BuildCraftCore.ironGearAchievement));
        refineAndRedefineAchievement = BuildCraftCore.achievementManager.registerAchievement(new Achievement("buildcraft|factory:achievement.refineAndRedefine", "refineAndRedefineAchievement", 10, 0, (Block)refineryBlock, BuildCraftCore.diamondGearAchievement));
        if (BuildCraftCore.loadDefaultRecipes) {
            BuildCraftFactory.loadRecipes();
        }
    }

    public void reloadConfig(ConfigManager.RestartRequirement restartType) {
        if (restartType == ConfigManager.RestartRequirement.GAME) {
            this.reloadConfig(ConfigManager.RestartRequirement.WORLD);
        } else if (restartType == ConfigManager.RestartRequirement.WORLD) {
            this.reloadConfig(ConfigManager.RestartRequirement.NONE);
        } else {
            miningDepth = BuildCraftCore.mainConfigManager.get("general.miningDepth").getInt();
            pumpsNeedRealPower = BuildCraftCore.mainConfigManager.get("general.pumpsNeedRealPower").getBoolean();
            pumpDimensionList = new PumpDimensionList(BuildCraftCore.mainConfigManager.get("general.pumpDimensionControl").getString());
            if (BuildCraftCore.mainConfiguration.hasChanged()) {
                BuildCraftCore.mainConfiguration.save();
            }
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if ("BuildCraft|Core".equals(event.modID)) {
            this.reloadConfig(event.isWorldRunning ? ConfigManager.RestartRequirement.NONE : ConfigManager.RestartRequirement.WORLD);
        }
    }

    @Mod.EventHandler
    public void processIMCRequests(FMLInterModComms.IMCEvent event) {
        InterModComms.processIMC(event);
    }

    @Mod.EventHandler
    public void whiteListAppliedEnergetics(FMLInitializationEvent event) {
        FMLInterModComms.sendMessage((String)"appliedenergistics2", (String)"whitelist-spatial", (String)TileAutoWorkbench.class.getCanonicalName());
        FMLInterModComms.sendMessage((String)"appliedenergistics2", (String)"whitelist-spatial", (String)TileFloodGate.class.getCanonicalName());
        FMLInterModComms.sendMessage((String)"appliedenergistics2", (String)"whitelist-spatial", (String)TileTank.class.getCanonicalName());
        FMLInterModComms.sendMessage((String)"appliedenergistics2", (String)"whitelist-spatial", (String)TileRefinery.class.getCanonicalName());
        FMLInterModComms.sendMessage((String)"appliedenergistics2", (String)"whitelist-spatial", (String)TileChute.class.getCanonicalName());
    }

    @Mod.EventHandler
    public void remap(FMLMissingMappingsEvent event) {
        Throwable error = null;
        BCLog.logger.info("Factory|Remap " + System.identityHashCode(event));
        for (FMLMissingMappingsEvent.MissingMapping mapping : event.getAll()) {
            try {
                String name = mapping.name.toLowerCase(Locale.ROOT);
                String domain = mapping.resourceLocation.func_110624_b().toLowerCase(Locale.ROOT);
                String path = mapping.resourceLocation.func_110623_a().toLowerCase(Locale.ROOT);
                if (name.equalsIgnoreCase("BuildCraft|Factory:machineBlock") || name.equalsIgnoreCase("BuildCraft|Factory:quarryBlock")) {
                    if (Loader.isModLoaded((String)"BuildCraft|Builders")) {
                        if (mapping.type == GameRegistry.Type.BLOCK) {
                            mapping.remap(Block.func_149684_b((String)"BuildCraft|Builders:quarryBlock"));
                        } else if (mapping.type == GameRegistry.Type.ITEM) {
                            mapping.remap(Item.func_150898_a((Block)Block.func_149684_b((String)"BuildCraft|Builders:quarryBlock")));
                        }
                    } else {
                        mapping.warn();
                    }
                } else if (name.equalsIgnoreCase("BuildCraft|Factory:frameBlock")) {
                    if (Loader.isModLoaded((String)"BuildCraft|Builders")) {
                        if (mapping.type == GameRegistry.Type.BLOCK) {
                            mapping.remap(Block.func_149684_b((String)"BuildCraft|Builders:frameBlock"));
                        } else if (mapping.type == GameRegistry.Type.ITEM) {
                            mapping.remap(Item.func_150898_a((Block)Block.func_149684_b((String)"BuildCraft|Builders:frameBlock")));
                        }
                    } else {
                        mapping.ignore();
                    }
                } else if (name.equals("buildcraft|factory:hopperblock") || name.equals("buildcraft|factory:blockhopper")) {
                    if (mapping.type == GameRegistry.Type.BLOCK) {
                        mapping.remap((Block)chuteBlock);
                    } else {
                        mapping.remap(Item.func_150898_a((Block)chuteBlock));
                    }
                }
                if (!domain.contains("buildcraft") || !Loader.isModLoaded((String)"BuildCraft|Energy") || !BuildCraftCore.DEVELOPER_MODE) continue;
                String what = "nothing";
                String type = mapping.type.name().toLowerCase(Locale.ROOT);
                if (path.contains("_")) continue;
                if (path.endsWith("oil")) {
                    if (mapping.type == GameRegistry.Type.BLOCK) {
                        mapping.remap((Block)ComplexRefiningManager.crudeOil[0].block);
                        what = "remap-block";
                    } else if (mapping.type == GameRegistry.Type.ITEM) {
                        if (path.contains("bucket") && ComplexRefiningManager.crudeOil[0].bucket != null) {
                            mapping.remap((Item)ComplexRefiningManager.crudeOil[0].bucket);
                            what = "remap-item-bucket";
                        } else if (path.contains("block")) {
                            mapping.remap(Item.func_150898_a((Block)ComplexRefiningManager.crudeOil[0].block));
                            what = "remap-item-block";
                        }
                    }
                    BCLog.logger.info("            [" + domain + "][" + path + "][" + type + "] matched oil " + what);
                    continue;
                }
                if (path.endsWith("fuel")) {
                    if (mapping.type == GameRegistry.Type.BLOCK) {
                        mapping.remap((Block)ComplexRefiningManager.fuelLight[0].block);
                        what = "remap-block";
                    } else if (mapping.type == GameRegistry.Type.ITEM) {
                        if (path.contains("bucket") && ComplexRefiningManager.fuelLight[0].bucket != null) {
                            mapping.remap((Item)ComplexRefiningManager.fuelLight[0].bucket);
                            what = "remap-item-bucket";
                        } else if (path.contains("block")) {
                            mapping.remap(Item.func_150898_a((Block)ComplexRefiningManager.fuelLight[0].block));
                            what = "remap-item-block";
                        }
                    }
                    BCLog.logger.info("            [" + domain + "][" + path + "][" + type + "] matched fuel " + what);
                    continue;
                }
                BCLog.logger.info("            [" + domain + "][" + path + "][" + type + "] matched nothing");
            }
            catch (Throwable t) {
                t.printStackTrace();
                error = t;
            }
        }
        if (error != null) {
            throw Throwables.propagate(error);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void loadTextures(TextureStitchEvent.Pre evt) {
        TextureMap terrainTextures = evt.map;
        FactoryProxyClient.pumpTexture = terrainTextures.func_174942_a(new ResourceLocation("buildcraftfactory:blocks/pump/tube"));
        ChuteRenderModel.sideTexture = terrainTextures.func_174942_a(new ResourceLocation("buildcraftfactory:blocks/chute/side"));
        if (Loader.isModLoaded((String)"BuildCraft|Energy") && BuildCraftCore.DEVELOPER_MODE) {
            ComplexRefiningManager.textureStitchPre(evt);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void registerModels(ModelBakeEvent event) {
        ModelResourceLocation mrl = new ModelResourceLocation("buildcraftfactory:blockChute");
        IBakedModel model = (IBakedModel)event.modelRegistry.func_82594_a((Object)mrl);
        if (model != null) {
            event.modelRegistry.func_82595_a((Object)mrl, (Object)ChuteRenderModel.create(model));
        }
        if (Loader.isModLoaded((String)"BuildCraft|Energy") && BuildCraftCore.DEVELOPER_MODE) {
            ComplexRefiningManager.registerModels(event);
        }
    }

    static {
        miningDepth = 256;
        rfPerHeatPerMB = 2;
        pumpsNeedRealPower = false;
    }
}

