/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.powerSystem.traits;

import cofh.api.energy.IEnergyContainerItem;
import net.minecraft.item.ItemStack;
import reborncore.api.power.IEnergyInterfaceItem;
import reborncore.common.powerSystem.PowerSystem;
import reborncore.jtraits.JTrait;

public class RFItemPowerTrait
extends JTrait<IEnergyInterfaceItem>
implements IEnergyContainerItem {
    @Override
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (!PowerSystem.RFPOWENET) {
            return 0;
        }
        if (!((IEnergyInterfaceItem)this._self).canAcceptEnergy(container)) {
            return 0;
        }
        int energyReceived = Math.min(this.getMaxEnergyStored(container) - this.getEnergyStored(container), Math.min((int)((IEnergyInterfaceItem)this._self).getMaxTransfer(container) * PowerSystem.euPerRF, maxReceive *= PowerSystem.euPerRF));
        if (!simulate) {
            ((IEnergyInterfaceItem)this._self).setEnergy(((IEnergyInterfaceItem)this._self).getEnergy(container) + (double)energyReceived, container);
        }
        return energyReceived / PowerSystem.euPerRF;
    }

    @Override
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (!PowerSystem.RFPOWENET) {
            return 0;
        }
        if (!((IEnergyInterfaceItem)this._self).canAcceptEnergy(container)) {
            return 0;
        }
        int energyExtracted = Math.min(this.getEnergyStored(container), Math.min(maxExtract *= PowerSystem.euPerRF, maxExtract));
        if (!simulate) {
            ((IEnergyInterfaceItem)this._self).setEnergy(((IEnergyInterfaceItem)this._self).getEnergy(container) - (double)energyExtracted, container);
        }
        return energyExtracted / PowerSystem.euPerRF;
    }

    @Override
    public int getEnergyStored(ItemStack container) {
        if (!PowerSystem.RFPOWENET) {
            return 0;
        }
        return (int)((IEnergyInterfaceItem)this._self).getEnergy(container) / PowerSystem.euPerRF;
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        if (!PowerSystem.RFPOWENET) {
            return 0;
        }
        return (int)((IEnergyInterfaceItem)this._self).getMaxPower(container) / PowerSystem.euPerRF;
    }
}

