/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.powerSystem;

import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import com.mojang.realmsclient.gui.ChatFormatting;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.info.Info;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.Event;
import reborncore.api.IListInfoProvider;
import reborncore.api.power.IEnergyInterfaceTile;
import reborncore.common.powerSystem.PowerSystem;
import reborncore.common.powerSystem.RFProviderTile;

@Optional.InterfaceList(value={@Optional.Interface(iface="ic2.api.energy.tile.IEnergyTile", modid="IC2"), @Optional.Interface(iface="ic2.api.energy.tile.IEnergySink", modid="IC2"), @Optional.Interface(iface="ic2.api.energy.tile.IEnergySource", modid="IC2")})
public abstract class TilePowerAcceptor
extends RFProviderTile
implements IEnergyReceiver,
IEnergyProvider,
IEnergyInterfaceTile,
IListInfoProvider,
IEnergyTile,
IEnergySink,
IEnergySource {
    public int tier;
    private double energy;
    protected boolean addedToEnet;

    public TilePowerAcceptor(int tier) {
        this.tier = tier;
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
    }

    public void onLoaded() {
        if (PowerSystem.EUPOWENET && !this.addedToEnet && !FMLCommonHandler.instance().getEffectiveSide().isClient() && Info.isIc2Available()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnet = true;
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.onChunkUnload();
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (PowerSystem.EUPOWENET && this.addedToEnet && Info.isIc2Available()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnet = false;
        }
    }

    @Override
    public double getDemandedEnergy() {
        if (!PowerSystem.EUPOWENET) {
            return 0.0;
        }
        return Math.min(this.getMaxPower() - this.getEnergy(), this.getMaxInput());
    }

    @Override
    public int getSinkTier() {
        return this.tier;
    }

    @Override
    public double injectEnergy(EnumFacing directionFrom, double amount, double voltage) {
        this.setEnergy(this.getEnergy() + amount);
        return 0.0;
    }

    @Override
    public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing direction) {
        if (!PowerSystem.EUPOWENET) {
            return false;
        }
        return this.canAcceptEnergy(direction);
    }

    @Override
    public boolean emitsEnergyTo(IEnergyAcceptor receiver, EnumFacing side) {
        if (!PowerSystem.EUPOWENET) {
            return false;
        }
        return this.canProvideEnergy(side);
    }

    @Override
    public double getOfferedEnergy() {
        if (!PowerSystem.EUPOWENET) {
            return 0.0;
        }
        return Math.min(this.getEnergy(), this.getMaxOutput());
    }

    @Override
    public void drawEnergy(double amount) {
        this.useEnergy((int)amount);
    }

    @Override
    public int getSourceTier() {
        return this.tier;
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        if (!PowerSystem.RFPOWENET) {
            return false;
        }
        return this.canAcceptEnergy(from) || this.canProvideEnergy(from);
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        if (!PowerSystem.RFPOWENET) {
            return 0;
        }
        if (!this.canAcceptEnergy(from)) {
            return 0;
        }
        int energyReceived = Math.min(this.getMaxEnergyStored(null) - this.getEnergyStored(null), Math.min((int)this.getMaxInput() * PowerSystem.euPerRF, maxReceive *= PowerSystem.euPerRF));
        if (!simulate) {
            this.setEnergy(this.getEnergy() + (double)energyReceived);
        }
        return energyReceived / PowerSystem.euPerRF;
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        if (!PowerSystem.RFPOWENET) {
            return 0;
        }
        return (int)this.getEnergy() / PowerSystem.euPerRF;
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        if (!PowerSystem.RFPOWENET) {
            return 0;
        }
        return (int)this.getMaxPower() / PowerSystem.euPerRF;
    }

    @Override
    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        if (!PowerSystem.RFPOWENET) {
            return 0;
        }
        if (!this.canProvideEnergy(from)) {
            return 0;
        }
        int energyExtracted = Math.min(this.getEnergyStored(null), Math.min(maxExtract *= PowerSystem.euPerRF, maxExtract));
        if (!simulate) {
            this.setEnergy(this.energy - (double)energyExtracted);
        }
        return energyExtracted / PowerSystem.euPerRF;
    }

    @Override
    public double getEnergy() {
        return this.energy;
    }

    @Override
    public void setEnergy(double energy) {
        this.energy = energy;
        if (this.getEnergy() > this.getMaxPower()) {
            this.setEnergy(this.getMaxPower());
        } else if (this.energy < 0.0) {
            this.setEnergy(0.0);
        }
    }

    @Override
    public double addEnergy(double energy) {
        return this.addEnergy(energy, false);
    }

    @Override
    public double addEnergy(double energy, boolean simulate) {
        double energyReceived = Math.min(this.getMaxPower() - energy, Math.min(this.getMaxPower(), energy));
        if (!simulate) {
            this.setEnergy(this.getEnergy() + energyReceived);
        }
        return energyReceived;
    }

    @Override
    public boolean canUseEnergy(double input) {
        return input <= this.energy;
    }

    @Override
    public double useEnergy(double energy) {
        return this.useEnergy(energy, false);
    }

    @Override
    public double useEnergy(double extract, boolean simulate) {
        extract = Math.min(this.getMaxOutput(), Math.min(extract, this.energy));
        if (!simulate) {
            this.setEnergy(this.energy - extract);
        }
        return extract;
    }

    @Override
    public boolean canAddEnergy(double energy) {
        return this.energy + energy <= this.getMaxPower();
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        NBTTagCompound data = tag.func_74775_l("TilePowerAcceptor");
        this.energy = data.func_74769_h("energy");
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        NBTTagCompound data = new NBTTagCompound();
        data.func_74780_a("energy", this.energy);
        tag.func_74782_a("TilePowerAcceptor", (NBTBase)data);
    }

    public void readFromNBTWithoutCoords(NBTTagCompound tag) {
        NBTTagCompound data = tag.func_74775_l("TilePowerAcceptor");
        this.energy = data.func_74769_h("energy");
    }

    public void writeToNBTWithoutCoords(NBTTagCompound tag) {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74780_a("energy", this.energy);
        tag.func_74782_a("TilePowerAcceptor", (NBTBase)data);
    }

    @Override
    public void addInfo(List<String> info, boolean isRealTile) {
        info.add(ChatFormatting.LIGHT_PURPLE + "Energy buffer Size " + ChatFormatting.GREEN + PowerSystem.getLocaliszedPower(this.getMaxPower()));
        if (this.getMaxInput() != 0.0) {
            info.add(ChatFormatting.LIGHT_PURPLE + "Max Input " + ChatFormatting.GREEN + PowerSystem.getLocaliszedPower(this.getMaxInput()));
        }
        if (this.getMaxOutput() != 0.0) {
            info.add(ChatFormatting.LIGHT_PURPLE + "Max Output " + ChatFormatting.GREEN + PowerSystem.getLocaliszedPower(this.getMaxOutput()));
        }
        info.add(ChatFormatting.LIGHT_PURPLE + "Tier " + ChatFormatting.GREEN + (Object)((Object)this.getTier()));
    }

    public double getFreeSpace() {
        return this.getMaxPower() - this.energy;
    }

    public void charge(int slot) {
    }

    public int getEnergyScaled(int scale) {
        return (int)(this.energy * (double)scale / this.getMaxPower());
    }
}

