/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.powerSystem;

import reborncore.common.RebornCoreConfig;

public class PowerSystem {
    public static boolean RFPOWENET = RebornCoreConfig.enableRF;
    public static boolean EUPOWENET = RebornCoreConfig.enableEU;
    public static int euPerRF = RebornCoreConfig.euPerRF;

    public static String getLocaliszedPower(double eu) {
        return PowerSystem.getLocaliszedPower((int)eu);
    }

    public static String getLocaliszedPower(int eu) {
        if (EUPOWENET) {
            return PowerSystem.getRoundedString(eu, "EU");
        }
        return PowerSystem.getRoundedString(eu / euPerRF, "RF");
    }

    private static String getRoundedString(double euValue, String units) {
        if (euValue >= 1000000.0) {
            double tenX = Math.round(euValue / 100000.0);
            return Double.toString(tenX / 10.0).concat(" m " + units);
        }
        if (euValue >= 1000.0) {
            double tenX = Math.round(euValue / 100.0);
            return Double.toString(tenX / 10.0).concat(" k " + units);
        }
        return Double.toString(Math.floor(euValue)).concat(" " + units);
    }
}

