/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.packets;

import com.google.common.base.Charsets;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import reborncore.common.packets.PacketHandler;

public abstract class SimplePacket {
    protected EntityPlayer player;
    protected byte mode;

    public SimplePacket(EntityPlayer _player) {
        this.player = _player;
    }

    public SimplePacket() {
        this.player = null;
    }

    public static String readString(ByteBuf in) throws IOException {
        byte[] stringBytes = new byte[in.readInt()];
        in.readBytes(stringBytes);
        return new String(stringBytes, Charsets.UTF_8);
    }

    public static void writeString(String string, ByteBuf out) throws IOException {
        byte[] stringBytes = string.getBytes(Charsets.UTF_8);
        out.writeInt(stringBytes.length);
        out.writeBytes(stringBytes);
    }

    public static World readWorld(ByteBuf in) throws IOException {
        return DimensionManager.getWorld((int)in.readInt());
    }

    public static void writeWorld(World world, ByteBuf out) throws IOException {
        out.writeInt(world.field_73011_w.func_177502_q());
    }

    public static EntityPlayer readPlayer(ByteBuf in) throws IOException {
        if (!in.readBoolean()) {
            return null;
        }
        World playerWorld = SimplePacket.readWorld(in);
        return playerWorld.func_72924_a(SimplePacket.readString(in));
    }

    public static void writePlayer(EntityPlayer player, ByteBuf out) throws IOException {
        if (player == null) {
            out.writeBoolean(false);
            return;
        }
        out.writeBoolean(true);
        SimplePacket.writeWorld(player.field_70170_p, out);
        SimplePacket.writeString(player.func_70005_c_(), out);
    }

    public static TileEntity readTileEntity(ByteBuf in) throws IOException {
        return SimplePacket.readWorld(in).func_175625_s(new BlockPos(in.readInt(), in.readInt(), in.readInt()));
    }

    public static void writeTileEntity(TileEntity tileEntity, ByteBuf out) throws IOException {
        SimplePacket.writeWorld(tileEntity.func_145831_w(), out);
        out.writeInt(tileEntity.func_174877_v().func_177958_n());
        out.writeInt(tileEntity.func_174877_v().func_177956_o());
        out.writeInt(tileEntity.func_174877_v().func_177952_p());
    }

    public static Fluid readFluid(ByteBuf in) throws IOException {
        return FluidRegistry.getFluid((String)SimplePacket.readString(in));
    }

    public static void writeFluid(Fluid fluid, ByteBuf out) throws IOException {
        if (fluid == null) {
            SimplePacket.writeString("", out);
            return;
        }
        SimplePacket.writeString(fluid.getName(), out);
    }

    public void writePacketData(ByteBuf out) throws IOException {
        out.writeByte((int)this.mode);
        SimplePacket.writePlayer(this.player, out);
        this.writeData(out);
    }

    public abstract void writeData(ByteBuf var1) throws IOException;

    public void readPacketData(ByteBuf in) throws IOException {
        this.mode = in.readByte();
        this.player = SimplePacket.readPlayer(in);
        this.readData(in);
    }

    public abstract void readData(ByteBuf var1) throws IOException;

    public abstract void execute();

    public void sendPacketToServer() {
        PacketHandler.sendPacketToServer(this);
    }

    public void sendPacketToPlayer(EntityPlayer player) {
        PacketHandler.sendPacketToPlayer(this, player);
    }

    public void sendPacketToAllPlayers() {
        PacketHandler.sendPacketToAllPlayers(this);
    }
}

