/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.packets;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;
import java.util.EnumMap;
import java.util.logging.Logger;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.FMLEmbeddedChannel;
import net.minecraftforge.fml.common.network.FMLIndexedMessageToMessageCodec;
import net.minecraftforge.fml.common.network.FMLOutboundHandler;
import net.minecraftforge.fml.relauncher.Side;
import reborncore.common.packets.AddDiscriminatorEvent;
import reborncore.common.packets.SimplePacket;

public class PacketHandler
extends FMLIndexedMessageToMessageCodec<SimplePacket> {
    private static EnumMap<Side, FMLEmbeddedChannel> channels;
    public int nextDiscriminator = 0;

    public PacketHandler() {
        MinecraftForge.EVENT_BUS.post((Event)new AddDiscriminatorEvent(this));
    }

    public static EnumMap<Side, FMLEmbeddedChannel> getChannels() {
        return channels;
    }

    public static void setChannels(EnumMap<Side, FMLEmbeddedChannel> _channels) {
        channels = _channels;
    }

    public static void sendPacketToServer(SimplePacket packet) {
        PacketHandler.getChannels().get(Side.CLIENT).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        PacketHandler.getChannels().get(Side.CLIENT).writeOutbound(new Object[]{packet});
    }

    public static void sendPacketToPlayer(SimplePacket packet, EntityPlayer player) {
        PacketHandler.getChannels().get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        PacketHandler.getChannels().get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        PacketHandler.getChannels().get(Side.SERVER).writeOutbound(new Object[]{packet});
    }

    public static void sendPacketToAllPlayers(SimplePacket packet) {
        PacketHandler.getChannels().get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
        PacketHandler.getChannels().get(Side.SERVER).writeOutbound(new Object[]{packet});
    }

    public static void sendPacketToAllPlayers(Packet packet, World world) {
        for (Object player : world.field_73010_i) {
            if (!(player instanceof EntityPlayerMP) || player == null) continue;
            ((EntityPlayerMP)player).field_71135_a.func_147359_a(packet);
        }
    }

    public void encodeInto(ChannelHandlerContext ctx, SimplePacket msg, ByteBuf target) throws Exception {
        msg.writePacketData(target);
    }

    public void decodeInto(ChannelHandlerContext ctx, ByteBuf source, SimplePacket msg) {
        try {
            msg.readPacketData(source);
            msg.execute();
        }
        catch (IOException e) {
            Logger.getLogger("Network").warning("Something caused a Protocol Exception!");
        }
    }

    public FMLIndexedMessageToMessageCodec<SimplePacket> addDiscriminator(int discriminator, Class<? extends SimplePacket> type) {
        ++this.nextDiscriminator;
        return super.addDiscriminator(discriminator, type);
    }
}

