/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.misc.vecmath;

import java.util.StringTokenizer;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Vecs3d {
    protected double x;
    protected double y;
    protected double z;
    protected World w = null;

    public Vecs3d(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vecs3d(double x, double y, double z, World w) {
        this(x, y, z);
        this.w = w;
    }

    public Vecs3d(TileEntity te) {
        this(te.func_174877_v().func_177958_n(), te.func_174877_v().func_177956_o(), te.func_174877_v().func_177952_p(), te.func_145831_w());
    }

    public Vecs3d(Vec3 vec) {
        this(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    public Vecs3d(Vec3 vec, World w) {
        this(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
        this.w = w;
    }

    public boolean hasWorld() {
        return this.w != null;
    }

    public Vecs3d add(double x, double y, double z) {
        this.x += x;
        this.y += y;
        this.z += z;
        return this;
    }

    public Vecs3d add(EnumFacing dir) {
        return this.add(dir.func_82601_c(), dir.func_96559_d(), dir.func_82599_e());
    }

    public Vecs3d add(Vecs3d vec) {
        return this.add(vec.x, vec.y, vec.z);
    }

    public Vecs3d sub(double x, double y, double z) {
        this.x -= x;
        this.y -= y;
        this.z -= z;
        return this;
    }

    public Vecs3d sub(EnumFacing dir) {
        return this.sub(dir.func_82601_c(), dir.func_96559_d(), dir.func_82599_e());
    }

    public Vecs3d sub(Vecs3d vec) {
        return this.sub(vec.x, vec.y, vec.z);
    }

    public Vecs3d mul(double x, double y, double z) {
        this.x *= x;
        this.y *= y;
        this.z *= z;
        return this;
    }

    public Vecs3d mul(double multiplier) {
        return this.mul(multiplier, multiplier, multiplier);
    }

    public Vecs3d mul(EnumFacing direction) {
        return this.mul(direction.func_82601_c(), direction.func_96559_d(), direction.func_82599_e());
    }

    public Vecs3d multiply(Vecs3d v) {
        return this.mul(v.getX(), v.getY(), v.getZ());
    }

    public Vecs3d div(double x, double y, double z) {
        this.x /= x;
        this.y /= y;
        this.z /= z;
        return this;
    }

    public Vecs3d div(double multiplier) {
        return this.div(multiplier, multiplier, multiplier);
    }

    public Vecs3d div(EnumFacing direction) {
        return this.div(direction.func_82601_c(), direction.func_96559_d(), direction.func_82599_e());
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public Vecs3d normalize() {
        Vecs3d v = this.clone();
        double len = this.length();
        if (len == 0.0) {
            return v;
        }
        v.x /= len;
        v.y /= len;
        v.z /= len;
        return v;
    }

    public Vecs3d abs() {
        return new Vecs3d(Math.abs(this.x), Math.abs(this.y), Math.abs(this.z));
    }

    public double dot(Vecs3d v) {
        return this.x * v.getX() + this.y * v.getY() + this.z * v.getZ();
    }

    public Vecs3d cross(Vecs3d v) {
        return new Vecs3d(this.y * v.getZ() - this.z * v.getY(), this.x * v.getZ() - this.z * v.getX(), this.x * v.getY() - this.y * v.getX());
    }

    public Vecs3d getRelative(double x, double y, double z) {
        return this.clone().add(x, y, z);
    }

    public Vecs3d getRelative(EnumFacing dir) {
        return this.getRelative(dir.func_82601_c(), dir.func_96559_d(), dir.func_82599_e());
    }

    public EnumFacing getDirectionTo(Vecs3d vec) {
        for (EnumFacing d : EnumFacing.field_82609_l) {
            if (this.getBlockX() + d.func_82601_c() != vec.getBlockX() || this.getBlockY() + d.func_96559_d() != vec.getBlockY() || this.getBlockZ() + d.func_82599_e() != vec.getBlockZ()) continue;
            return d;
        }
        return null;
    }

    public boolean isZero() {
        return this.x == 0.0 && this.y == 0.0 && this.z == 0.0;
    }

    public Vecs3d clone() {
        return new Vecs3d(this.x, this.y, this.z, this.w);
    }

    public boolean hasTileEntity() {
        if (this.hasWorld()) {
            return this.w.func_175625_s(this.getBlockPos()) != null;
        }
        return false;
    }

    public BlockPos getBlockPos() {
        return new BlockPos(this.x, this.y, this.z);
    }

    public TileEntity getTileEntity() {
        if (this.hasTileEntity()) {
            return this.w.func_175625_s(this.getBlockPos());
        }
        return null;
    }

    public boolean isBlock(Block b) {
        return this.isBlock(b, false);
    }

    public boolean isBlock(Block b, boolean checkAir) {
        if (this.hasWorld()) {
            Block bl = this.w.func_180495_p(this.getBlockPos()).func_177230_c();
            if (b == null && bl == Blocks.field_150350_a) {
                return true;
            }
            if (b == null && checkAir && bl.func_149688_o() == Material.field_151579_a) {
                return true;
            }
            if (b == null && checkAir && bl.isAir((IBlockAccess)this.w, this.getBlockPos())) {
                return true;
            }
            return bl.getClass().isInstance(b);
        }
        return false;
    }

    public Block getBlock() {
        return this.getBlock(false);
    }

    public Block getBlock(boolean airIsNull) {
        if (this.hasWorld()) {
            if (airIsNull && this.isBlock(null, true)) {
                return null;
            }
            return this.w.func_180495_p(this.getBlockPos()).func_177230_c();
        }
        return null;
    }

    public World getWorld() {
        return this.w;
    }

    public Vecs3d setWorld(World world) {
        this.w = world;
        return this;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public int getBlockX() {
        return (int)Math.floor(this.x);
    }

    public int getBlockY() {
        return (int)Math.floor(this.y);
    }

    public int getBlockZ() {
        return (int)Math.floor(this.z);
    }

    public double distanceTo(Vecs3d vec) {
        return this.distanceTo(vec.x, vec.y, vec.z);
    }

    public double distanceTo(double x, double y, double z) {
        double dx = x - this.x;
        double dy = y - this.y;
        double dz = z - this.z;
        return dx * dx + dy * dy + dz * dz;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public void setZ(double z) {
        this.z = z;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Vecs3d) {
            Vecs3d vec = (Vecs3d)obj;
            return vec.w == this.w && vec.x == this.x && vec.y == this.y && vec.z == this.z;
        }
        return false;
    }

    public int hashCode() {
        return new Double(this.x).hashCode() + new Double(this.y).hashCode() << 8 + new Double(this.z).hashCode() << 16;
    }

    public Vec3 toVec3() {
        return new Vec3(this.x, this.y, this.z);
    }

    public String toString() {
        String s = "Vector3{";
        if (this.hasWorld()) {
            s = s + "w=" + this.w.field_73011_w.func_177502_q() + ";";
        }
        s = s + "x=" + this.x + ";y=" + this.y + ";z=" + this.z + "}";
        return s;
    }

    public EnumFacing toForgeDirection() {
        if (this.z == 1.0) {
            return EnumFacing.SOUTH;
        }
        if (this.z == -1.0) {
            return EnumFacing.NORTH;
        }
        if (this.x == 1.0) {
            return EnumFacing.EAST;
        }
        if (this.x == -1.0) {
            return EnumFacing.WEST;
        }
        if (this.y == 1.0) {
            return EnumFacing.UP;
        }
        if (this.y == -1.0) {
            return EnumFacing.DOWN;
        }
        return null;
    }

    public static Vecs3d fromString(String s) {
        if (s.startsWith("Vector3{") && s.endsWith("}")) {
            World w = null;
            double x = 0.0;
            double y = 0.0;
            double z = 0.0;
            String s2 = s.substring(s.indexOf("{") + 1, s.lastIndexOf("}"));
            StringTokenizer st = new StringTokenizer(s2, ";");
            while (st.hasMoreTokens()) {
                String t = st.nextToken();
                if (t.toLowerCase().startsWith("w")) {
                    int world = Integer.parseInt(t.split("=")[1]);
                    if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
                        for (WorldServer wo : MinecraftServer.func_71276_C().field_71305_c) {
                            if (wo.field_73011_w.func_177502_q() != world) continue;
                            w = wo;
                            break;
                        }
                    } else {
                        w = Vecs3d.getClientWorld(world);
                    }
                }
                if (t.toLowerCase().startsWith("x")) {
                    x = Double.parseDouble(t.split("=")[1]);
                }
                if (t.toLowerCase().startsWith("y")) {
                    y = Double.parseDouble(t.split("=")[1]);
                }
                if (!t.toLowerCase().startsWith("z")) continue;
                z = Double.parseDouble(t.split("=")[1]);
            }
            if (w != null) {
                return new Vecs3d(x, y, z, w);
            }
            return new Vecs3d(x, y, z);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private static World getClientWorld(int world) {
        if (Minecraft.func_71410_x().field_71441_e.field_73011_w.func_177502_q() != world) {
            return null;
        }
        return Minecraft.func_71410_x().field_71441_e;
    }
}

