/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.explosion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import org.apache.commons.lang3.time.StopWatch;
import reborncore.RebornCore;

public class RebornExplosion
extends Explosion {
    @Nonnull
    BlockPos center;
    @Nonnull
    World world;
    @Nonnull
    int radius;
    @Nullable
    EntityLivingBase livingBase;

    public RebornExplosion(@Nonnull BlockPos center, @Nonnull World world, @Nonnull int radius) {
        super(world, null, (double)center.func_177958_n(), (double)center.func_177956_o(), (double)center.func_177952_p(), (float)radius, Collections.emptyList());
        this.center = center;
        this.world = world;
        this.radius = radius;
    }

    public void setLivingBase(@Nullable EntityLivingBase livingBase) {
        this.livingBase = livingBase;
    }

    @Nullable
    public EntityLivingBase getLivingBase() {
        return this.livingBase;
    }

    public void explode() {
        StopWatch watch = new StopWatch();
        watch.start();
        for (int tx = -this.radius; tx < this.radius + 1; ++tx) {
            for (int ty = -this.radius; ty < this.radius + 1; ++ty) {
                for (int tz = -this.radius; tz < this.radius + 1; ++tz) {
                    BlockPos pos;
                    IBlockState state;
                    Block block;
                    if (!(Math.sqrt(Math.pow(tx, 2.0) + Math.pow(ty, 2.0) + Math.pow(tz, 2.0)) <= (double)(this.radius - 2)) || (block = (state = this.world.func_180495_p(pos = this.center.func_177982_a(tx, ty, tz))).func_177230_c()) == Blocks.field_150357_h || block == Blocks.field_150350_a) continue;
                    block.func_180652_a(this.world, pos, (Explosion)this);
                    this.world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                }
            }
        }
        RebornCore.logHelper.info("The explosion took" + watch + " to explode");
    }

    public void func_77278_a() {
        this.explode();
    }

    public void func_77279_a(boolean spawnParticles) {
        this.explode();
    }

    @Nullable
    public EntityLivingBase func_94613_c() {
        return this.livingBase;
    }

    public List<BlockPos> func_180343_e() {
        ArrayList<BlockPos> poses = new ArrayList<BlockPos>();
        for (int tx = -this.radius; tx < this.radius + 1; ++tx) {
            for (int ty = -this.radius; ty < this.radius + 1; ++ty) {
                for (int tz = -this.radius; tz < this.radius + 1; ++tz) {
                    BlockPos pos;
                    IBlockState state;
                    Block block;
                    if (!(Math.sqrt(Math.pow(tx, 2.0) + Math.pow(ty, 2.0) + Math.pow(tz, 2.0)) <= (double)(this.radius - 2)) || (block = (state = this.world.func_180495_p(pos = this.center.func_177982_a(tx, ty, tz))).func_177230_c()) == Blocks.field_150357_h || block == Blocks.field_150350_a) continue;
                    poses.add(pos);
                }
            }
        }
        return poses;
    }
}

