/*
 * Decompiled with CFR 0.152.
 */
package reborncore.client.multiblock;

import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.opengl.GL11;
import reborncore.client.multiblock.IMultiblockRenderHook;
import reborncore.client.multiblock.Multiblock;
import reborncore.client.multiblock.MultiblockSet;
import reborncore.client.multiblock.component.MultiblockComponent;
import reborncore.common.misc.Location;
import reborncore.common.multiblock.CoordTriplet;

public class MultiblockRenderEvent {
    private static BlockRendererDispatcher blockRender = Minecraft.func_71410_x().func_175602_ab();
    public MultiblockSet currentMultiblock;
    public static CoordTriplet anchor;
    public Location partent;
    public static int angle;

    public void setMultiblock(MultiblockSet set) {
        this.currentMultiblock = set;
        anchor = null;
        angle = 0;
        this.partent = null;
    }

    @SubscribeEvent
    public void onWorldRenderLast(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g != null && mc.field_71476_x != null && !mc.field_71439_g.func_70093_af()) {
            mc.field_71439_g.func_71045_bC();
            this.renderPlayerLook((EntityPlayer)mc.field_71439_g, mc.field_71476_x);
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (this.currentMultiblock != null && anchor == null && event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && event.entityPlayer == Minecraft.func_71410_x().field_71439_g) {
            anchor = new CoordTriplet(event.pos);
            angle = MathHelper.func_76128_c((double)((double)event.entityPlayer.field_70177_z * 4.0 / 360.0 + 0.5)) & 3;
            event.setCanceled(true);
        }
    }

    private void renderPlayerLook(EntityPlayer player, MovingObjectPosition src) {
        if (this.currentMultiblock != null) {
            int anchorX = anchor != null ? MultiblockRenderEvent.anchor.x : src.func_178782_a().func_177958_n();
            int anchorY = anchor != null ? MultiblockRenderEvent.anchor.y + 1 : src.func_178782_a().func_177956_o() + 1;
            int anchorZ = anchor != null ? MultiblockRenderEvent.anchor.z : src.func_178782_a().func_177952_p();
            Multiblock mb = this.currentMultiblock.getForEntity((Entity)player);
            for (MultiblockComponent comp : mb.getComponents()) {
                this.renderComponent(player.field_70170_p, mb, comp, anchorX, anchorY, anchorZ);
            }
        }
    }

    private boolean renderComponent(World world, Multiblock mb, MultiblockComponent comp, int anchorX, int anchorY, int anchorZ) {
        CoordTriplet pos = comp.getRelativePosition();
        int x = pos.x + anchorX;
        int y = pos.y + anchorY;
        int z = pos.z + anchorZ;
        if (world.func_180495_p(new BlockPos(x, y, z)) == comp.getBlock()) {
            return false;
        }
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)2929);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.4f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        Block block = comp.getBlock();
        if (IMultiblockRenderHook.renderHooks.containsKey(block)) {
            IMultiblockRenderHook.renderHooks.get(block).renderBlockForMultiblock((IBlockAccess)world, mb, block, comp.getMeta(), blockRender);
        } else {
            blockRender.func_175018_a(block.func_176223_P(), new BlockPos(x, y, z), (IBlockAccess)world, Tessellator.func_178181_a().func_178180_c());
        }
        GL11.glEnable((int)2929);
        GL11.glPopMatrix();
        return true;
    }

    @SubscribeEvent
    public void breakBlock(BlockEvent.BreakEvent event) {
        if (this.partent != null && event.pos.func_177958_n() == this.partent.x && event.pos.func_177956_o() == this.partent.y && event.pos.func_177952_p() == this.partent.z && Minecraft.func_71410_x().field_71441_e == this.partent.world) {
            this.setMultiblock(null);
        }
    }

    @SubscribeEvent
    public void worldUnloaded(WorldEvent.Unload event) {
        this.setMultiblock(null);
    }
}

