/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.jsonDestroyer.client;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.vecmath.Matrix4f;
import me.modmuss50.jsonDestroyer.JsonDestroyer;
import me.modmuss50.jsonDestroyer.api.IDestroyable;
import me.modmuss50.jsonDestroyer.api.IOpaqueBlock;
import me.modmuss50.jsonDestroyer.api.ITexturedBlock;
import me.modmuss50.jsonDestroyer.api.ITexturedBucket;
import me.modmuss50.jsonDestroyer.api.ITexturedFluid;
import me.modmuss50.jsonDestroyer.api.ITexturedItem;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.BlockPartFace;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemTransformVec3f;
import net.minecraft.client.renderer.block.statemap.DefaultStateMapper;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelRotation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.Attributes;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.client.model.IModelState;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.ModelDynBucket;
import net.minecraftforge.client.model.ModelFluid;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.TRSRTransformation;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.util.vector.Vector3f;

public class ModelGenerator {
    private FaceBakery faceBakery = new FaceBakery();
    private final Matrix4f ThirdPerson = ForgeHooksClient.getMatrix((ItemTransformVec3f)new ItemTransformVec3f(new Vector3f(3.3f, 1.0f, -0.3f), new Vector3f(0.0f, 0.1f, -0.15f), new Vector3f(0.35f, 0.35f, 0.35f)));
    private JsonDestroyer jsonDestroyer;
    public ArrayList<BlockIconInfo> blockIconInfoList = new ArrayList();
    public HashMap<BlockIconInfo, TextureAtlasSprite> blockIconList = new HashMap();
    public HashMap<BlockFluidBase, TextureAtlasSprite> fluidIcons = new HashMap();
    public List<ItemIconInfo> itemIcons = new ArrayList<ItemIconInfo>();

    public ModelGenerator(JsonDestroyer jsonDestroyer) {
        this.jsonDestroyer = jsonDestroyer;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void textureStitch(TextureStitchEvent.Pre event) {
        this.blockIconInfoList.clear();
        this.blockIconList.clear();
        this.fluidIcons.clear();
        this.itemIcons.clear();
        TextureMap textureMap = event.map;
        for (Object object : this.jsonDestroyer.objectsToDestroy) {
            IDestroyable itemTexture;
            int i;
            if (object instanceof Block && object instanceof ITexturedBlock) {
                ITexturedBlock blockTextureProvider = (ITexturedBlock)object;
                Block block = (Block)object;
                for (i = 0; i < blockTextureProvider.amountOfStates(); ++i) {
                    for (EnumFacing side : EnumFacing.values()) {
                        String name = blockTextureProvider.getTextureNameFromState(block.func_176203_a(i), side);
                        TextureAtlasSprite texture = textureMap.getTextureExtry(name);
                        if (texture == null) {
                            texture = new CustomTexture(name);
                            textureMap.setTextureEntry(name, texture);
                        }
                        BlockIconInfo iconInfo = new BlockIconInfo(block, i, side);
                        this.blockIconList.put(iconInfo, texture);
                        this.blockIconInfoList.add(iconInfo);
                    }
                }
                continue;
            }
            if (object instanceof BlockFluidBase && object instanceof ITexturedFluid) {
                ITexturedFluid fluidTextureProvider = (ITexturedFluid)object;
                String name = fluidTextureProvider.getTextureName();
                TextureAtlasSprite texture = textureMap.getTextureExtry(name);
                if (texture == null) {
                    texture = new CustomTexture(name);
                    textureMap.setTextureEntry(name, texture);
                }
                this.fluidIcons.put((BlockFluidBase)object, texture);
                continue;
            }
            if (object instanceof Item && object instanceof ITexturedItem) {
                itemTexture = (ITexturedItem)object;
                Item item = (Item)object;
                for (i = 0; i < itemTexture.getMaxMeta(); ++i) {
                    String name = itemTexture.getTextureName(i);
                    TextureAtlasSprite texture = textureMap.getTextureExtry(name);
                    if (texture == null) {
                        texture = new CustomTexture(name);
                        textureMap.setTextureEntry(name, texture);
                    }
                    ItemIconInfo info = new ItemIconInfo((Item)object, i, texture, name);
                    this.itemIcons.add(info);
                }
                continue;
            }
            if (!(object instanceof Item) || !(object instanceof ITexturedBucket)) continue;
            itemTexture = (ITexturedBucket)object;
            for (int i2 = 0; i2 < itemTexture.getMaxMeta(); ++i2) {
                String name = itemTexture.getFluid(i2).getStill().toString();
                TextureAtlasSprite texture = textureMap.getTextureExtry(name);
                if (texture == null) {
                    texture = new CustomTexture(name);
                    textureMap.setTextureEntry(name, texture);
                }
                ItemIconInfo info = new ItemIconInfo((Item)object, i2, texture, name);
                info.isBucket = true;
                this.itemIcons.add(info);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void bakeModels(ModelBakeEvent event) {
        ItemModelMesher itemModelMesher = Minecraft.func_71410_x().func_175599_af().func_175037_a();
        block0: for (Object object : this.jsonDestroyer.objectsToDestroy) {
            Item item;
            int i;
            if (object instanceof Block && object instanceof ITexturedBlock) {
                ITexturedBlock textureProvdier = (ITexturedBlock)object;
                Block block = (Block)object;
                for (i = 0; i < textureProvdier.amountOfStates(); ++i) {
                    HashMap<EnumFacing, TextureAtlasSprite> textureMap = new HashMap<EnumFacing, TextureAtlasSprite>();
                    for (EnumFacing side : EnumFacing.field_82609_l) {
                        for (BlockIconInfo iconInfo : this.blockIconInfoList) {
                            if (iconInfo.getBlock() != block || iconInfo.getMeta() != i || iconInfo.getSide() != side || !this.blockIconList.containsKey(iconInfo)) continue;
                            textureMap.put(side, this.blockIconList.get(iconInfo));
                        }
                    }
                    if (textureMap.isEmpty()) {
                        return;
                    }
                    BlockModel model = new BlockModel(textureMap, block.func_176203_a(i).func_177230_c() instanceof IOpaqueBlock);
                    ModelResourceLocation modelResourceLocation = ModelGenerator.getModelResourceLocation(block.func_176203_a(i));
                    event.modelRegistry.func_82595_a((Object)modelResourceLocation, (Object)model);
                    ModelResourceLocation inventory = ModelGenerator.getBlockinventoryResourceLocation(block);
                    event.modelRegistry.func_82595_a((Object)inventory, (Object)model);
                    itemModelMesher.func_178086_a(Item.func_150898_a((Block)block), i, inventory);
                    event.modelRegistry.func_82595_a((Object)modelResourceLocation, (Object)model);
                    itemModelMesher.func_178086_a(Item.func_150898_a((Block)block), i, modelResourceLocation);
                }
                continue;
            }
            if (object instanceof ITexturedFluid && object instanceof BlockFluidBase) {
                final BlockFluidBase fluid = (BlockFluidBase)object;
                final ModelResourceLocation fluidLocation = new ModelResourceLocation(fluid.getFluid().getFlowing(), "fluid");
                Item fluidItem = Item.func_150898_a((Block)fluid);
                ModelBakery.addVariantName((Item)fluidItem, (String[])new String[0]);
                ModelLoader.setCustomMeshDefinition((Item)fluidItem, (ItemMeshDefinition)new ItemMeshDefinition(){

                    public ModelResourceLocation func_178113_a(ItemStack stack) {
                        return fluidLocation;
                    }
                });
                ModelLoader.setCustomStateMapper((Block)fluid, (IStateMapper)new StateMapperBase(){

                    protected ModelResourceLocation func_178132_a(IBlockState state) {
                        return fluidLocation;
                    }
                });
                for (int i2 = 0; i2 < 16; ++i2) {
                    ModelResourceLocation location = new ModelResourceLocation(ModelGenerator.getBlockResourceLocation((Block)fluid), "level=" + i2);
                    if (event.modelManager.func_174953_a(location) != event.modelManager.func_174951_a()) {
                        FMLLog.info((String)("Model found @ " + location.toString() + ", this means a resource pack is overriding it or a modder is doing something bad. JSON-Destoyer will not attempt to create a model for it."), (Object[])new Object[0]);
                        continue;
                    }
                    ModelFluid modelFluid = new ModelFluid(fluid.getFluid());
                    Function<ResourceLocation, TextureAtlasSprite> textureGetter = new Function<ResourceLocation, TextureAtlasSprite>(){

                        public TextureAtlasSprite apply(ResourceLocation location) {
                            return ModelGenerator.this.fluidIcons.get(fluid);
                        }
                    };
                    IFlexibleBakedModel bakedModel = modelFluid.bake(modelFluid.getDefaultState(), DefaultVertexFormats.field_176600_a, (Function)textureGetter);
                    event.modelRegistry.func_82595_a((Object)location, (Object)bakedModel);
                }
                ModelResourceLocation inventoryLocation = new ModelResourceLocation(ModelGenerator.getBlockResourceLocation((Block)fluid), "inventory");
                ModelFluid modelFluid = new ModelFluid(fluid.getFluid());
                Function<ResourceLocation, TextureAtlasSprite> textureGetter = new Function<ResourceLocation, TextureAtlasSprite>(){

                    public TextureAtlasSprite apply(ResourceLocation location) {
                        return ModelGenerator.this.fluidIcons.get(fluid);
                    }
                };
                IFlexibleBakedModel bakedModel = modelFluid.bake(modelFluid.getDefaultState(), DefaultVertexFormats.field_176599_b, (Function)textureGetter);
                event.modelRegistry.func_82595_a((Object)inventoryLocation, (Object)bakedModel);
                continue;
            }
            if (object instanceof Item && object instanceof ITexturedItem) {
                ITexturedItem iTexturedItem = (ITexturedItem)object;
                item = (Item)object;
                for (i = 0; i < iTexturedItem.getMaxMeta(); ++i) {
                    TextureAtlasSprite texture = null;
                    ItemIconInfo itemIconInfo = null;
                    for (ItemIconInfo info : this.itemIcons) {
                        if (info.damage != i || info.getItem() != item || info.isBucket) continue;
                        texture = info.getSprite();
                        itemIconInfo = info;
                        break;
                    }
                    if (texture == null) continue block0;
                    ModelResourceLocation inventory = ModelGenerator.getItemInventoryResourceLocation(item);
                    if (iTexturedItem.getMaxMeta() != 1 && item.getModel(new ItemStack(item, 1, i), (EntityPlayer)Minecraft.func_71410_x().field_71439_g, 0) != null) {
                        inventory = item.getModel(new ItemStack(item, 1, i), (EntityPlayer)Minecraft.func_71410_x().field_71439_g, 0);
                    }
                    final TextureAtlasSprite finalTexture = texture;
                    Function<ResourceLocation, TextureAtlasSprite> textureGetter = new Function<ResourceLocation, TextureAtlasSprite>(){

                        public TextureAtlasSprite apply(ResourceLocation location) {
                            return finalTexture;
                        }
                    };
                    ImmutableList.Builder builder = ImmutableList.builder();
                    builder.add((Object)new ResourceLocation(itemIconInfo.textureName));
                    CustomModel itemLayerModel = new CustomModel((ImmutableList<ResourceLocation>)builder.build());
                    IFlexibleBakedModel model = itemLayerModel.bake(ItemLayerModel.instance.getDefaultState(), DefaultVertexFormats.field_176599_b, textureGetter);
                    itemModelMesher.func_178086_a(item, i, inventory);
                    event.modelRegistry.func_82595_a((Object)inventory, (Object)model);
                }
                continue;
            }
            if (!(object instanceof Item) || !(object instanceof ITexturedBucket)) continue;
            ITexturedBucket iTexturedBucket = (ITexturedBucket)object;
            item = (Item)object;
            for (i = 0; i < iTexturedBucket.getMaxMeta(); ++i) {
                ModelResourceLocation inventory = ModelGenerator.getItemInventoryResourceLocation(item);
                if (iTexturedBucket.getMaxMeta() != 1 && item.getModel(new ItemStack(item, 1, i), (EntityPlayer)Minecraft.func_71410_x().field_71439_g, 0) != null) {
                    inventory = item.getModel(new ItemStack(item, 1, i), (EntityPlayer)Minecraft.func_71410_x().field_71439_g, 0);
                }
                Function<ResourceLocation, TextureAtlasSprite> textureGetter = new Function<ResourceLocation, TextureAtlasSprite>(){

                    public TextureAtlasSprite apply(ResourceLocation location) {
                        return Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
                    }
                };
                ModelDynBucket modelDynBucket = new ModelDynBucket(new ResourceLocation("forge:items/bucket_base"), new ResourceLocation("forge:items/bucket_fluid"), new ResourceLocation("forge:items/bucket_cover"), iTexturedBucket.getFluid(i), iTexturedBucket.isGas(i));
                IFlexibleBakedModel model = modelDynBucket.bake(ItemLayerModel.instance.getDefaultState(), DefaultVertexFormats.field_176599_b, (Function)textureGetter);
                itemModelMesher.func_178086_a(item, i, inventory);
                event.modelRegistry.func_82595_a((Object)inventory, (Object)model);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static ModelResourceLocation getModelResourceLocation(IBlockState state) {
        return new ModelResourceLocation((ResourceLocation)Block.field_149771_c.func_177774_c((Object)state.func_177230_c()), new DefaultStateMapper().func_178131_a((Map)state.func_177228_b()));
    }

    @SideOnly(value=Side.CLIENT)
    public static ModelResourceLocation getBlockinventoryResourceLocation(Block block) {
        return new ModelResourceLocation((ResourceLocation)Block.field_149771_c.func_177774_c((Object)block), "inventory");
    }

    @SideOnly(value=Side.CLIENT)
    public static ModelResourceLocation getItemInventoryResourceLocation(Item block) {
        return new ModelResourceLocation((ResourceLocation)Item.field_150901_e.func_177774_c((Object)block), "inventory");
    }

    @SideOnly(value=Side.CLIENT)
    public static ResourceLocation getBlockResourceLocation(Block block) {
        return (ResourceLocation)Block.field_149771_c.func_177774_c((Object)block);
    }

    public class CustomBakedModel
    extends ItemLayerModel.BakedModel
    implements IPerspectiveAwareModel {
        private final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms;
        public final Matrix4f THIRD_PERSON_2D;
        public final Matrix4f FIRST_PERSON_FIX;

        public CustomBakedModel(ImmutableList<BakedQuad> quads, TextureAtlasSprite particle, VertexFormat format, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms) {
            super(quads, particle, format);
            this.THIRD_PERSON_2D = ForgeHooksClient.getMatrix((ItemTransformVec3f)new ItemTransformVec3f(new Vector3f(4.8f, 0.0f, 0.0f), new Vector3f(0.0f, 0.07f, -0.2f), new Vector3f(0.55f, 0.55f, 0.55f)));
            this.FIRST_PERSON_FIX = ForgeHooksClient.getMatrix((ItemTransformVec3f)new ItemTransformVec3f(new Vector3f(0.0f, 4.0f, 0.5f), new Vector3f(-0.1f, 0.3f, 0.1f), new Vector3f(1.3f, 1.3f, 1.3f)));
            this.transforms = transforms;
        }

        public Pair<? extends IFlexibleBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
            if (cameraTransformType == ItemCameraTransforms.TransformType.FIRST_PERSON) {
                return Pair.of(IFlexibleBakedModel.class.cast((Object)this), (Object)this.FIRST_PERSON_FIX);
            }
            if (cameraTransformType == ItemCameraTransforms.TransformType.THIRD_PERSON) {
                return Pair.of(IFlexibleBakedModel.class.cast((Object)this), (Object)this.THIRD_PERSON_2D);
            }
            return Pair.of(IFlexibleBakedModel.class.cast((Object)this), null);
        }
    }

    public class CustomModel
    extends ItemLayerModel {
        ImmutableList<ResourceLocation> textures;

        public CustomModel(ImmutableList<ResourceLocation> textures) {
            super(textures);
            this.textures = textures;
        }

        public IFlexibleBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
            ImmutableList.Builder builder = ImmutableList.builder();
            Optional transform = state.apply(Optional.absent());
            for (int i = 0; i < this.textures.size(); ++i) {
                TextureAtlasSprite sprite = (TextureAtlasSprite)bakedTextureGetter.apply(this.textures.get(i));
                builder.addAll((Iterable)this.getQuadsForSprite(i, sprite, format, transform));
            }
            TextureAtlasSprite particle = (TextureAtlasSprite)bakedTextureGetter.apply((Object)(this.textures.isEmpty() ? new ResourceLocation("missingno") : (ResourceLocation)this.textures.get(0)));
            ImmutableMap transforms = IPerspectiveAwareModel.MapWrapper.getTransforms((IModelState)state);
            CustomBakedModel ret = new CustomBakedModel((ImmutableList<BakedQuad>)builder.build(), particle, format, (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)transforms);
            if (transforms.isEmpty()) {
                return ret;
            }
            return new IPerspectiveAwareModel.MapWrapper((IFlexibleBakedModel)ret, transforms);
        }
    }

    public class ItemIconInfo {
        Item item;
        int damage;
        TextureAtlasSprite sprite;
        String textureName;
        public boolean isBucket = false;

        public Item getItem() {
            return this.item;
        }

        public TextureAtlasSprite getSprite() {
            return this.sprite;
        }

        public ItemIconInfo(Item item, int damage, TextureAtlasSprite sprite, String textureName) {
            this.item = item;
            this.damage = damage;
            this.sprite = sprite;
            this.textureName = textureName;
        }
    }

    public class BlockModel
    implements IFlexibleBakedModel,
    IPerspectiveAwareModel {
        HashMap<EnumFacing, TextureAtlasSprite> textureAtlasSpriteHashMap;
        boolean isOpaque;

        public BlockModel(HashMap<EnumFacing, TextureAtlasSprite> textureAtlasSpriteHashMap, boolean isOpaque) {
            this.textureAtlasSpriteHashMap = textureAtlasSpriteHashMap;
            this.isOpaque = isOpaque;
        }

        public List<BakedQuad> func_177551_a(EnumFacing side) {
            if (this.isOpaque) {
                return Collections.emptyList();
            }
            ArrayList<BakedQuad> list = new ArrayList<BakedQuad>();
            BlockFaceUV uv = new BlockFaceUV(new float[]{0.0f, 0.0f, 16.0f, 16.0f}, 0);
            BlockPartFace face = new BlockPartFace(null, 0, "", uv);
            ModelRotation modelRot = ModelRotation.X0_Y0;
            boolean scale = true;
            switch (side) {
                case DOWN: {
                    list.add(ModelGenerator.this.faceBakery.func_178414_a(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(16.0f, 0.0f, 16.0f), face, this.textureAtlasSpriteHashMap.get(side), side, modelRot, null, scale, true));
                    break;
                }
                case UP: {
                    list.add(ModelGenerator.this.faceBakery.func_178414_a(new Vector3f(0.0f, 16.0f, 0.0f), new Vector3f(16.0f, 16.0f, 16.0f), face, this.textureAtlasSpriteHashMap.get(side), side, modelRot, null, scale, true));
                    break;
                }
                case NORTH: {
                    list.add(ModelGenerator.this.faceBakery.func_178414_a(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(16.0f, 16.0f, 0.0f), face, this.textureAtlasSpriteHashMap.get(side), side, modelRot, null, scale, true));
                    break;
                }
                case SOUTH: {
                    list.add(ModelGenerator.this.faceBakery.func_178414_a(new Vector3f(0.0f, 0.0f, 16.0f), new Vector3f(16.0f, 16.0f, 16.0f), face, this.textureAtlasSpriteHashMap.get(side), side, modelRot, null, scale, true));
                    break;
                }
                case EAST: {
                    list.add(ModelGenerator.this.faceBakery.func_178414_a(new Vector3f(16.0f, 0.0f, 0.0f), new Vector3f(16.0f, 16.0f, 16.0f), face, this.textureAtlasSpriteHashMap.get(side), side, modelRot, null, scale, true));
                    break;
                }
                case WEST: {
                    list.add(ModelGenerator.this.faceBakery.func_178414_a(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 16.0f, 16.0f), face, this.textureAtlasSpriteHashMap.get(side), side, modelRot, null, scale, true));
                }
            }
            return list;
        }

        public List<BakedQuad> func_177550_a() {
            if (this.isOpaque) {
                ArrayList<BakedQuad> list = new ArrayList<BakedQuad>();
                BlockFaceUV uv = new BlockFaceUV(new float[]{0.0f, 0.0f, 16.0f, 16.0f}, 0);
                BlockPartFace face = new BlockPartFace(null, 0, "", uv);
                ModelRotation modelRot = ModelRotation.X0_Y0;
                boolean scale = true;
                list.add(ModelGenerator.this.faceBakery.func_178414_a(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(16.0f, 0.0f, 16.0f), face, this.textureAtlasSpriteHashMap.get(EnumFacing.DOWN), EnumFacing.DOWN, modelRot, null, scale, true));
                list.add(ModelGenerator.this.faceBakery.func_178414_a(new Vector3f(0.0f, 16.0f, 0.0f), new Vector3f(16.0f, 16.0f, 16.0f), face, this.textureAtlasSpriteHashMap.get(EnumFacing.UP), EnumFacing.UP, modelRot, null, scale, true));
                list.add(ModelGenerator.this.faceBakery.func_178414_a(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(16.0f, 16.0f, 0.0f), face, this.textureAtlasSpriteHashMap.get(EnumFacing.NORTH), EnumFacing.NORTH, modelRot, null, scale, true));
                list.add(ModelGenerator.this.faceBakery.func_178414_a(new Vector3f(0.0f, 0.0f, 16.0f), new Vector3f(16.0f, 16.0f, 16.0f), face, this.textureAtlasSpriteHashMap.get(EnumFacing.SOUTH), EnumFacing.SOUTH, modelRot, null, scale, true));
                list.add(ModelGenerator.this.faceBakery.func_178414_a(new Vector3f(16.0f, 0.0f, 0.0f), new Vector3f(16.0f, 16.0f, 16.0f), face, this.textureAtlasSpriteHashMap.get(EnumFacing.EAST), EnumFacing.EAST, modelRot, null, scale, true));
                list.add(ModelGenerator.this.faceBakery.func_178414_a(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 16.0f, 16.0f), face, this.textureAtlasSpriteHashMap.get(EnumFacing.WEST), EnumFacing.WEST, modelRot, null, scale, true));
                return list;
            }
            return Collections.emptyList();
        }

        public boolean func_177556_c() {
            return true;
        }

        public boolean func_177555_b() {
            return true;
        }

        public boolean func_177553_d() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return this.textureAtlasSpriteHashMap.get(EnumFacing.DOWN);
        }

        public ItemCameraTransforms func_177552_f() {
            return ItemCameraTransforms.field_178357_a;
        }

        public Pair<? extends IFlexibleBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
            if (cameraTransformType == ItemCameraTransforms.TransformType.THIRD_PERSON) {
                return Pair.of(IFlexibleBakedModel.class.cast(this), (Object)ModelGenerator.this.ThirdPerson);
            }
            return Pair.of(IFlexibleBakedModel.class.cast(this), null);
        }

        public VertexFormat getFormat() {
            return Attributes.DEFAULT_BAKED_FORMAT;
        }
    }

    public class BlockIconInfo {
        public Block block;
        public int meta;
        public EnumFacing side;

        public BlockIconInfo(Block block, int meta, EnumFacing side) {
            this.block = block;
            this.meta = meta;
            this.side = side;
        }

        public Block getBlock() {
            return this.block;
        }

        public int getMeta() {
            return this.meta;
        }

        public EnumFacing getSide() {
            return this.side;
        }
    }

    public class CustomTexture
    extends TextureAtlasSprite {
        public CustomTexture(String spriteName) {
            super(spriteName);
        }
    }
}

