/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.ironchest;

import cpw.mods.ironchest.ContainerIronChest;
import cpw.mods.ironchest.IronChest;
import cpw.mods.ironchest.IronChestType;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityLockable;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;

public class TileEntityIronChest
extends TileEntityLockable
implements ITickable,
IInventory {
    private int ticksSinceSync = -1;
    public float prevLidAngle;
    public float lidAngle;
    private int numUsingPlayers;
    private IronChestType type;
    public ItemStack[] chestContents;
    private ItemStack[] topStacks;
    private byte facing;
    private boolean inventoryTouched;
    private boolean hadStuff;
    private String customName;

    public TileEntityIronChest() {
        this(IronChestType.IRON);
    }

    protected TileEntityIronChest(IronChestType type) {
        this.type = type;
        this.chestContents = new ItemStack[this.func_70302_i_()];
        this.topStacks = new ItemStack[8];
    }

    public ItemStack[] getContents() {
        return this.chestContents;
    }

    public void setContents(ItemStack[] contents) {
        this.chestContents = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < contents.length; ++i) {
            if (i >= this.chestContents.length) continue;
            this.chestContents[i] = contents[i];
        }
        this.inventoryTouched = true;
    }

    public int func_70302_i_() {
        return this.type.size;
    }

    public int getFacing() {
        return this.facing;
    }

    public IronChestType getType() {
        return this.type;
    }

    public ItemStack func_70301_a(int i) {
        this.inventoryTouched = true;
        return this.chestContents[i];
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.sortTopStacks();
    }

    protected void sortTopStacks() {
        int i;
        int i2;
        if (!this.type.isTransparent() || this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            return;
        }
        ItemStack[] tempCopy = new ItemStack[this.func_70302_i_()];
        boolean hasStuff = false;
        int compressedIdx = 0;
        block0: for (i2 = 0; i2 < this.func_70302_i_(); ++i2) {
            if (this.chestContents[i2] == null) continue;
            for (int j = 0; j < compressedIdx; ++j) {
                if (!tempCopy[j].func_77969_a(this.chestContents[i2])) continue;
                tempCopy[j].field_77994_a += this.chestContents[i2].field_77994_a;
                continue block0;
            }
            tempCopy[compressedIdx++] = this.chestContents[i2].func_77946_l();
            hasStuff = true;
        }
        if (!hasStuff && this.hadStuff) {
            this.hadStuff = false;
            for (i2 = 0; i2 < this.topStacks.length; ++i2) {
                this.topStacks[i2] = null;
            }
            if (this.field_145850_b != null) {
                this.field_145850_b.func_175689_h(this.field_174879_c);
            }
            return;
        }
        this.hadStuff = true;
        Arrays.sort(tempCopy, new Comparator<ItemStack>(){

            @Override
            public int compare(ItemStack o1, ItemStack o2) {
                if (o1 == null) {
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                return o2.field_77994_a - o1.field_77994_a;
            }
        });
        int p = 0;
        for (i = 0; i < tempCopy.length; ++i) {
            if (tempCopy[i] == null || tempCopy[i].field_77994_a <= 0) continue;
            this.topStacks[p++] = tempCopy[i];
            if (p == this.topStacks.length) break;
        }
        for (i = p; i < this.topStacks.length; ++i) {
            this.topStacks[i] = null;
        }
        if (this.field_145850_b != null) {
            this.field_145850_b.func_175689_h(this.field_174879_c);
        }
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.chestContents[i] != null) {
            if (this.chestContents[i].field_77994_a <= j) {
                ItemStack itemstack = this.chestContents[i];
                this.chestContents[i] = null;
                this.func_70296_d();
                return itemstack;
            }
            ItemStack itemstack1 = this.chestContents[i].func_77979_a(j);
            if (this.chestContents[i].field_77994_a == 0) {
                this.chestContents[i] = null;
            }
            this.func_70296_d();
            return itemstack1;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.chestContents[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.customName : this.type.name();
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        NBTTagList nbttaglist = nbttagcompound.func_150295_c("Items", 10);
        this.chestContents = new ItemStack[this.func_70302_i_()];
        if (nbttagcompound.func_150297_b("CustomName", 8)) {
            this.customName = nbttagcompound.func_74779_i("CustomName");
        }
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            int j = nbttagcompound1.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= this.chestContents.length) continue;
            this.chestContents[j] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
        this.facing = nbttagcompound.func_74771_c("facing");
        this.sortTopStacks();
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.chestContents.length; ++i) {
            if (this.chestContents[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.chestContents[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbttagcompound.func_74782_a("Items", (NBTBase)nbttaglist);
        nbttagcompound.func_74774_a("facing", this.facing);
        if (this.func_145818_k_()) {
            nbttagcompound.func_74778_a("CustomName", this.customName);
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        if (this.field_145850_b == null) {
            return true;
        }
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return entityplayer.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && this.numUsingPlayers != 0 && (this.ticksSinceSync + this.field_174879_c.func_177958_n() + this.field_174879_c.func_177956_o() + this.field_174879_c.func_177952_p()) % 200 == 0) {
            this.numUsingPlayers = 0;
            float var1 = 5.0f;
            List var2 = this.field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB((double)((float)this.field_174879_c.func_177958_n() - var1), (double)((float)this.field_174879_c.func_177956_o() - var1), (double)((float)this.field_174879_c.func_177952_p() - var1), (double)((float)(this.field_174879_c.func_177958_n() + 1) + var1), (double)((float)(this.field_174879_c.func_177956_o() + 1) + var1), (double)((float)(this.field_174879_c.func_177952_p() + 1) + var1)));
            for (EntityPlayer var4 : var2) {
                if (!(var4.field_71070_bA instanceof ContainerIronChest)) continue;
                ++this.numUsingPlayers;
            }
        }
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && this.ticksSinceSync < 0) {
            this.field_145850_b.func_175641_c(this.field_174879_c, (Block)IronChest.ironChestBlock, 3, this.numUsingPlayers << 3 & 0xF8 | this.facing & 7);
        }
        if (!this.field_145850_b.field_72995_K && this.inventoryTouched) {
            this.inventoryTouched = false;
            this.sortTopStacks();
        }
        ++this.ticksSinceSync;
        this.prevLidAngle = this.lidAngle;
        float f = 0.1f;
        if (this.numUsingPlayers > 0 && this.lidAngle == 0.0f) {
            double d = (double)this.field_174879_c.func_177958_n() + 0.5;
            double d1 = (double)this.field_174879_c.func_177952_p() + 0.5;
            this.field_145850_b.func_72908_a(d, (double)this.field_174879_c.func_177956_o() + 0.5, d1, "random.chestopen", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        if (this.numUsingPlayers == 0 && this.lidAngle > 0.0f || this.numUsingPlayers > 0 && this.lidAngle < 1.0f) {
            float f2;
            float f1 = this.lidAngle;
            this.lidAngle = this.numUsingPlayers > 0 ? (this.lidAngle += f) : (this.lidAngle -= f);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            if (this.lidAngle < (f2 = 0.5f) && f1 >= f2) {
                double d2 = (double)this.field_174879_c.func_177958_n() + 0.5;
                double d3 = (double)this.field_174879_c.func_177952_p() + 0.5;
                this.field_145850_b.func_72908_a(d2, (double)this.field_174879_c.func_177956_o() + 0.5, d3, "random.chestclosed", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
    }

    public boolean func_145842_c(int i, int j) {
        if (i == 1) {
            this.numUsingPlayers = j;
        } else if (i == 2) {
            this.facing = (byte)j;
        } else if (i == 3) {
            this.facing = (byte)(j & 7);
            this.numUsingPlayers = (j & 0xF8) >> 3;
        }
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
        if (this.field_145850_b == null) {
            return;
        }
        ++this.numUsingPlayers;
        this.field_145850_b.func_175641_c(this.field_174879_c, (Block)IronChest.ironChestBlock, 1, this.numUsingPlayers);
    }

    public void func_174886_c(EntityPlayer player) {
        if (this.field_145850_b == null) {
            return;
        }
        --this.numUsingPlayers;
        this.field_145850_b.func_175641_c(this.field_174879_c, (Block)IronChest.ironChestBlock, 1, this.numUsingPlayers);
    }

    public void setFacing(byte facing2) {
        this.facing = facing2;
    }

    public ItemStack[] getTopItemStacks() {
        return this.topStacks;
    }

    public TileEntityIronChest updateFromMetadata(int l) {
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K && l != this.type.ordinal()) {
            this.field_145850_b.func_175690_a(this.field_174879_c, (TileEntity)IronChestType.makeEntity(l));
            return (TileEntityIronChest)this.field_145850_b.func_175625_s(this.field_174879_c);
        }
        return this;
    }

    public Packet<?> func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("type", this.getType().ordinal());
        nbt.func_74774_a("facing", this.facing);
        ItemStack[] stacks = this.buildItemStackDataList();
        if (stacks != null) {
            NBTTagList nbttaglist = new NBTTagList();
            for (int i = 0; i < stacks.length; ++i) {
                if (stacks[i] == null) continue;
                NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                nbttagcompound1.func_74774_a("Slot", (byte)i);
                stacks[i].func_77955_b(nbttagcompound1);
                nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
            }
            nbt.func_74782_a("stacks", (NBTBase)nbttaglist);
        }
        return new S35PacketUpdateTileEntity(this.field_174879_c, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        if (pkt.func_148853_f() == 0) {
            NBTTagCompound nbt = pkt.func_148857_g();
            this.type = IronChestType.values()[nbt.func_74762_e("type")];
            this.facing = nbt.func_74771_c("facing");
            NBTTagList tagList = nbt.func_150295_c("stacks", 10);
            ItemStack[] stacks = new ItemStack[this.topStacks.length];
            for (int i = 0; i < stacks.length; ++i) {
                NBTTagCompound nbt1 = tagList.func_150305_b(i);
                int j = nbt1.func_74771_c("Slot") & 0xFF;
                if (j < 0 || j >= stacks.length) continue;
                stacks[j] = ItemStack.func_77949_a((NBTTagCompound)nbt1);
            }
            if (this.type.isTransparent() && stacks != null) {
                int pos = 0;
                for (int i = 0; i < this.topStacks.length; ++i) {
                    this.topStacks[i] = stacks[pos] != null ? stacks[pos] : null;
                    ++pos;
                }
            }
        }
    }

    public ItemStack[] buildItemStackDataList() {
        if (this.type.isTransparent()) {
            ItemStack[] sortList = new ItemStack[this.topStacks.length];
            int pos = 0;
            for (ItemStack is : this.topStacks) {
                sortList[pos++] = is != null ? is : null;
            }
            return sortList;
        }
        return null;
    }

    public ItemStack func_70304_b(int par1) {
        if (this.chestContents[par1] != null) {
            ItemStack var2 = this.chestContents[par1];
            this.chestContents[par1] = null;
            return var2;
        }
        return null;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return this.type.acceptsStack(itemstack);
    }

    public void rotateAround() {
        this.facing = (byte)(this.facing + 1);
        if (this.facing > EnumFacing.EAST.ordinal()) {
            this.facing = (byte)EnumFacing.NORTH.ordinal();
        }
        this.setFacing(this.facing);
        this.field_145850_b.func_175641_c(this.field_174879_c, (Block)IronChest.ironChestBlock, 2, (int)this.facing);
    }

    public void wasPlaced(EntityLivingBase entityliving, ItemStack itemStack) {
    }

    public void removeAdornments() {
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.chestContents.length; ++i) {
            this.chestContents[i] = null;
        }
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer player) {
        return null;
    }

    public String func_174875_k() {
        return "IronChest:" + this.type.name();
    }

    public boolean canRenderBreaking() {
        return true;
    }
}

