/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.world.gen.dungeon;

import java.util.Random;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.Corridor;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.DungeonConfiguration;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.DungeonStart;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.Piece;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public abstract class DirectionalPiece
extends Piece {
    private EnumFacing direction;

    public DirectionalPiece() {
    }

    public DirectionalPiece(DungeonConfiguration configuration, EnumFacing direction) {
        super(configuration);
        this.direction = direction;
    }

    public EnumFacing getDirection() {
        return this.direction;
    }

    public void setDirection(EnumFacing direction) {
        this.direction = direction;
    }

    @Override
    protected void func_143012_a(NBTTagCompound tagCompound) {
        super.func_143012_a(tagCompound);
        tagCompound.func_74768_a("direction", this.direction.ordinal());
    }

    @Override
    protected void func_143011_b(NBTTagCompound tagCompound) {
        super.func_143011_b(tagCompound);
        this.direction = tagCompound.func_74764_b("direction") ? EnumFacing.func_82600_a((int)tagCompound.func_74762_e("direction")) : EnumFacing.NORTH;
    }

    public Piece getCorridor(Random rand, DungeonStart startPiece, int maxAttempts, boolean small) {
        int sizeZ;
        int sizeX;
        int blockZ;
        int blockX;
        EnumFacing randomDir;
        StructureBoundingBox extension;
        boolean valid;
        int attempts = maxAttempts;
        do {
            int randDir;
            randomDir = EnumFacing.func_176731_b((int)(((randDir = rand.nextInt(4)) == this.getDirection().func_176734_d().func_176736_b() ? randDir + 1 : randDir) % 4));
            extension = this.getExtension(randomDir, this.configuration.getHallwayLengthMin() + rand.nextInt(this.configuration.getHallwayLengthMax() - this.configuration.getHallwayLengthMin()), 3);
            blockX = extension.field_78897_a;
            blockZ = extension.field_78896_c;
            sizeX = extension.field_78893_d - extension.field_78897_a;
            sizeZ = extension.field_78892_f - extension.field_78896_c;
        } while (!(valid = !startPiece.checkIntersection(extension)) && --attempts > 0);
        if (!valid) {
            return null;
        }
        return new Corridor(this.configuration, rand, blockX, blockZ, sizeX, small ? 3 : this.configuration.getHallwayHeight(), sizeZ, randomDir);
    }
}

