/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.world.gen.dungeon;

import java.lang.reflect.Constructor;
import java.util.Random;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.blocks.BlockUnlitTorch;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.DungeonConfiguration;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.DungeonStart;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.Piece;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.RoomBoss;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.RoomChest;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.RoomEmpty;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.RoomSpawner;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.SizedPiece;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public class Corridor
extends SizedPiece {
    public Corridor() {
    }

    public Corridor(DungeonConfiguration configuration, Random rand, int blockPosX, int blockPosZ, int sizeX, int sizeY, int sizeZ, EnumFacing direction) {
        super(configuration, sizeX, sizeY, sizeZ, direction);
        this.field_74885_f = EnumFacing.SOUTH;
        this.field_74887_e = new StructureBoundingBox(blockPosX, configuration.getYPosition(), blockPosZ, blockPosX + sizeX, configuration.getYPosition() + sizeY, blockPosZ + sizeZ);
    }

    public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
        for (int i = 0; i < this.field_74887_e.func_78883_b(); ++i) {
            for (int j = 0; j < this.field_74887_e.func_78882_c(); ++j) {
                for (int k = 0; k < this.field_74887_e.func_78880_d(); ++k) {
                    if (this.getDirection().func_176740_k() == EnumFacing.Axis.Z && (i == 0 || i == this.field_74887_e.func_78883_b() - 1) || j == 0 || j == this.field_74887_e.func_78882_c() - 1 || this.getDirection().func_176740_k() == EnumFacing.Axis.X && (k == 0 || k == this.field_74887_e.func_78880_d() - 1)) {
                        this.func_175811_a(worldIn, this.configuration.getBrickBlock(), i, j, k, this.field_74887_e);
                        continue;
                    }
                    if (j == this.field_74887_e.func_78882_c() - 2) {
                        if (this.getDirection().func_176740_k() == EnumFacing.Axis.Z && (k + 1) % 4 == 0 && (i == 1 || i == this.field_74887_e.func_78883_b() - 2)) {
                            this.func_175811_a(worldIn, GCBlocks.unlitTorch.func_176223_P().func_177226_a((IProperty)BlockUnlitTorch.FACING, (Comparable)(i == 1 ? EnumFacing.WEST.func_176734_d() : EnumFacing.EAST.func_176734_d())), i, j, k, this.field_74887_e);
                            continue;
                        }
                        if (this.getDirection().func_176740_k() == EnumFacing.Axis.X && (i + 1) % 4 == 0 && (k == 1 || k == this.field_74887_e.func_78880_d() - 2)) {
                            this.func_175811_a(worldIn, GCBlocks.unlitTorch.func_176223_P().func_177226_a((IProperty)BlockUnlitTorch.FACING, (Comparable)(k == 1 ? EnumFacing.NORTH.func_176734_d() : EnumFacing.SOUTH.func_176734_d())), i, j, k, this.field_74887_e);
                            continue;
                        }
                    }
                    this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), i, j, k, this.field_74887_e);
                }
            }
        }
        return true;
    }

    private <T extends SizedPiece> T getRoom(Class<?> clazz, DungeonStart startPiece, Random rand) {
        try {
            Constructor<?> c0 = clazz.getConstructor(DungeonConfiguration.class, Random.class, Integer.TYPE, Integer.TYPE, EnumFacing.class);
            SizedPiece dummy = (SizedPiece)((Object)c0.newInstance(this.configuration, rand, 0, 0, this.getDirection().func_176734_d()));
            StructureBoundingBox extension = this.getExtension(this.getDirection(), this.getDirection().func_176740_k() == EnumFacing.Axis.X ? dummy.getSizeX() : dummy.getSizeZ(), this.getDirection().func_176740_k() == EnumFacing.Axis.X ? dummy.getSizeZ() : dummy.getSizeX());
            if (startPiece.checkIntersection(extension)) {
                return null;
            }
            int sizeX = extension.field_78893_d - extension.field_78897_a;
            int sizeZ = extension.field_78892_f - extension.field_78896_c;
            int sizeY = dummy.sizeY;
            int blockX = extension.field_78897_a;
            int blockZ = extension.field_78896_c;
            Constructor<?> c1 = clazz.getConstructor(DungeonConfiguration.class, Random.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, EnumFacing.class);
            return (T)((Object)((SizedPiece)((Object)c1.newInstance(this.configuration, rand, blockX, blockZ, sizeX, sizeY, sizeZ, this.getDirection().func_176734_d()))));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Piece getNextPiece(DungeonStart startPiece, Random rand) {
        if (startPiece.attachedComponents.size() > 2 && startPiece.attachedComponents.get(startPiece.attachedComponents.size() - 2) instanceof RoomBoss) {
            try {
                return this.getRoom(this.configuration.getTreasureRoom(), startPiece, rand);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            boolean bossRoom;
            int bossRoomChance = Math.max((int)(1.0 / Math.pow((double)startPiece.attachedComponents.size() / 55.0, 2.0)), 5);
            boolean bl = bossRoom = rand.nextInt(bossRoomChance) == 0;
            if (bossRoom) {
                try {
                    return this.getRoom(this.configuration.getBossRoom(), startPiece, rand);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                StructureBoundingBox extension = this.getExtension(this.getDirection(), rand.nextInt(4) + 6, rand.nextInt(4) + 6);
                if (startPiece.checkIntersection(extension)) {
                    return null;
                }
                int sizeX = extension.field_78893_d - extension.field_78897_a;
                int sizeZ = extension.field_78892_f - extension.field_78896_c;
                int sizeY = this.configuration.getRoomHeight();
                int blockX = extension.field_78897_a;
                int blockZ = extension.field_78896_c;
                if (Math.abs(startPiece.func_74874_b().field_78892_f - this.field_74887_e.field_78896_c) > 200) {
                    return null;
                }
                if (Math.abs(startPiece.func_74874_b().field_78893_d - this.field_74887_e.field_78897_a) > 200) {
                    return null;
                }
                switch (rand.nextInt(3)) {
                    case 0: {
                        return new RoomSpawner(this.configuration, rand, blockX, blockZ, sizeX, sizeY, sizeZ, this.getDirection().func_176734_d());
                    }
                    case 1: {
                        return new RoomChest(this.configuration, rand, blockX, blockZ, sizeX, sizeY, sizeZ, this.getDirection().func_176734_d());
                    }
                }
                return new RoomEmpty(this.configuration, rand, blockX, blockZ, sizeX, sizeY, sizeZ, this.getDirection().func_176734_d());
            }
        }
        return null;
    }
}

