/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.util;

import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class RedstoneUtil {
    public static boolean isBlockReceivingDirectRedstone(World w, BlockPos pos) {
        if (w == null) {
            return false;
        }
        if (RedstoneUtil.getStrongPower(w, pos.func_177977_b(), EnumFacing.DOWN) > 0) {
            return true;
        }
        if (RedstoneUtil.getStrongPower(w, pos.func_177984_a(), EnumFacing.UP) > 0) {
            return true;
        }
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            if (RedstoneUtil.getStrongPower_NoChunkLoad(w, pos.func_177967_a(facing, 1), facing) <= 0) continue;
            return true;
        }
        return false;
    }

    public static int getStrongPower(World w, BlockPos pos, EnumFacing side) {
        IBlockState bs = w.func_180495_p(pos);
        return bs.func_177230_c().func_176211_b((IBlockAccess)w, pos, bs, side);
    }

    public static int getStrongPower_NoChunkLoad(World w, BlockPos pos, EnumFacing side) {
        if (!w.func_175668_a(pos, false)) {
            return 0;
        }
        IBlockState bs = w.func_180495_p(pos);
        return bs.func_177230_c().func_176211_b((IBlockAccess)w, pos, bs, side);
    }

    public static boolean isBlockReceivingRedstone(World w, BlockPos pos) {
        if (w == null) {
            return false;
        }
        if (RedstoneUtil.getRedstonePowerIndirect(w, pos.func_177981_b(1), EnumFacing.UP) > 0) {
            return true;
        }
        if (RedstoneUtil.getRedstonePowerIndirect(w, pos.func_177979_c(1), EnumFacing.DOWN) > 0) {
            return true;
        }
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            if (RedstoneUtil.getRedstonePowerIndirect_NoChunkLoad(w, pos.func_177967_a(facing, 1), facing) <= 0) continue;
            return true;
        }
        return false;
    }

    public static int getRedstonePowerIndirect_NoChunkLoad(World w, BlockPos pos, EnumFacing side) {
        if (!w.func_175668_a(pos, false)) {
            return 0;
        }
        return RedstoneUtil.getRedstonePowerIndirect(w, pos, side);
    }

    public static int getRedstonePowerIndirect(World w, BlockPos pos, EnumFacing facing) {
        IBlockState bs = w.func_180495_p(pos);
        Block block = bs.func_177230_c();
        if (block instanceof BlockAir) {
            return 0;
        }
        return block.shouldCheckWeakPower((IBlockAccess)w, pos, facing) ? RedstoneUtil.getNeighbourPower_NoChunkLoad(w, pos, facing.func_176734_d()) : block.func_180656_a((IBlockAccess)w, pos, bs, facing);
    }

    public static int getNeighbourPower_NoChunkLoad(World w, BlockPos pos, EnumFacing skip) {
        int p;
        BlockPos sidePos;
        IBlockState bs;
        int i = 0;
        if (skip != EnumFacing.DOWN && (i = (bs = w.func_180495_p(sidePos = pos.func_177982_a(0, -1, 0))).func_177230_c().func_176211_b((IBlockAccess)w, sidePos, bs, EnumFacing.DOWN)) >= 15) {
            return i;
        }
        if (skip != EnumFacing.UP) {
            sidePos = pos.func_177982_a(0, 1, 0);
            bs = w.func_180495_p(sidePos);
            p = bs.func_177230_c().func_176211_b((IBlockAccess)w, sidePos, bs, EnumFacing.UP);
            if (p >= 15) {
                return p;
            }
            if (p > i) {
                i = p;
            }
        }
        for (EnumFacing side : EnumFacing.field_176754_o) {
            if (side == skip || !w.func_175668_a(sidePos = pos.func_177982_a(side.func_82601_c(), 0, side.func_82599_e()), false)) continue;
            bs = w.func_180495_p(sidePos);
            p = bs.func_177230_c().func_176211_b((IBlockAccess)w, sidePos, bs, side);
            if (p >= 15) {
                return p;
            }
            if (p <= i) continue;
            i = p;
        }
        return i;
    }
}

