/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.util;

import java.util.ArrayList;
import java.util.HashSet;
import micdoodle8.mods.galacticraft.api.block.IPartialSealableBlock;
import micdoodle8.mods.galacticraft.api.item.IBreathableArmor;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConnector;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3Dim;
import micdoodle8.mods.galacticraft.api.world.EnumAtmosphericGas;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.energy.EnergyConfigHandler;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.fluid.OxygenPressureProtocol;
import micdoodle8.mods.galacticraft.core.items.ItemCanisterOxygenInfinite;
import micdoodle8.mods.galacticraft.core.items.ItemOxygenGear;
import micdoodle8.mods.galacticraft.core.items.ItemOxygenMask;
import micdoodle8.mods.galacticraft.core.items.ItemOxygenTank;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygenDistributor;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockEnchantmentTable;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.BlockGlass;
import net.minecraft.block.BlockGravel;
import net.minecraft.block.BlockLeavesBase;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockSponge;
import net.minecraft.block.BlockStainedGlass;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class OxygenUtil {
    private static HashSet<BlockPos> checked;

    @SideOnly(value=Side.CLIENT)
    public static boolean shouldDisplayTankGui(GuiScreen gui) {
        if (FMLClientHandler.instance().getClient().field_71474_y.field_74319_N) {
            return false;
        }
        if (gui == null) {
            return true;
        }
        if (gui instanceof GuiInventory) {
            return false;
        }
        return gui instanceof GuiChat;
    }

    public static boolean isAABBInBreathableAirBlock(EntityLivingBase entity) {
        return OxygenUtil.isAABBInBreathableAirBlock(entity, false);
    }

    public static boolean isAABBInBreathableAirBlock(EntityLivingBase entity, boolean testThermal) {
        double y = entity.field_70163_u + (double)entity.func_70047_e();
        double x = entity.field_70165_t;
        double z = entity.field_70161_v;
        double sx = entity.func_174813_aQ().field_72336_d - entity.func_174813_aQ().field_72340_a;
        double sy = entity.func_174813_aQ().field_72337_e - entity.func_174813_aQ().field_72338_b;
        double sz = entity.func_174813_aQ().field_72334_f - entity.func_174813_aQ().field_72339_c;
        double smin = Math.min(sx, Math.min(sy, sz)) / 2.0;
        double offsetXZ = 0.0;
        if (entity.field_70170_p.func_180495_p(entity.func_180425_c()).func_177230_c() == GCBlocks.airLockSeal) {
            offsetXZ = 0.75;
        }
        return OxygenUtil.isAABBInBreathableAirBlock(entity.field_70170_p, AxisAlignedBB.func_178781_a((double)(x - smin - offsetXZ), (double)(y - smin), (double)(z - smin - offsetXZ), (double)(x + smin + offsetXZ), (double)(y + smin), (double)(z + smin + offsetXZ)), testThermal);
    }

    public static boolean isAABBInBreathableAirBlock(World world, AxisAlignedBB bb) {
        return OxygenUtil.isAABBInBreathableAirBlock(world, bb, false);
    }

    public static boolean isAABBInBreathableAirBlock(World world, AxisAlignedBB bb, boolean testThermal) {
        double avgX = (bb.field_72340_a + bb.field_72336_d) / 2.0;
        double avgY = (bb.field_72338_b + bb.field_72337_e) / 2.0;
        double avgZ = (bb.field_72339_c + bb.field_72334_f) / 2.0;
        if (testThermal) {
            return OxygenUtil.isInOxygenAndThermalBlock(world, bb);
        }
        if (OxygenUtil.inOxygenBubble(world, avgX, avgY, avgZ)) {
            return true;
        }
        return OxygenUtil.isInOxygenBlock(world, bb);
    }

    public static boolean isInOxygenBlock(World world, AxisAlignedBB bb) {
        int xm = MathHelper.func_76128_c((double)(bb.field_72340_a + 0.001));
        int xx = MathHelper.func_76128_c((double)(bb.field_72336_d - 0.001));
        int ym = MathHelper.func_76128_c((double)(bb.field_72338_b + 0.001));
        int yy = MathHelper.func_76128_c((double)(bb.field_72337_e - 0.001));
        int zm = MathHelper.func_76128_c((double)(bb.field_72339_c + 0.001));
        int zz = MathHelper.func_76128_c((double)(bb.field_72334_f - 0.001));
        checked = new HashSet();
        if (world.func_175707_a(new BlockPos(xm, ym, zm), new BlockPos(xx, yy, zz))) {
            for (int x = xm; x <= xx; ++x) {
                for (int z = zm; z <= zz; ++z) {
                    for (int y = ym; y <= yy; ++y) {
                        BlockPos pos = new BlockPos(x, y, z);
                        Block block = world.func_180495_p(pos).func_177230_c();
                        if (OxygenUtil.testContactWithBreathableAir(world, block, pos, 0) < 0) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static boolean isInOxygenAndThermalBlock(World world, AxisAlignedBB bb) {
        int i = MathHelper.func_76128_c((double)(bb.field_72340_a + 0.001));
        int j = MathHelper.func_76128_c((double)(bb.field_72336_d - 0.001));
        int k = MathHelper.func_76128_c((double)(bb.field_72338_b + 0.001));
        int l = MathHelper.func_76128_c((double)(bb.field_72337_e - 0.001));
        int i1 = MathHelper.func_76128_c((double)(bb.field_72339_c + 0.001));
        int j1 = MathHelper.func_76128_c((double)(bb.field_72334_f - 0.001));
        checked = new HashSet();
        if (world.func_175707_a(new BlockPos(i, k, i1), new BlockPos(j, l, j1))) {
            for (int x = i; x <= j; ++x) {
                for (int y = k; y <= l; ++y) {
                    for (int z = i1; z <= j1; ++z) {
                        BlockPos pos = new BlockPos(x, y, z);
                        Block block = world.func_180495_p(pos).func_177230_c();
                        if (OxygenUtil.testContactWithBreathableAir(world, block, pos, 0) != 1) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static boolean checkTorchHasOxygen(World world, BlockPos pos) {
        if (OxygenUtil.inOxygenBubble(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.6, (double)pos.func_177952_p() + 0.5)) {
            return true;
        }
        checked = new HashSet();
        BlockVec3 vec = new BlockVec3(pos);
        for (int side = 0; side < 6; ++side) {
            BlockVec3 sidevec = vec.newVecSide(side);
            Block newblock = sidevec.getBlockID_noChunkLoad(world);
            if (OxygenUtil.testContactWithBreathableAir(world, newblock, sidevec.toBlockPos(), 1) < 0) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static synchronized int testContactWithBreathableAir(World world, Block block, BlockPos pos, int limitCount) {
        checked.add(pos);
        if (block == GCBlocks.breatheableAir || block == GCBlocks.brightBreatheableAir) {
            return block.func_176201_c(world.func_180495_p(pos));
        }
        if (block == null || block.func_149688_o() == Material.field_151579_a) {
            return -1;
        }
        boolean permeableFlag = false;
        if (!(block instanceof BlockLeavesBase)) {
            if (block.func_149662_c()) {
                if (!(block instanceof BlockGravel) && block.func_149688_o() != Material.field_151580_n && !(block instanceof BlockSponge)) return -1;
                permeableFlag = true;
            } else {
                if (block instanceof BlockGlass || block instanceof BlockStainedGlass) {
                    return -1;
                }
                if (block instanceof BlockLiquid) {
                    return -1;
                }
                if (OxygenPressureProtocol.nonPermeableBlocks.containsKey(block)) {
                    ArrayList<Integer> metaList = OxygenPressureProtocol.nonPermeableBlocks.get(block);
                    IBlockState state = world.func_180495_p(pos);
                    if (metaList.contains(-1) || metaList.contains(state.func_177230_c().func_176201_c(state))) {
                        return -1;
                    }
                }
            }
        } else {
            permeableFlag = true;
        }
        if (limitCount >= 5) return -1;
        for (EnumFacing side : EnumFacing.field_82609_l) {
            Block newblock;
            int adjResult;
            BlockPos sidevec;
            if (!permeableFlag && !OxygenUtil.canBlockPassAirOnSide(world, block, pos, side) || checked.contains(sidevec = pos.func_177982_a(side.func_82601_c(), side.func_96559_d(), side.func_82599_e())) || (adjResult = OxygenUtil.testContactWithBreathableAir(world, newblock = world.func_180495_p(sidevec).func_177230_c(), sidevec, limitCount + 1)) < 0) continue;
            return adjResult;
        }
        return -1;
    }

    private static boolean canBlockPassAirOnSide(World world, Block block, BlockPos vec, EnumFacing side) {
        if (block instanceof IPartialSealableBlock) {
            return !((IPartialSealableBlock)block).isSealed(world, vec, side);
        }
        if (block instanceof BlockSlab) {
            IBlockState state = world.func_180495_p(vec);
            int meta = state.func_177230_c().func_176201_c(state);
            return !(side == EnumFacing.DOWN && (meta & 8) == 8 || side == EnumFacing.UP && (meta & 8) == 0);
        }
        if (block instanceof BlockFarmland || block instanceof BlockEnchantmentTable || block instanceof BlockLiquid) {
            return side != EnumFacing.UP;
        }
        if (block instanceof BlockPistonBase) {
            IBlockState state = world.func_180495_p(vec);
            if (((Boolean)state.func_177229_b((IProperty)BlockPistonBase.field_176320_b)).booleanValue()) {
                int meta0 = state.func_177230_c().func_176201_c(state);
                EnumFacing facing = BlockPistonBase.func_176317_b((int)meta0);
                return side != facing;
            }
            return false;
        }
        return !block.isSideSolid((IBlockAccess)world, vec, EnumFacing.func_82600_a((int)(side.func_176745_a() ^ 1)));
    }

    public static int getDrainSpacing(ItemStack tank, ItemStack tank2) {
        boolean tank2Valid;
        boolean tank1Valid = tank != null && tank.func_77973_b() instanceof ItemOxygenTank && tank.func_77958_k() - tank.func_77952_i() > 0;
        boolean bl = tank2Valid = tank2 != null && tank2.func_77973_b() instanceof ItemOxygenTank && tank2.func_77958_k() - tank2.func_77952_i() > 0;
        if (!tank1Valid && !tank2Valid) {
            return 0;
        }
        return 9;
    }

    public static boolean hasValidOxygenSetup(EntityPlayerMP player) {
        IBreathableArmor breathableArmor;
        boolean handled;
        boolean missingComponent = false;
        GCPlayerStats stats = GCPlayerStats.get((Entity)player);
        if (stats.getExtendedInventory().func_70301_a(0) == null || !OxygenUtil.isItemValidForPlayerTankInv(0, stats.getExtendedInventory().func_70301_a(0))) {
            handled = false;
            for (ItemStack armorStack : player.field_71071_by.field_70460_b) {
                if (armorStack == null || !(armorStack.func_77973_b() instanceof IBreathableArmor) || !(breathableArmor = (IBreathableArmor)armorStack.func_77973_b()).handleGearType(IBreathableArmor.EnumGearType.HELMET) || !breathableArmor.canBreathe(armorStack, (EntityPlayer)player, IBreathableArmor.EnumGearType.HELMET)) continue;
                handled = true;
            }
            if (!handled) {
                missingComponent = true;
            }
        }
        if (stats.getExtendedInventory().func_70301_a(1) == null || !OxygenUtil.isItemValidForPlayerTankInv(1, stats.getExtendedInventory().func_70301_a(1))) {
            handled = false;
            for (ItemStack armorStack : player.field_71071_by.field_70460_b) {
                if (armorStack == null || !(armorStack.func_77973_b() instanceof IBreathableArmor) || !(breathableArmor = (IBreathableArmor)armorStack.func_77973_b()).handleGearType(IBreathableArmor.EnumGearType.GEAR) || !breathableArmor.canBreathe(armorStack, (EntityPlayer)player, IBreathableArmor.EnumGearType.GEAR)) continue;
                handled = true;
            }
            if (!handled) {
                missingComponent = true;
            }
        }
        if (!(stats.getExtendedInventory().func_70301_a(2) != null && OxygenUtil.isItemValidForPlayerTankInv(2, stats.getExtendedInventory().func_70301_a(2)) || stats.getExtendedInventory().func_70301_a(3) != null && OxygenUtil.isItemValidForPlayerTankInv(3, stats.getExtendedInventory().func_70301_a(3)))) {
            handled = false;
            for (ItemStack armorStack : player.field_71071_by.field_70460_b) {
                if (armorStack == null || !(armorStack.func_77973_b() instanceof IBreathableArmor)) continue;
                breathableArmor = (IBreathableArmor)armorStack.func_77973_b();
                if (breathableArmor.handleGearType(IBreathableArmor.EnumGearType.TANK1) && breathableArmor.canBreathe(armorStack, (EntityPlayer)player, IBreathableArmor.EnumGearType.TANK1)) {
                    handled = true;
                }
                if (!breathableArmor.handleGearType(IBreathableArmor.EnumGearType.TANK2) || !breathableArmor.canBreathe(armorStack, (EntityPlayer)player, IBreathableArmor.EnumGearType.TANK2)) continue;
                handled = true;
            }
            if (!handled) {
                missingComponent = true;
            }
        }
        return !missingComponent;
    }

    public static boolean isItemValidForPlayerTankInv(int slotIndex, ItemStack stack) {
        switch (slotIndex) {
            case 0: {
                return stack.func_77973_b() instanceof ItemOxygenMask;
            }
            case 1: {
                return stack.func_77973_b() instanceof ItemOxygenGear;
            }
            case 2: 
            case 3: {
                return stack.func_77973_b() instanceof ItemOxygenTank || stack.func_77973_b() instanceof ItemCanisterOxygenInfinite;
            }
        }
        return false;
    }

    public static TileEntity[] getAdjacentFluidConnections(TileEntity tile) {
        return OxygenUtil.getAdjacentFluidConnections(tile, false);
    }

    public static TileEntity[] getAdjacentFluidConnections(TileEntity tile, boolean ignoreConnect) {
        TileEntity[] adjacentConnections = new TileEntity[EnumFacing.field_82609_l.length];
        boolean isMekLoaded = EnergyConfigHandler.isMekanismLoaded();
        BlockVec3 thisVec = new BlockVec3(tile);
        for (EnumFacing direction : EnumFacing.field_82609_l) {
            TileEntity tileEntity = thisVec.getTileEntityOnSide(tile.func_145831_w(), direction);
            if (!(tileEntity instanceof IFluidHandler) || !ignoreConnect && tileEntity instanceof IConnector && !((IConnector)tileEntity).canConnect(direction.func_176734_d(), NetworkType.FLUID)) continue;
            adjacentConnections[direction.ordinal()] = tileEntity;
        }
        return adjacentConnections;
    }

    public static boolean noAtmosphericCombustion(WorldProvider provider) {
        if (provider instanceof IGalacticraftWorldProvider) {
            return !((IGalacticraftWorldProvider)provider).isGasPresent(EnumAtmosphericGas.OXYGEN) && !((IGalacticraftWorldProvider)provider).hasBreathableAtmosphere();
        }
        return false;
    }

    public static boolean inOxygenBubble(World worldObj, double avgX, double avgY, double avgZ) {
        int dimID = GCCoreUtil.getDimensionID(worldObj);
        for (BlockVec3Dim blockVec : TileEntityOxygenDistributor.loadedTiles) {
            TileEntity tile;
            if (blockVec == null || blockVec.dim != dimID || !((tile = blockVec.getTileEntity()) instanceof TileEntityOxygenDistributor) || !((TileEntityOxygenDistributor)tile).inBubble(avgX, avgY, avgZ)) continue;
            return true;
        }
        return false;
    }
}

