/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.util;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.entities.EntityLanderBase;
import micdoodle8.mods.galacticraft.core.inventory.ContainerBuggy;
import micdoodle8.mods.galacticraft.core.inventory.ContainerParaChest;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.Language;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.LanguageRegistry;
import net.minecraftforge.fml.relauncher.Side;

public class GCCoreUtil {
    public static int nextID = 0;
    private static boolean deobfuscated;

    public static boolean isDeobfuscated() {
        return deobfuscated;
    }

    public static void openBuggyInv(EntityPlayerMP player, IInventory buggyInv, int type) {
        player.func_71117_bO();
        player.func_71128_l();
        int id = player.field_71139_cq;
        GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_OPEN_PARACHEST_GUI, GCCoreUtil.getDimensionID(player.field_70170_p), new Object[]{id, 0, 0}), player);
        player.field_71070_bA = new ContainerBuggy((IInventory)player.field_71071_by, buggyInv, type, (EntityPlayer)player);
        player.field_71070_bA.field_75152_c = id;
        player.field_71070_bA.func_75132_a((ICrafting)player);
    }

    public static void openParachestInv(EntityPlayerMP player, EntityLanderBase landerInv) {
        player.func_71117_bO();
        player.func_71128_l();
        int windowId = player.field_71139_cq;
        GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_OPEN_PARACHEST_GUI, GCCoreUtil.getDimensionID(player.field_70170_p), new Object[]{windowId, 1, landerInv.func_145782_y()}), player);
        player.field_71070_bA = new ContainerParaChest((IInventory)player.field_71071_by, landerInv, (EntityPlayer)player);
        player.field_71070_bA.field_75152_c = windowId;
        player.field_71070_bA.func_75132_a((ICrafting)player);
    }

    public static int nextInternalID() {
        return ++nextID - 1;
    }

    public static void registerGalacticraftCreature(Class<? extends Entity> var0, String var1, int back, int fore) {
        GCCoreUtil.registerGalacticraftNonMobEntity(var0, var1, 80, 3, true);
        int nextEggID = GCCoreUtil.getNextValidEggID();
        if (nextEggID < 65536) {
            EntityList.field_75623_d.put(nextEggID, var0);
            EntityList.field_75624_e.put(var0, nextEggID);
            EntityList.field_75627_a.put(nextEggID, new EntityList.EntityEggInfo(nextEggID, back, fore));
        }
    }

    public static int getNextValidEggID() {
        int eggID = 255;
        while (EntityList.func_90035_a((int)(++eggID)) != null) {
        }
        return eggID;
    }

    public static void registerGalacticraftNonMobEntity(Class<? extends Entity> var0, String var1, int trackingDistance, int updateFreq, boolean sendVel) {
        if (GCCoreUtil.getEffectiveSide() == Side.CLIENT) {
            LanguageRegistry.instance().addStringLocalization("entity.galacticraftcore." + var1 + ".name", "en_US", GCCoreUtil.translate("entity." + var1 + ".name"));
            LanguageRegistry.instance().addStringLocalization("entity.GalacticraftCore." + var1 + ".name", GCCoreUtil.translate("entity." + var1 + ".name"));
        }
        EntityRegistry.registerModEntity(var0, (String)var1, (int)GCCoreUtil.nextInternalID(), (Object)GalacticraftCore.instance, (int)trackingDistance, (int)updateFreq, (boolean)sendVel);
    }

    public static void registerGalacticraftItem(String key, Item item) {
        GalacticraftCore.itemList.put(key, new ItemStack(item));
    }

    public static void registerGalacticraftItem(String key, Item item, int metadata) {
        GalacticraftCore.itemList.put(key, new ItemStack(item, 1, metadata));
    }

    public static void registerGalacticraftItem(String key, ItemStack stack) {
        GalacticraftCore.itemList.put(key, stack);
    }

    public static void registerGalacticraftBlock(String key, Block block) {
        GalacticraftCore.blocksList.put(key, new ItemStack(block));
    }

    public static void registerGalacticraftBlock(String key, Block block, int metadata) {
        GalacticraftCore.blocksList.put(key, new ItemStack(block, 1, metadata));
    }

    public static void registerGalacticraftBlock(String key, ItemStack stack) {
        GalacticraftCore.blocksList.put(key, stack);
    }

    public static String translate(String key) {
        String result = StatCollector.func_74838_a((String)key);
        int comment = result.indexOf(35);
        String ret = comment > 0 ? result.substring(0, comment).trim() : result;
        for (int i = 0; i < key.length(); ++i) {
            Character c = Character.valueOf(key.charAt(i));
            if (!Character.isUpperCase(c.charValue())) continue;
            System.err.println(ret);
        }
        return ret;
    }

    public static List<String> translateWithSplit(String key) {
        String translated = GCCoreUtil.translate(key);
        int comment = translated.indexOf(35);
        translated = comment > 0 ? translated.substring(0, comment).trim() : translated;
        return Arrays.asList(translated.split("\\$"));
    }

    public static String translateWithFormat(String key, Object ... values) {
        String result = StatCollector.func_74837_a((String)key, (Object[])values);
        int comment = result.indexOf(35);
        String ret = comment > 0 ? result.substring(0, comment).trim() : result;
        for (int i = 0; i < key.length(); ++i) {
            Character c = Character.valueOf(key.charAt(i));
            if (!Character.isUpperCase(c.charValue())) continue;
            System.err.println(ret);
        }
        return ret;
    }

    public static void drawStringRightAligned(String string, int x, int y, int color, FontRenderer fontRendererObj) {
        fontRendererObj.func_78276_b(string, x - fontRendererObj.func_78256_a(string), y, color);
    }

    public static void drawStringCentered(String string, int x, int y, int color, FontRenderer fontRendererObj) {
        fontRendererObj.func_78276_b(string, x - fontRendererObj.func_78256_a(string) / 2, y, color);
    }

    public static String lowerCaseNoun(String string) {
        Language l = Minecraft.func_71410_x().func_135016_M().func_135041_c();
        if (l.func_135034_a().equals("de_DE")) {
            return string;
        }
        return GCCoreUtil.translate(string).toLowerCase();
    }

    public static int getDimensionID(World world) {
        return world.field_73011_w.func_177502_q();
    }

    public static int getDimensionID(WorldProvider provider) {
        return provider.func_177502_q();
    }

    public static int getDimensionID(TileEntity tileEntity) {
        return tileEntity.func_145831_w().field_73011_w.func_177502_q();
    }

    public static WorldServer[] getWorldServerList() {
        return MinecraftServer.func_71276_C().field_71305_c;
    }

    public static WorldServer[] getWorldServerList(World world) {
        if (world instanceof WorldServer) {
            return ((WorldServer)world).func_73046_m().field_71305_c;
        }
        return GCCoreUtil.getWorldServerList();
    }

    public static void sendToAllDimensions(PacketSimple.EnumSimplePacket packetType, Object[] data) {
        for (WorldServer world : GCCoreUtil.getWorldServerList()) {
            int id = GCCoreUtil.getDimensionID((World)world);
            GalacticraftCore.packetPipeline.sendToDimension(new PacketSimple(packetType, id, data), id);
        }
    }

    public static void sendToAllAround(PacketSimple packet, World world, int dimID, BlockPos pos, double radius) {
        double x = (double)pos.func_177958_n() + 0.5;
        double y = (double)pos.func_177956_o() + 0.5;
        double z = (double)pos.func_177952_p() + 0.5;
        double r2 = radius * radius;
        for (EntityPlayer playerMP : world.field_73010_i) {
            double dz;
            double dy;
            double dx;
            if (playerMP.field_71093_bK != dimID || !((dx = x - playerMP.field_70165_t) * dx + (dy = y - playerMP.field_70163_u) * dy + (dz = z - playerMP.field_70161_v) * dz < r2)) continue;
            GalacticraftCore.packetPipeline.sendTo(packet, (EntityPlayerMP)playerMP);
        }
    }

    public static Random getRandom(BlockPos pos) {
        long blockSeed = ((pos.func_177956_o() << 28) + pos.func_177958_n() + 30000000 << 28) + pos.func_177952_p() + 30000000;
        return new Random(blockSeed);
    }

    public static float getAngleForRelativePosition(double nearestX, double nearestZ) {
        return ((float)MathHelper.func_181159_b((double)nearestX, (double)(-nearestZ)) * 57.295776f + 360.0f) % 360.0f;
    }

    public static Side getEffectiveSide() {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER || Thread.currentThread().getName().startsWith("Netty Epoll Server IO")) {
            return Side.SERVER;
        }
        return Side.CLIENT;
    }

    public static List<BlockPos> getPositionsAdjoining(BlockPos pos) {
        LinkedList<BlockPos> result = new LinkedList<BlockPos>();
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (y > 0) {
            result.add(new BlockPos(x, y - 1, z));
        }
        if (y < 255) {
            result.add(new BlockPos(x, y + 1, z));
        }
        result.add(new BlockPos(x, y, z - 1));
        result.add(new BlockPos(x, y, z + 1));
        result.add(new BlockPos(x - 1, y, z));
        result.add(new BlockPos(x + 1, y, z));
        return result;
    }

    public static void getPositionsAdjoining(int x, int y, int z, List<BlockPos> result) {
        result.clear();
        if (y > 0) {
            result.add(new BlockPos(x, y - 1, z));
        }
        if (y < 255) {
            result.add(new BlockPos(x, y + 1, z));
        }
        result.add(new BlockPos(x, y, z - 1));
        result.add(new BlockPos(x, y, z + 1));
        result.add(new BlockPos(x - 1, y, z));
        result.add(new BlockPos(x + 1, y, z));
    }

    public static void getPositionsAdjoiningLoaded(int x, int y, int z, List<BlockPos> result, World world) {
        result.clear();
        if (y > 0) {
            result.add(new BlockPos(x, y - 1, z));
        }
        if (y < 255) {
            result.add(new BlockPos(x, y + 1, z));
        }
        BlockPos pos = new BlockPos(x, y, z - 1);
        if ((z & 0xF) > 0 || world.func_175668_a(pos, false)) {
            result.add(pos);
        }
        pos = new BlockPos(x, y, z + 1);
        if ((z & 0xF) < 15 || world.func_175668_a(pos, false)) {
            result.add(pos);
        }
        pos = new BlockPos(x - 1, y, z);
        if ((x & 0xF) > 0 || world.func_175668_a(pos, false)) {
            result.add(pos);
        }
        pos = new BlockPos(x + 1, y, z);
        if ((x & 0xF) < 15 || world.func_175668_a(pos, false)) {
            result.add(pos);
        }
    }

    public static void getPositionsAdjoining(BlockPos pos, List<BlockPos> result) {
        result.clear();
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (y > 0) {
            result.add(new BlockPos(x, y - 1, z));
        }
        if (y < 255) {
            result.add(new BlockPos(x, y + 1, z));
        }
        result.add(new BlockPos(x, y, z - 1));
        result.add(new BlockPos(x, y, z + 1));
        result.add(new BlockPos(x - 1, y, z));
        result.add(new BlockPos(x + 1, y, z));
    }

    public static void spawnItem(World world, BlockPos pos, ItemStack stack) {
        int spawnCount = stack.field_77994_a;
        for (int i = 0; i < spawnCount; ++i) {
            float var = 0.7f;
            double dx = (double)(world.field_73012_v.nextFloat() * var) + (double)(1.0f - var) * 0.5;
            double dy = (double)(world.field_73012_v.nextFloat() * var) + (double)(1.0f - var) * 0.5;
            double dz = (double)(world.field_73012_v.nextFloat() * var) + (double)(1.0f - var) * 0.5;
            EntityItem entityitem = new EntityItem(world, (double)pos.func_177958_n() + dx, (double)pos.func_177956_o() + dy, (double)pos.func_177952_p() + dz, new ItemStack(stack.func_77973_b(), 1, stack.func_77952_i()));
            entityitem.func_174867_a(10);
            world.func_72838_d((Entity)entityitem);
        }
    }

    static {
        try {
            deobfuscated = Launch.classLoader.getClassBytes("net.minecraft.world.World") != null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

