/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import micdoodle8.mods.galacticraft.core.GCFluids;
import micdoodle8.mods.galacticraft.core.GCItems;
import micdoodle8.mods.galacticraft.core.items.ItemCanisterGeneric;
import micdoodle8.mods.galacticraft.core.tile.TileEntityFluidTank;
import micdoodle8.mods.galacticraft.planets.asteroids.items.AsteroidsItems;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.ItemFluidContainer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;

public class FluidUtil {
    private static boolean oldFluidIDMethod = true;
    private static Class<?> fluidStackClass = null;
    private static Method getFluidMethod = null;
    private static Field fluidIdField = null;

    public static boolean isFuelContainerAny(ItemStack var4) {
        if (var4.func_77973_b() instanceof ItemCanisterGeneric) {
            return var4.func_77973_b() == GCItems.fuelCanister && var4.func_77952_i() < var4.func_77958_k();
        }
        FluidStack liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)var4);
        return liquid != null && FluidUtil.testFuel(FluidRegistry.getFluidName((FluidStack)liquid));
    }

    public static boolean testFuel(String name) {
        if (name.startsWith("fuel")) {
            return true;
        }
        if (name.contains("rocket") && name.contains("fuel")) {
            return true;
        }
        if (name.equals("rc jet fuel")) {
            return true;
        }
        return name.equals("refined_fuel");
    }

    public static boolean testOil(String name) {
        if (name.startsWith("oil")) {
            return true;
        }
        return name.equals("crude_oil");
    }

    public static boolean isFuel(FluidStack fluid) {
        return fluid != null && FluidUtil.testFuel(FluidRegistry.getFluidName((FluidStack)fluid));
    }

    public static boolean isOil(FluidStack fluid) {
        return fluid != null && FluidUtil.testOil(FluidRegistry.getFluidName((FluidStack)fluid));
    }

    public static boolean isFluidFuzzy(FluidStack fluid, String name) {
        return fluid != null && fluid.getFluid() != null && fluid.getFluid().getName().startsWith(name);
    }

    public static boolean isFluidStrict(FluidStack fluid, String name) {
        return fluid != null && fluid.getFluid() != null && fluid.getFluid().getName().equals(name);
    }

    public static int fillWithGCFuel(FluidTank tank, FluidStack liquid, boolean doFill) {
        if (liquid != null && FluidUtil.testFuel(FluidRegistry.getFluidName((FluidStack)liquid))) {
            FluidStack liquidInTank = tank.getFluid();
            if (liquidInTank == null) {
                return tank.fill(new FluidStack(GCFluids.fluidFuel, liquid.amount), doFill);
            }
            if (liquidInTank.amount < tank.getCapacity()) {
                return tank.fill(new FluidStack(liquidInTank, liquid.amount), doFill);
            }
        }
        return 0;
    }

    public static boolean isOilContainerAny(ItemStack var4) {
        if (var4.func_77973_b() instanceof ItemCanisterGeneric) {
            return var4.func_77973_b() == GCItems.oilCanister && var4.func_77952_i() < var4.func_77958_k();
        }
        FluidStack liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)var4);
        return FluidUtil.isOil(liquid);
    }

    public static boolean isMethaneContainerAny(ItemStack var4) {
        if (var4.func_77973_b() instanceof ItemCanisterGeneric) {
            return var4.func_77973_b() == AsteroidsItems.methaneCanister && var4.func_77952_i() < var4.func_77958_k();
        }
        FluidStack stack = FluidContainerRegistry.getFluidForFilledItem((ItemStack)var4);
        return stack != null && stack.getFluid() != null && stack.getFluid().getName().toLowerCase().contains("methane");
    }

    public static boolean isFullContainer(ItemStack var4) {
        if (var4.func_77973_b() instanceof ItemCanisterGeneric) {
            return var4.func_77952_i() == 1;
        }
        FluidStack liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)var4);
        return liquid != null;
    }

    public static void tryFillContainer(FluidTank tank, FluidStack liquid, ItemStack[] inventory, int slot, Item canisterType) {
        ItemStack slotItem = inventory[slot];
        boolean isCanister = slotItem.func_77973_b() instanceof ItemCanisterGeneric;
        int amountToFill = Math.min(liquid.amount, isCanister ? slotItem.func_77952_i() - 1 : 1000);
        if (amountToFill <= 0 || isCanister && slotItem.func_77973_b() != canisterType && slotItem.func_77952_i() != 1001) {
            return;
        }
        if (isCanister) {
            inventory[slot] = new ItemStack(canisterType, 1, slotItem.func_77952_i() - amountToFill);
            tank.drain(amountToFill, true);
        } else if (amountToFill == 1000) {
            inventory[slot] = FluidContainerRegistry.fillFluidContainer((FluidStack)liquid, (ItemStack)inventory[slot]);
            if (inventory[slot] == null) {
                inventory[slot] = slotItem;
            } else {
                tank.drain(amountToFill, true);
            }
        }
    }

    public static void tryFillContainerFuel(FluidTank tank, ItemStack[] inventory, int slot) {
        String liquidname;
        FluidStack liquid;
        if (FluidUtil.isValidContainer(inventory[slot]) && (liquid = tank.getFluid()) != null && liquid.amount > 0 && (liquidname = liquid.getFluid().getName()).startsWith("fuel")) {
            FluidStack existingFluid;
            ItemStack stack;
            if (!liquidname.equals(GCFluids.fluidFuel.getName())) {
                liquid = new FluidStack(GCFluids.fluidFuel, liquid.amount);
            }
            if ((stack = inventory[slot]).func_77973_b() instanceof IFluidContainerItem && (existingFluid = ((IFluidContainerItem)stack.func_77973_b()).getFluid(stack)) != null && !existingFluid.getFluid().getName().equals(GCFluids.fluidFuel.getName())) {
                liquid = new FluidStack(existingFluid, liquid.amount);
            }
            FluidUtil.tryFillContainer(tank, liquid, inventory, slot, GCItems.fuelCanister);
        }
    }

    public static void loadFromContainer(FluidTank tank, Fluid desiredLiquid, ItemStack[] inventory, int slot, int amountOffered) {
        ItemStack slotItem = inventory[slot];
        if (slotItem.func_77973_b() instanceof ItemCanisterGeneric) {
            int used;
            int originalDamage = slotItem.func_77952_i();
            inventory[slot] = originalDamage + (used = tank.fill(new FluidStack(desiredLiquid, 1001 - originalDamage), true)) >= 1001 ? new ItemStack(GCItems.oilCanister, 1, 1001) : new ItemStack(slotItem.func_77973_b(), 1, originalDamage + used);
        } else if (tank.getFluid() == null || amountOffered <= tank.getCapacity() - tank.getFluid().amount) {
            tank.fill(new FluidStack(desiredLiquid, amountOffered), true);
            if (FluidContainerRegistry.isFilledContainer((ItemStack)slotItem)) {
                int bucketCount = slotItem.field_77994_a;
                if (FluidContainerRegistry.isBucket((ItemStack)slotItem)) {
                    if (bucketCount > 1) {
                        tank.fill(new FluidStack(desiredLiquid, (bucketCount - 1) * 1000), true);
                    }
                    inventory[slot] = new ItemStack(Items.field_151133_ar, bucketCount);
                } else {
                    ItemStack emptyStack = FluidContainerRegistry.drainFluidContainer((ItemStack)slotItem);
                    if (bucketCount > 1) {
                        tank.fill(new FluidStack(desiredLiquid, (bucketCount - 1) * FluidContainerRegistry.getContainerCapacity((ItemStack)slotItem)), true);
                        if (emptyStack != null) {
                            emptyStack.field_77994_a = bucketCount;
                        }
                    }
                    inventory[slot] = emptyStack;
                }
            } else {
                --slotItem.field_77994_a;
                if (slotItem.field_77994_a == 0) {
                    inventory[slot] = null;
                }
            }
        }
    }

    public static boolean isEmptyContainer(ItemStack var4, Item canisterType) {
        if (var4.func_77973_b() instanceof ItemCanisterGeneric) {
            return var4.func_77952_i() == 1001 || var4.func_77973_b() == canisterType && var4.func_77952_i() > 1;
        }
        return FluidContainerRegistry.isEmptyContainer((ItemStack)var4);
    }

    public static boolean isEmptyContainerFor(ItemStack var4, FluidStack targetFluid) {
        if (var4.func_77973_b() instanceof ItemCanisterGeneric) {
            if (var4.func_77952_i() == 1001) {
                return true;
            }
            if (var4.func_77952_i() == 1) {
                return false;
            }
            return FluidUtil.fluidsSame(((ItemCanisterGeneric)var4.func_77973_b()).getFluid(var4), targetFluid);
        }
        if (FluidContainerRegistry.isEmptyContainer((ItemStack)var4)) {
            return true;
        }
        return FluidUtil.fluidsSame(FluidContainerRegistry.getFluidForFilledItem((ItemStack)var4), targetFluid);
    }

    public static boolean fluidsSame(FluidStack fs1, FluidStack fs2) {
        if (fs1 == null || fs2 == null) {
            return false;
        }
        Fluid f1 = fs1.getFluid();
        Fluid f2 = fs2.getFluid();
        if (f1 == null || f2 == null || f1.getName() == null) {
            return false;
        }
        return f1.getName().equals(f2.getName());
    }

    public static boolean isEmptyContainer(ItemStack var4) {
        if (var4.func_77973_b() instanceof ItemCanisterGeneric) {
            return var4.func_77952_i() == 1001;
        }
        return FluidContainerRegistry.isEmptyContainer((ItemStack)var4);
    }

    public static boolean isEmptyGasContainer(ItemStack var4) {
        return false;
    }

    public static boolean isFilledContainer(ItemStack var4) {
        if (var4.func_77973_b() instanceof ItemCanisterGeneric) {
            return var4.func_77952_i() < 1001;
        }
        return FluidContainerRegistry.getFluidForFilledItem((ItemStack)var4) != null;
    }

    public static boolean isWaterContainer(ItemStack var4) {
        FluidStack liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)var4);
        return liquid != null && liquid.getFluid() != null && liquid.getFluid().getName().equals("water");
    }

    public static boolean isValidContainer(ItemStack slotItem) {
        return slotItem != null && slotItem.field_77994_a == 1 && (slotItem.func_77973_b() instanceof ItemCanisterGeneric || FluidContainerRegistry.isContainer((ItemStack)slotItem));
    }

    public static ItemStack getUsedContainer(ItemStack container) {
        if (FluidContainerRegistry.isBucket((ItemStack)container) && FluidContainerRegistry.isFilledContainer((ItemStack)container)) {
            return new ItemStack(Items.field_151133_ar, container.field_77994_a);
        }
        --container.field_77994_a;
        if (container.field_77994_a == 0) {
            return null;
        }
        return container;
    }

    public static FluidStack getFluidContained(ItemStack container) {
        if (container == null) {
            return null;
        }
        if (container.func_77973_b() instanceof ItemCanisterGeneric) {
            ItemCanisterGeneric canister = (ItemCanisterGeneric)container.func_77973_b();
            return new FluidStack(FluidRegistry.getFluid((String)canister.getAllowedFluid()), 1001 - container.func_77952_i());
        }
        return FluidContainerRegistry.getFluidForFilledItem((ItemStack)container);
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isInsideOfFluid(Entity entity, Fluid fluid) {
        int k;
        int j;
        double d0 = entity.field_70163_u + (double)entity.func_70047_e();
        int i = MathHelper.func_76128_c((double)entity.field_70165_t);
        BlockPos pos = new BlockPos(i, j = MathHelper.func_76141_d((float)MathHelper.func_76128_c((double)d0)), k = MathHelper.func_76128_c((double)entity.field_70161_v));
        Block block = entity.field_70170_p.func_180495_p(pos).func_177230_c();
        if (block != null && block instanceof IFluidBlock && ((IFluidBlock)block).getFluid() != null && ((IFluidBlock)block).getFluid().getName().equals(fluid.getName())) {
            double filled = ((IFluidBlock)block).getFilledPercentage(entity.field_70170_p, pos);
            if (filled < 0.0) {
                return d0 > (double)j + (1.0 - (filled *= -1.0));
            }
            return d0 < (double)j + filled;
        }
        return false;
    }

    public static boolean interactWithTank(ItemStack container, EntityPlayer playerIn, TileEntityFluidTank tank, EnumFacing side) {
        if (container == null || playerIn.field_70170_p.field_72995_K) {
            return true;
        }
        if (container.func_77973_b() instanceof ItemCanisterGeneric) {
            ItemStack result = FluidUtil.tryEmptyCanister(container, tank, side, playerIn.field_71075_bZ.field_75098_d);
            if ((result != null || (result = FluidUtil.tryFillCanister(container, tank, side, playerIn.field_71075_bZ.field_75098_d)) != null) && playerIn.field_71069_bz != null) {
                playerIn.field_71069_bz.func_75142_b();
            }
            return true;
        }
        int slot = playerIn.field_71071_by.field_70461_c;
        ItemStack result = FluidUtil.tryFillBucket(container, tank, side);
        if (result != null || (result = net.minecraftforge.fluids.FluidUtil.tryEmptyBucket((ItemStack)container, (IFluidHandler)tank, (EnumFacing)side)) != null) {
            if (!playerIn.field_71075_bZ.field_75098_d) {
                playerIn.field_71071_by.func_70298_a(slot, 1);
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)playerIn, (ItemStack)result, (int)slot);
            }
            if (playerIn.field_71069_bz != null) {
                playerIn.field_71069_bz.func_75142_b();
            }
            return true;
        }
        ItemStack copy = container.func_77946_l();
        boolean changedBucket = false;
        if (ItemStack.func_179545_c((ItemStack)container, (ItemStack)FluidContainerRegistry.EMPTY_BUCKET) && FluidRegistry.isUniversalBucketEnabled()) {
            container = new ItemStack((Item)ForgeModContainer.getInstance().universalBucket, copy.field_77994_a);
            changedBucket = true;
        }
        if (net.minecraftforge.fluids.FluidUtil.tryFillFluidContainerItem((ItemStack)container, (IFluidHandler)tank, (EnumFacing)side, (EntityPlayer)playerIn) || net.minecraftforge.fluids.FluidUtil.tryEmptyFluidContainerItem((ItemStack)container, (IFluidHandler)tank, (EnumFacing)side, (EntityPlayer)playerIn)) {
            if (playerIn.field_71075_bZ.field_75098_d) {
                playerIn.field_71071_by.func_70299_a(slot, copy);
            } else if (changedBucket && container.field_77994_a != copy.field_77994_a) {
                copy.field_77994_a = container.field_77994_a;
                playerIn.field_71071_by.func_70299_a(slot, copy);
            } else if (copy.field_77994_a > 1) {
                playerIn.field_71071_by.func_70299_a(slot, container);
            } else {
                playerIn.field_71071_by.func_70299_a(slot, null);
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)playerIn, (ItemStack)container, (int)slot);
            }
            if (playerIn.field_71069_bz != null) {
                playerIn.field_71069_bz.func_75142_b();
            }
            return true;
        }
        return false;
    }

    private static ItemStack tryFillBucket(ItemStack bucket, TileEntityFluidTank tank, EnumFacing side) {
        if (!FluidContainerRegistry.isEmptyContainer((ItemStack)bucket)) {
            return null;
        }
        FluidTankInfo[] info = tank.getTankInfo(side);
        if (info == null || info.length == 0) {
            return null;
        }
        int capacity = FluidContainerRegistry.getContainerCapacity((FluidStack)info[0].fluid, (ItemStack)bucket);
        FluidStack liquid = tank.drain(side, capacity, false);
        if (liquid != null && liquid.amount == capacity) {
            tank.drain(side, capacity, true);
            return FluidContainerRegistry.fillFluidContainer((FluidStack)liquid, (ItemStack)bucket);
        }
        return null;
    }

    private static ItemStack tryFillCanister(ItemStack canister, TileEntityFluidTank tank, EnumFacing side, boolean isCreativeMode) {
        int currCapacity = canister.func_77952_i() - 1;
        if (currCapacity <= 0) {
            return null;
        }
        FluidStack liquid = tank.drain(side, currCapacity, false);
        int transferred = ((ItemCanisterGeneric)canister.func_77973_b()).fill(canister, liquid, !isCreativeMode);
        if (transferred > 0) {
            liquid = tank.drain(side, transferred, true);
            return canister;
        }
        return null;
    }

    private static ItemStack tryEmptyCanister(ItemStack canister, TileEntityFluidTank tank, EnumFacing side, boolean isCreativeMode) {
        int currContents = 1001 - canister.func_77952_i();
        if (currContents <= 0) {
            return null;
        }
        FluidStack liquid = ((ItemFluidContainer)canister.func_77973_b()).drain(canister, currContents, false);
        int transferred = tank.fill(side, liquid, true);
        if (transferred > 0) {
            ((ItemFluidContainer)canister.func_77973_b()).drain(canister, transferred, !isCreativeMode);
            return canister;
        }
        return null;
    }
}

