/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.blocks.BlockEnclosed;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.BlockPos;
import net.minecraft.world.WorldType;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class CompatibilityManager {
    public static boolean PlayerAPILoaded = Loader.isModLoaded((String)"PlayerAPI");
    public static boolean RenderPlayerAPILoaded = Loader.isModLoaded((String)"RenderPlayerAPI");
    public static boolean modJEILoaded = Loader.isModLoaded((String)"JEI");
    private static boolean modIc2Loaded = Loader.isModLoaded((String)"IC2");
    private static boolean modBCraftEnergyLoaded = Loader.isModLoaded((String)"BuildCraft|Energy");
    private static boolean modBCraftTransportLoaded;
    private static boolean modGTLoaded;
    private static boolean modTELoaded;
    private static boolean modMekLoaded;
    private static boolean modAetherIILoaded;
    private static boolean modBasicComponentsLoaded;
    private static boolean modAppEngLoaded;
    private static boolean modPneumaticCraftLoaded;
    private static boolean modBOPLoaded;
    private static boolean modEIOLoaded;
    public static boolean modAALoaded;
    private static boolean modMatterOverdriveLoaded;
    private static boolean wailaLoaded;
    public static boolean isMFRLoaded;
    public static boolean isSmartMovingLoaded;
    public static boolean isTConstructLoaded;
    public static boolean isWitcheryLoaded;
    public static boolean isCubicChunksLoaded;
    public static Class classBCBlockGenericPipe;
    public static Class<?> classGTOre;
    public static Method methodBCBlockPipe_createPipe;
    public static Field fieldBCoilBucket;
    public static Class classBOPWorldType;
    public static Class classBOPws;
    public static Class classBOPwcm;
    public static Class classIC2wrench;
    public static Class classIC2wrenchElectric;
    public static Class classIC2tileEventLoad;
    public static Class classIC2tileEventUnload;
    public static Class classIC2cableType;
    public static Constructor constructorIC2cableTE;
    private static Method androidPlayerGet;
    private static Method androidPlayerIsAndroid;

    public static void checkForCompatibleMods() {
        if (Loader.isModLoaded((String)"gregtech") || Loader.isModLoaded((String)"GregTech_Addon") || Loader.isModLoaded((String)"GregTech")) {
            modGTLoaded = true;
            try {
                Class<?> clazz = Class.forName("gregtech.common.blocks.GT_Block_Ores");
                if (clazz != null) {
                    classGTOre = clazz;
                }
                GCLog.info("Galacticraft: activating GregTech compatibility feature.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (modMekLoaded) {
            GCLog.info("Galacticraft: activating Mekanism compatibility.");
        }
        if (isMFRLoaded) {
            GCLog.info("Galacticraft: activating MFR compatibility feature.");
        }
        if (modTELoaded) {
            GCLog.info("Galacticraft: activating ThermalExpansion compatibility features.");
        }
        if (isTConstructLoaded) {
            GCLog.info("Galacticraft: activating Tinker's Construct compatibility features.");
        }
        if (modIc2Loaded) {
            try {
                try {
                    classIC2wrench = Class.forName("ic2.core.item.tool.ItemToolWrench");
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
                try {
                    classIC2wrenchElectric = Class.forName("ic2.core.item.tool.ItemToolWrenchElectric");
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
                try {
                    classIC2tileEventLoad = Class.forName("ic2.api.energy.event.EnergyTileLoadEvent");
                    classIC2tileEventUnload = Class.forName("ic2.api.energy.event.EnergyTileUnloadEvent");
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
                Class<?> classIC2cable = Class.forName("ic2.core.block.wiring.TileEntityCable");
                classIC2cableType = Class.forName("ic2.core.block.wiring.CableType");
                if (classIC2cable != null) {
                    Constructor<?>[] constructors;
                    try {
                        BlockEnclosed.onBlockNeighbourChangeIC2a = classIC2cable.getMethod("onNeighborChange", Block.class);
                    }
                    catch (NoSuchMethodException e) {
                        BlockEnclosed.onBlockNeighbourChangeIC2b = classIC2cable.getMethod("onNeighborChange", Block.class, BlockPos.class);
                    }
                    Constructor<?>[] constructorArray = constructors = classIC2cable.getDeclaredConstructors();
                    int n = constructorArray.length;
                    for (int i = 0; i < n; ++i) {
                        Constructor<?> constructor2 = constructorArray[i];
                        if (constructor2.getGenericParameterTypes().length != 2) continue;
                        constructorIC2cableTE = constructor2;
                        break;
                    }
                }
                GCLog.info("Galacticraft: activating IndustrialCraft2 compatibility features.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (modBCraftEnergyLoaded) {
            block43: {
                try {
                    Class<?> buildCraftClass = null;
                    buildCraftClass = Class.forName("buildcraft.BuildCraftEnergy");
                    if (buildCraftClass == null) break block43;
                    for (Field f : buildCraftClass.getFields()) {
                        if (!f.getName().equals("bucketOil")) continue;
                        fieldBCoilBucket = f;
                        break;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            GCLog.info("Galacticraft: activating BuildCraft Oil compatibility features.");
        }
        if (Loader.isModLoaded((String)"BuildCraft|Transport")) {
            modBCraftTransportLoaded = true;
            try {
                BlockEnclosed.blockPipeBC = (BlockContainer)GameRegistry.findBlock((String)"BuildCraft|Transport", (String)"pipeBlock");
                classBCBlockGenericPipe = BlockEnclosed.blockPipeBC.getClass();
                for (Method m : classBCBlockGenericPipe.getMethods()) {
                    if (!m.getName().equals("createPipe") || m.getParameterTypes().length != 1) continue;
                    methodBCBlockPipe_createPipe = m;
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            BlockEnclosed.initialiseBC();
            if (methodBCBlockPipe_createPipe == null) {
                modBCraftTransportLoaded = false;
            } else {
                GCLog.info("Galacticraft: activating BuildCraft Transport (Pipes) compatibility features.");
            }
        }
        if (modBOPLoaded) {
            try {
                classBOPWorldType = Class.forName("biomesoplenty.common.world.WorldTypeBOP");
                classBOPws = Class.forName("biomesoplenty.common.world.BOPWorldSettings");
                classBOPwcm = Class.forName("biomesoplenty.common.world.WorldChunkManagerBOP");
                GCLog.info("Galacticraft: activating Biomes O'Plenty compatibility feature.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (Loader.isModLoaded((String)"AetherII")) {
            modAetherIILoaded = true;
            GCLog.info("Galacticraft: activating AetherII compatibility feature.");
        }
        if (Loader.isModLoaded((String)"BasicComponents")) {
            modBasicComponentsLoaded = true;
        }
        if (Loader.isModLoaded((String)"appliedenergistics2")) {
            modAppEngLoaded = true;
            GCLog.info("Galacticraft: activating AppliedEnergistics2 compatibility features.");
        }
        if (Loader.isModLoaded((String)"PneumaticCraft")) {
            modPneumaticCraftLoaded = true;
            GCLog.info("Galacticraft: activating PneumaticCraft compatibility features.");
        }
        if (Loader.isModLoaded((String)"Waila")) {
            wailaLoaded = true;
            GCLog.info("Galacticraft: activating WAILA compatibility features.");
        }
        if (Loader.isModLoaded((String)"cubicchunks")) {
            isCubicChunksLoaded = true;
        }
        if (Loader.isModLoaded((String)"mo")) {
            try {
                Class<?> androidPlayer = Class.forName("matteroverdrive.entity.player.AndroidPlayer");
                androidPlayerGet = androidPlayer.getMethod("get", EntityPlayer.class);
                androidPlayerIsAndroid = androidPlayer.getMethod("isAndroid", new Class[0]);
                modMatterOverdriveLoaded = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean isIc2Loaded() {
        return modIc2Loaded;
    }

    public static boolean isBCraftTransportLoaded() {
        return modBCraftTransportLoaded;
    }

    public static boolean isBCraftEnergyLoaded() {
        return modBCraftEnergyLoaded;
    }

    public static boolean isTELoaded() {
        return modTELoaded;
    }

    public static boolean isMekanismLoaded() {
        return modMekLoaded;
    }

    public static boolean isGTLoaded() {
        return modGTLoaded;
    }

    public static boolean isAIILoaded() {
        return modAetherIILoaded;
    }

    public static boolean isBCLoaded() {
        return modBasicComponentsLoaded;
    }

    public static boolean isAppEngLoaded() {
        return modAppEngLoaded;
    }

    public static boolean isBOPLoaded() {
        return modBOPLoaded;
    }

    public static boolean isBOPWorld(WorldType worldType) {
        if (modBOPLoaded && classBOPWorldType != null && classBOPws != null && classBOPwcm != null) {
            return classBOPWorldType.isInstance(worldType);
        }
        return false;
    }

    public static boolean isPneumaticCraftLoaded() {
        return modPneumaticCraftLoaded;
    }

    public static boolean isWailaLoaded() {
        return wailaLoaded;
    }

    public static void registerMicroBlocks() {
        try {
            Class<?> clazz = Class.forName("codechicken.microblock.MicroMaterialRegistry");
            if (clazz != null) {
                Method[] methodz;
                Method registerMethod = null;
                for (Method m : methodz = clazz.getMethods()) {
                    if (!m.getName().equals("registerMaterial")) continue;
                    registerMethod = m;
                    break;
                }
                Class<?> clazzbm = Class.forName("codechicken.microblock.BlockMicroMaterial");
                registerMethod.invoke(null, clazzbm.getConstructor(Block.class, Integer.TYPE).newInstance(GCBlocks.basicBlock, 3), "tile.gcBlockCore.decoblock1");
                registerMethod.invoke(null, clazzbm.getConstructor(Block.class, Integer.TYPE).newInstance(GCBlocks.basicBlock, 4), "tile.gcBlockCore.decoblock2");
                registerMethod.invoke(null, clazzbm.getConstructor(Block.class, Integer.TYPE).newInstance(GCBlocks.basicBlock, 9), "tile.gcBlockCore.copperBlock");
                registerMethod.invoke(null, clazzbm.getConstructor(Block.class, Integer.TYPE).newInstance(GCBlocks.basicBlock, 10), "tile.gcBlockCore.tinBlock");
                registerMethod.invoke(null, clazzbm.getConstructor(Block.class, Integer.TYPE).newInstance(GCBlocks.basicBlock, 11), "tile.gcBlockCore.aluminumBlock");
                registerMethod.invoke(null, clazzbm.getConstructor(Block.class, Integer.TYPE).newInstance(GCBlocks.basicBlock, 12), "tile.gcBlockCore.meteorironBlock");
                registerMethod.invoke(null, clazzbm.getConstructor(Block.class, Integer.TYPE).newInstance(GCBlocks.blockMoon, 3), "tile.moonBlock.moondirt");
                registerMethod.invoke(null, clazzbm.getConstructor(Block.class, Integer.TYPE).newInstance(GCBlocks.blockMoon, 4), "tile.moonBlock.moonstone");
                registerMethod.invoke(null, clazzbm.getConstructor(Block.class, Integer.TYPE).newInstance(GCBlocks.blockMoon, 5), "tile.moonBlock.moongrass");
                registerMethod.invoke(null, clazzbm.getConstructor(Block.class, Integer.TYPE).newInstance(GCBlocks.blockMoon, 14), "tile.moonBlock.bricks");
                GCLog.info("Galacticraft: activating CodeChicken Microblocks compatibility.");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isAndroid(EntityPlayer player) {
        if (modMatterOverdriveLoaded) {
            try {
                Object androidPlayer = androidPlayerGet.invoke(null, player);
                if (androidPlayer != null) {
                    return (Boolean)androidPlayerIsAndroid.invoke(androidPlayer, new Object[0]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean useAluDust() {
        return modIc2Loaded || modAppEngLoaded || modTELoaded || modEIOLoaded || modAALoaded;
    }

    static {
        modTELoaded = Loader.isModLoaded((String)"ThermalExpansion");
        modMekLoaded = Loader.isModLoaded((String)"Mekanism");
        modBOPLoaded = Loader.isModLoaded((String)"BiomesOPlenty");
        modEIOLoaded = Loader.isModLoaded((String)"EnderIO");
        modAALoaded = Loader.isModLoaded((String)"ActuallyAdditions");
        isMFRLoaded = Loader.isModLoaded((String)"MineFactoryReloaded");
        isSmartMovingLoaded = Loader.isModLoaded((String)"SmartMoving");
        isTConstructLoaded = Loader.isModLoaded((String)"tconstruct");
        isWitcheryLoaded = Loader.isModLoaded((String)"witchery");
        classBCBlockGenericPipe = null;
        classGTOre = null;
        methodBCBlockPipe_createPipe = null;
        classBOPWorldType = null;
        classBOPws = null;
        classBOPwcm = null;
        classIC2wrench = null;
        classIC2wrenchElectric = null;
        classIC2cableType = null;
        constructorIC2cableTE = null;
    }
}

