/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.util;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.client.model.OBJLoaderGC;
import micdoodle8.mods.galacticraft.core.dimension.SpaceRace;
import micdoodle8.mods.galacticraft.core.dimension.SpaceRaceManager;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.proxy.ClientProxyCore;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.wrappers.FlagData;
import micdoodle8.mods.galacticraft.core.wrappers.ModelTransformWrapper;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelState;
import net.minecraftforge.client.model.TRSRTransformation;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.Sys;

@SideOnly(value=Side.CLIENT)
public class ClientUtil {
    public static long getMilliseconds() {
        return Sys.getTime() * 1000L / Sys.getTimerResolution();
    }

    public static void addVariant(String modID, String name, String ... variants) {
        Item itemBlockVariants = GameRegistry.findItem((String)modID, (String)name);
        ResourceLocation[] variants0 = new ResourceLocation[variants.length];
        for (int i = 0; i < variants.length; ++i) {
            variants0[i] = new ResourceLocation(modID + ":" + variants[i]);
        }
        ModelBakery.registerItemVariants((Item)itemBlockVariants, (ResourceLocation[])variants0);
    }

    public static void registerBlockJson(String texturePrefix, Block block) {
        ClientUtil.registerBlockJson(texturePrefix, block, 0, block.func_149739_a().substring(5));
    }

    public static void registerBlockJson(String texturePrefix, Block block, int meta, String name) {
        FMLClientHandler.instance().getClient().func_175599_af().func_175037_a().func_178086_a(Item.func_150898_a((Block)block), meta, new ModelResourceLocation(texturePrefix + name, "inventory"));
    }

    public static void registerItemJson(String texturePrefix, Item item) {
        ClientUtil.registerItemJson(texturePrefix, item, 0, item.func_77658_a().substring(5));
    }

    public static void registerItemJson(String texturePrefix, Item item, int meta, String name) {
        FMLClientHandler.instance().getClient().func_175599_af().func_175037_a().func_178086_a(item, meta, new ModelResourceLocation(texturePrefix + name, "inventory"));
    }

    public static ScaledResolution getScaledRes(Minecraft minecraft, int width, int height) {
        return new ScaledResolution(minecraft);
    }

    public static FlagData updateFlagData(String playerName, boolean sendPacket) {
        SpaceRace race = SpaceRaceManager.getSpaceRaceFromPlayer(playerName);
        if (race != null) {
            return race.getFlagData();
        }
        if (!ClientProxyCore.flagRequestsSent.contains(playerName) && sendPacket) {
            GalacticraftCore.packetPipeline.sendToServer(new PacketSimple(PacketSimple.EnumSimplePacket.S_REQUEST_FLAG_DATA, GCCoreUtil.getDimensionID((World)FMLClientHandler.instance().getClient().field_71441_e), new Object[]{playerName}));
            ClientProxyCore.flagRequestsSent.add(playerName);
        }
        return FlagData.DEFAULT;
    }

    public static Vector3 updateTeamColor(String playerName, boolean sendPacket) {
        SpaceRace race = SpaceRaceManager.getSpaceRaceFromPlayer(playerName);
        if (race != null) {
            return race.getTeamColor();
        }
        if (!ClientProxyCore.flagRequestsSent.contains(playerName) && sendPacket) {
            GalacticraftCore.packetPipeline.sendToServer(new PacketSimple(PacketSimple.EnumSimplePacket.S_REQUEST_FLAG_DATA, GCCoreUtil.getDimensionID((World)FMLClientHandler.instance().getClient().field_71441_e), new Object[]{playerName}));
            ClientProxyCore.flagRequestsSent.add(playerName);
        }
        return new Vector3(1.0, 1.0, 1.0);
    }

    public static void replaceModel(String modid, ModelBakeEvent event, String resLoc, String objLoc, List<String> visibleGroups, Class<? extends ModelTransformWrapper> clazz, IModelState parentState, String ... variants) {
        IBakedModel newModel;
        if (variants.length == 0) {
            variants = new String[]{"inventory"};
        }
        try {
            newModel = ClientUtil.modelFromOBJ(new ResourceLocation(modid, objLoc), visibleGroups, parentState);
            if (clazz != null) {
                newModel = (IBakedModel)clazz.getConstructor(IBakedModel.class).newInstance(newModel);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        for (String variant : variants) {
            ModelResourceLocation modelResourceLocation = new ModelResourceLocation(modid + ":" + resLoc, variant);
            IBakedModel object = (IBakedModel)event.modelRegistry.func_82594_a((Object)modelResourceLocation);
            if (object == null) continue;
            event.modelRegistry.func_82595_a((Object)modelResourceLocation, (Object)newModel);
        }
    }

    public static IFlexibleBakedModel modelFromOBJ(ResourceLocation loc) throws IOException {
        return ClientUtil.modelFromOBJ(loc, (List<String>)ImmutableList.of((Object)"main"));
    }

    public static IFlexibleBakedModel modelFromOBJ(ResourceLocation loc, List<String> visibleGroups) throws IOException {
        return (IFlexibleBakedModel)ClientUtil.modelFromOBJ(loc, visibleGroups, (IModelState)TRSRTransformation.identity());
    }

    public static IBakedModel modelFromOBJ(ResourceLocation loc, List<String> visibleGroups, IModelState parentState) throws IOException {
        IModel model = OBJLoaderGC.instance.loadModel(loc);
        Function spriteFunction = location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
        return model.bake((IModelState)new OBJModel.OBJState(visibleGroups, false, parentState), DefaultVertexFormats.field_176599_b, spriteFunction);
    }

    public static void drawBakedModel(IFlexibleBakedModel model) {
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, model.getFormat());
        for (BakedQuad bakedquad : model.func_177550_a()) {
            worldrenderer.func_178981_a(bakedquad.func_178209_a());
        }
        tessellator.func_78381_a();
    }

    public static void drawBakedModelColored(IFlexibleBakedModel model, int color) {
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, model.getFormat());
        for (BakedQuad bakedquad : model.func_177550_a()) {
            int[] data = bakedquad.func_178209_a();
            data[3] = color;
            data[10] = color;
            data[17] = color;
            data[24] = color;
            worldrenderer.func_178981_a(data);
        }
        tessellator.func_78381_a();
    }
}

