/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import java.util.List;
import micdoodle8.mods.galacticraft.api.item.IKeyable;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.tile.TileEntityAdvanced;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ITickable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityTreasureChest
extends TileEntityAdvanced
implements ITickable,
IInventory,
IKeyable,
ISidedInventory {
    private ItemStack[] chestContents = new ItemStack[27];
    public boolean adjacentChestChecked;
    public float lidAngle;
    public float prevLidAngle;
    public int numPlayersUsing;
    private int ticksSinceSync;
    private AxisAlignedBB renderAABB;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean locked = true;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int tier = 1;

    public TileEntityTreasureChest() {
        this(1);
    }

    public TileEntityTreasureChest(int tier) {
        this.tier = tier;
    }

    public int func_70302_i_() {
        return 27;
    }

    public ItemStack func_70301_a(int index) {
        return this.chestContents[index];
    }

    public ItemStack func_70298_a(int index, int count) {
        if (this.chestContents[index] != null) {
            if (this.chestContents[index].field_77994_a <= count) {
                ItemStack itemstack = this.chestContents[index];
                this.chestContents[index] = null;
                this.func_70296_d();
                return itemstack;
            }
            ItemStack itemstack = this.chestContents[index].func_77979_a(count);
            if (this.chestContents[index].field_77994_a == 0) {
                this.chestContents[index] = null;
            }
            this.func_70296_d();
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int index) {
        if (this.chestContents[index] != null) {
            ItemStack itemstack = this.chestContents[index];
            this.chestContents[index] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.chestContents[index] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public String func_70005_c_() {
        return GCCoreUtil.translate("container.treasurechest.name");
    }

    public boolean func_145818_k_() {
        return false;
    }

    public void setCustomName(String name) {
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.locked = compound.func_74767_n("isLocked");
        this.tier = compound.func_74762_e("tier");
        NBTTagList nbttaglist = compound.func_150295_c("Items", 10);
        this.chestContents = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            int j = nbttagcompound1.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= this.chestContents.length) continue;
            this.chestContents[j] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        compound.func_74757_a("isLocked", this.locked);
        compound.func_74768_a("tier", this.tier);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.chestContents.length; ++i) {
            if (this.chestContents[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.chestContents[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        compound.func_74782_a("Items", (NBTBase)nbttaglist);
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_145836_u() {
        super.func_145836_u();
        this.adjacentChestChecked = false;
    }

    @Override
    public void func_73660_a() {
        float f;
        int i = this.field_174879_c.func_177958_n();
        int j = this.field_174879_c.func_177956_o();
        int k = this.field_174879_c.func_177952_p();
        ++this.ticksSinceSync;
        if (this.locked) {
            this.numPlayersUsing = 0;
        }
        if (!this.field_145850_b.field_72995_K && this.numPlayersUsing != 0 && (this.ticksSinceSync + i + j + k) % 200 == 0) {
            this.numPlayersUsing = 0;
            f = 5.0f;
            List list = this.field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB((double)((float)i - f), (double)((float)j - f), (double)((float)k - f), (double)((float)(i + 1) + f), (double)((float)(j + 1) + f), (double)((float)(k + 1) + f)));
            for (EntityPlayer entityplayer : list) {
                IInventory iinventory;
                if (!(entityplayer.field_71070_bA instanceof ContainerChest) || (iinventory = ((ContainerChest)entityplayer.field_71070_bA).func_85151_d()) != this && (!(iinventory instanceof InventoryLargeChest) || !((InventoryLargeChest)iinventory).func_90010_a((IInventory)this))) continue;
                ++this.numPlayersUsing;
            }
        }
        this.prevLidAngle = this.lidAngle;
        f = 0.1f;
        if (this.numPlayersUsing > 0 && this.lidAngle == 0.0f) {
            double d1 = (double)i + 0.5;
            double d2 = (double)k + 0.5;
            this.field_145850_b.func_72908_a(d1, (double)j + 0.5, d2, "random.chestopen", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        if ((this.numPlayersUsing == 0 || this.locked) && this.lidAngle > 0.0f || this.numPlayersUsing > 0 && this.lidAngle < 1.0f) {
            float f2;
            float f1 = this.lidAngle;
            this.lidAngle = this.numPlayersUsing == 0 || this.locked ? (this.lidAngle -= f) : (this.lidAngle += f);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            if (this.lidAngle < (f2 = 0.5f) && f1 >= f2) {
                double d2 = (double)i + 0.5;
                double d0 = (double)k + 0.5;
                this.field_145850_b.func_72908_a(d2, (double)j + 0.5, d0, "random.chestclosed", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
        super.func_73660_a();
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 1) {
            this.numPlayersUsing = type;
            return true;
        }
        return super.func_145842_c(id, type);
    }

    public void func_174889_b(EntityPlayer player) {
        if (!player.func_175149_v()) {
            if (this.numPlayersUsing < 0) {
                this.numPlayersUsing = 0;
            }
            ++this.numPlayersUsing;
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, this.numPlayersUsing);
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q());
            this.field_145850_b.func_175685_c(this.field_174879_c.func_177977_b(), this.func_145838_q());
        }
    }

    public void func_174886_c(EntityPlayer player) {
        if (!player.func_175149_v()) {
            // empty if block
        }
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.func_145836_u();
    }

    public String getGuiID() {
        return "minecraft:chest";
    }

    public Container createContainer(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerChest((IInventory)playerInventory, (IInventory)this, playerIn);
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.chestContents.length; ++i) {
            this.chestContents[i] = null;
        }
    }

    public IChatComponent func_145748_c_() {
        return this.func_145818_k_() ? new ChatComponentText(this.func_70005_c_()) : new ChatComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    @Override
    public double getPacketRange() {
        return 20.0;
    }

    @Override
    public int getPacketCooldown() {
        return 3;
    }

    @Override
    public boolean isNetworkedTile() {
        return true;
    }

    @Override
    public int getTierOfKeyRequired() {
        return this.tier;
    }

    @Override
    public boolean onValidKeyActivated(EntityPlayer player, ItemStack key, EnumFacing face) {
        if (this.locked) {
            this.locked = false;
            if (!this.field_145850_b.field_72995_K) {
                if (!player.field_71075_bZ.field_75098_d && --player.field_71071_by.func_70448_g().field_77994_a == 0) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean onActivatedWithoutKey(EntityPlayer player, EnumFacing face) {
        if (this.locked) {
            if (player.field_70170_p.field_72995_K) {
                GalacticraftCore.packetPipeline.sendToServer(new PacketSimple(PacketSimple.EnumSimplePacket.S_ON_FAILED_CHEST_UNLOCK, GCCoreUtil.getDimensionID(this.field_145850_b), new Object[]{this.getTierOfKeyRequired()}));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean canBreak() {
        return false;
    }

    public static TileEntityTreasureChest findClosest(Entity entity, int tier) {
        double distance = Double.MAX_VALUE;
        TileEntityTreasureChest chest = null;
        for (TileEntity tile : entity.field_70170_p.field_147482_g) {
            double dist;
            if (!(tile instanceof TileEntityTreasureChest) || ((TileEntityTreasureChest)tile).getTierOfKeyRequired() != tier || !((dist = entity.func_70092_e((double)tile.func_174877_v().func_177958_n() + 0.5, (double)tile.func_174877_v().func_177956_o() + 0.5, (double)tile.func_174877_v().func_177952_p() + 0.5)) < distance)) continue;
            distance = dist;
            chest = (TileEntityTreasureChest)tile;
        }
        if (chest != null) {
            System.out.println("Found chest to generate boss loot in: " + chest.field_174879_c);
        } else {
            System.out.println("Could not find chest to generate boss loot in!");
        }
        return chest;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderAABB == null) {
            this.renderAABB = new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 2, 1));
        }
        return this.renderAABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[0];
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return false;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return false;
    }
}

