/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.core.GCFluids;
import micdoodle8.mods.galacticraft.core.GCItems;
import micdoodle8.mods.galacticraft.core.blocks.BlockRefinery;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseElectricBlockWithInventory;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.FluidUtil;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;

public class TileEntityRefinery
extends TileBaseElectricBlockWithInventory
implements ISidedInventory,
IFluidHandler {
    private final int tankCapacity = 24000;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public FluidTank oilTank = new FluidTank(this.tankCapacity);
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public FluidTank fuelTank = new FluidTank(this.tankCapacity);
    public static final int PROCESS_TIME_REQUIRED = 2;
    public static final int OUTPUT_PER_SECOND = 1;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int processTicks = 0;
    private ItemStack[] containingItems = new ItemStack[3];

    public TileEntityRefinery() {
        this.storage.setMaxExtract(ConfigManagerCore.hardMode ? 90.0f : 60.0f);
        this.oilTank.setFluid(new FluidStack(GCFluids.fluidOil, 0));
        this.fuelTank.setFluid(new FluidStack(GCFluids.fluidFuel, 0));
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            FluidStack liquid = FluidUtil.getFluidContained(this.containingItems[1]);
            if (FluidUtil.isFluidFuzzy(liquid, "oil")) {
                FluidUtil.loadFromContainer(this.oilTank, GCFluids.fluidOil, this.containingItems, 1, liquid.amount);
            }
            this.checkFluidTankTransfer(2, this.fuelTank);
            if (this.canProcess() && this.hasEnoughEnergyToRun) {
                if (this.processTicks == 0) {
                    this.processTicks = this.getProcessTimeRequired();
                } else if (--this.processTicks <= 0) {
                    this.smeltItem();
                    this.processTicks = this.canProcess() ? this.getProcessTimeRequired() : 0;
                }
            } else {
                this.processTicks = 0;
            }
        }
    }

    private int getProcessTimeRequired() {
        return this.poweredByTierGC > 1 ? 1 : 2;
    }

    private void checkFluidTankTransfer(int slot, FluidTank tank) {
        FluidUtil.tryFillContainerFuel(tank, this.containingItems, slot);
    }

    public int getScaledOilLevel(int i) {
        return this.oilTank.getFluidAmount() * i / this.oilTank.getCapacity();
    }

    public int getScaledFuelLevel(int i) {
        return this.fuelTank.getFluidAmount() * i / this.fuelTank.getCapacity();
    }

    public boolean canProcess() {
        if (this.oilTank.getFluidAmount() <= 0) {
            return false;
        }
        if (this.fuelTank.getFluidAmount() >= this.fuelTank.getCapacity()) {
            return false;
        }
        return !this.getDisabled(0);
    }

    public void smeltItem() {
        if (this.canProcess()) {
            int oilAmount = this.oilTank.getFluidAmount();
            int fuelSpace = this.fuelTank.getCapacity() - this.fuelTank.getFluidAmount();
            int amountToDrain = Math.min(Math.min(oilAmount, fuelSpace), 1);
            this.oilTank.drain(amountToDrain, true);
            this.fuelTank.fill(FluidRegistry.getFluidStack((String)(ConfigManagerCore.useOldFuelFluidID ? "fuelgc" : "fuel"), (int)amountToDrain), true);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.processTicks = nbt.func_74762_e("smeltingTicks");
        this.containingItems = this.readStandardItemsFromNBT(nbt);
        if (nbt.func_74764_b("oilTank")) {
            this.oilTank.readFromNBT(nbt.func_74775_l("oilTank"));
        }
        if (this.oilTank.getFluid() != null && this.oilTank.getFluid().getFluid() != GCFluids.fluidOil) {
            this.oilTank.setFluid(new FluidStack(GCFluids.fluidOil, this.oilTank.getFluidAmount()));
        }
        if (nbt.func_74764_b("fuelTank")) {
            this.fuelTank.readFromNBT(nbt.func_74775_l("fuelTank"));
        }
        if (this.fuelTank.getFluid() != null && this.fuelTank.getFluid().getFluid() != GCFluids.fluidFuel) {
            this.fuelTank.setFluid(new FluidStack(GCFluids.fluidFuel, this.fuelTank.getFluidAmount()));
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("smeltingTicks", this.processTicks);
        this.writeStandardItemsToNBT(nbt);
        if (this.oilTank.getFluid() != null) {
            nbt.func_74782_a("oilTank", (NBTBase)this.oilTank.writeToNBT(new NBTTagCompound()));
        }
        if (this.fuelTank.getFluid() != null) {
            nbt.func_74782_a("fuelTank", (NBTBase)this.fuelTank.writeToNBT(new NBTTagCompound()));
        }
    }

    @Override
    protected ItemStack[] getContainingItems() {
        return this.containingItems;
    }

    public String func_70005_c_() {
        return GCCoreUtil.translate("container.refinery.name");
    }

    @Override
    public boolean func_145818_k_() {
        return true;
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0, 1, 2};
    }

    public boolean func_180462_a(int slotID, ItemStack itemstack, EnumFacing side) {
        if (itemstack != null && this.func_94041_b(slotID, itemstack)) {
            switch (slotID) {
                case 0: {
                    return ItemElectricBase.isElectricItemCharged(itemstack);
                }
                case 1: {
                    return FluidUtil.isOilContainerAny(itemstack);
                }
                case 2: {
                    return FluidUtil.isEmptyContainer(itemstack, GCItems.fuelCanister);
                }
            }
            return false;
        }
        return false;
    }

    public boolean func_180461_b(int slotID, ItemStack itemstack, EnumFacing side) {
        if (itemstack != null && this.func_94041_b(slotID, itemstack)) {
            switch (slotID) {
                case 0: {
                    return ItemElectricBase.isElectricItemEmpty(itemstack) || !this.shouldPullEnergy();
                }
                case 1: {
                    return FluidUtil.isEmptyContainer(itemstack);
                }
                case 2: {
                    return FluidUtil.isFullContainer(itemstack);
                }
            }
            return false;
        }
        return false;
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        switch (slotID) {
            case 0: {
                return itemstack != null && ItemElectricBase.isElectricItem(itemstack.func_77973_b());
            }
            case 1: 
            case 2: {
                return FluidUtil.isValidContainer(itemstack);
            }
        }
        return false;
    }

    @Override
    public boolean shouldUseEnergy() {
        return this.canProcess();
    }

    @Override
    public EnumFacing getElectricInputDirection() {
        return EnumFacing.UP;
    }

    @Override
    public EnumFacing getFront() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state.func_177230_c() instanceof BlockRefinery) {
            return (EnumFacing)state.func_177229_b((IProperty)BlockRefinery.FACING);
        }
        return EnumFacing.NORTH;
    }

    private EnumFacing getOilPipe() {
        return this.getFront().func_176746_e();
    }

    private EnumFacing getFuelPipe() {
        return this.getFront().func_176735_f();
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        if (from == this.getFuelPipe()) {
            return this.fuelTank.getFluid() != null && this.fuelTank.getFluidAmount() > 0;
        }
        return false;
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        if (from == this.getFuelPipe() && resource != null) {
            return this.fuelTank.drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        if (from == this.getFuelPipe()) {
            return this.drain(from, new FluidStack(GCFluids.fluidFuel, maxDrain), doDrain);
        }
        return null;
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        if (from == this.getOilPipe()) {
            return this.oilTank.getFluid() == null || this.oilTank.getFluidAmount() < this.oilTank.getCapacity();
        }
        return false;
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        String liquidName;
        int used = 0;
        if (from == this.getOilPipe() && resource != null && (liquidName = FluidRegistry.getFluidName((FluidStack)resource)) != null && FluidUtil.testOil(liquidName)) {
            used = liquidName.equals(GCFluids.fluidOil.getName()) ? this.oilTank.fill(resource, doFill) : this.oilTank.fill(new FluidStack(GCFluids.fluidOil, resource.amount), doFill);
        }
        return used;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        FluidTankInfo[] tankInfo = new FluidTankInfo[]{};
        if (from == this.getOilPipe()) {
            tankInfo = new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.oilTank)};
        } else if (from == this.getFuelPipe()) {
            tankInfo = new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.fuelTank)};
        }
        return tankInfo;
    }

    @Override
    public boolean canConnect(EnumFacing direction, NetworkType type) {
        if (direction == null) {
            return false;
        }
        if (type == NetworkType.POWER) {
            return direction == this.getElectricInputDirection();
        }
        if (type == NetworkType.FLUID) {
            EnumFacing pipeSide = this.getFuelPipe();
            return direction == pipeSide || direction == pipeSide.func_176734_d();
        }
        return false;
    }
}

