/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import micdoodle8.mods.galacticraft.api.world.IZeroGDimension;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.blocks.BlockPlatform;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStatsClient;
import net.minecraft.block.BlockAir;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ITickable;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityPlatform
extends TileEntity
implements ITickable {
    private static final int MAXRANGE = 16;
    private int corner = 0;
    private AxisAlignedBB detection = null;
    private boolean noCollide;
    private boolean moving;
    private boolean lightOn = false;
    private int colorState = 0;
    private int colorTicks = 0;
    private AxisAlignedBB renderAABB;
    private int lightA;
    private int lightB;
    private int deltaY;
    private boolean firstTickCheck;

    public TileEntityPlatform() {
    }

    public TileEntityPlatform(int meta) {
        this.corner = meta > 4 || meta < 0 ? 0 : meta;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.corner = nbt.func_74762_e("co");
        if (this.corner != 0) {
            this.firstTickCheck = true;
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("co", this.corner);
    }

    public void func_73660_a() {
        if (this.firstTickCheck && !this.field_145850_b.field_72995_K) {
            boolean bl = this.firstTickCheck = !this.checkIntact();
        }
        if (this.corner == 0 && !this.field_145850_b.field_72995_K) {
            LinkedList<TileEntityPlatform> adjacentPlatforms = new LinkedList<TileEntityPlatform>();
            int thisX = this.func_174877_v().func_177958_n();
            int thisY = this.func_174877_v().func_177956_o();
            int thisZ = this.func_174877_v().func_177952_p();
            for (int x = -1; x < 1; ++x) {
                for (int z = -1; z < 1; ++z) {
                    TileEntity tile;
                    BlockPos pos = new BlockPos(x + thisX, thisY, z + thisZ);
                    TileEntity tileEntity = tile = this.field_145850_b.func_175668_a(pos, false) ? this.field_145850_b.func_175625_s(pos) : null;
                    if (!(tile instanceof TileEntityPlatform) || tile.func_145837_r() || ((TileEntityPlatform)tile).corner != 0) continue;
                    TileEntity tileUp = this.field_145850_b.func_175625_s(pos.func_177984_a());
                    TileEntity tileDown = this.field_145850_b.func_175625_s(pos.func_177977_b());
                    if (tileUp instanceof TileEntityPlatform || tileDown instanceof TileEntityPlatform) continue;
                    adjacentPlatforms.add((TileEntityPlatform)tile);
                }
            }
            if (adjacentPlatforms.size() == 4) {
                int index = 1;
                for (TileEntityPlatform tile : adjacentPlatforms) {
                    tile.setWhole(index++);
                }
            }
        } else if (this.field_145850_b.field_72995_K) {
            this.updateClient();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void updateClient() {
        IBlockState b;
        this.lightOn = false;
        if (this.colorTicks > 0 && --this.colorTicks == 0) {
            this.colorState = 0;
        }
        if ((b = this.field_145850_b.func_180495_p(this.func_174877_v())).func_177230_c() == GCBlocks.platform && b.func_177229_b(BlockPlatform.CORNER) == BlockPlatform.EnumCorner.NW) {
            List list;
            if (this.detection == null) {
                this.detection = AxisAlignedBB.func_178781_a((double)((double)this.func_174877_v().func_177958_n() + 0.9), (double)((double)this.func_174877_v().func_177956_o() + 0.75), (double)((double)this.func_174877_v().func_177952_p() + 0.9), (double)((double)this.func_174877_v().func_177958_n() + 1.1), (double)((double)this.func_174877_v().func_177956_o() + 1.85), (double)((double)this.func_174877_v().func_177952_p() + 1.1));
            }
            if ((list = this.field_145850_b.func_72872_a(EntityPlayer.class, this.detection)).size() > 0) {
                this.lightOn = true;
                EntityPlayerSP p = FMLClientHandler.instance().getClientPlayerEntity();
                GCPlayerStatsClient stats = GCPlayerStatsClient.get((Entity)p);
                if (list.contains(p) && !stats.getPlatformControlled() && p.field_70154_o == null) {
                    if (p.field_71158_b.field_78899_d) {
                        TileEntity te;
                        int canDescend = this.checkNextPlatform(-1);
                        if (canDescend == -1) {
                            this.colorState = 1;
                            this.colorTicks = 16;
                        } else if (canDescend > 0 && (te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177979_c(canDescend))) instanceof TileEntityPlatform) {
                            TileEntityPlatform tep = (TileEntityPlatform)te;
                            stats.startPlatformAscent(this, tep, (double)(this.field_174879_c.func_177956_o() - canDescend) + (this.field_145850_b.field_73011_w instanceof IZeroGDimension ? 0.97 : 0.875));
                            this.startMove(tep);
                            tep.startMove(this);
                        }
                    } else if (p.field_71158_b.field_78901_c) {
                        TileEntity te;
                        int canAscend = this.checkNextPlatform(1);
                        if (canAscend == -1) {
                            this.colorState = 1;
                            this.colorTicks = 16;
                        } else if (canAscend > 0 && (te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177981_b(canAscend))) instanceof TileEntityPlatform) {
                            p.field_70181_x = 0.0;
                            TileEntityPlatform tep = (TileEntityPlatform)te;
                            stats.startPlatformAscent(tep, this, (float)(this.field_174879_c.func_177956_o() + canAscend) + 0.875f);
                            this.startMove(tep);
                            tep.startMove(this);
                        }
                    }
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void startMove(TileEntityPlatform te) {
        this.moving = true;
        this.lightA = this.field_145850_b.func_175626_b(this.func_174877_v(), 0);
        this.lightB = this.field_145850_b.func_175626_b(te.func_174877_v(), 0);
        this.deltaY = te.func_174877_v().func_177956_o() - this.func_174877_v().func_177956_o();
    }

    private int checkNextPlatform(int dir) {
        int thisX = this.func_174877_v().func_177958_n();
        int thisY = this.func_174877_v().func_177956_o();
        int thisZ = this.func_174877_v().func_177952_p();
        int maxY = thisY + 16 * dir;
        if (maxY > 255) {
            maxY = 255;
        }
        if (maxY < 0) {
            maxY = 0;
        }
        for (int y = thisY + dir; y != maxY; y += dir) {
            int c1 = this.checkCorner(new BlockPos(thisX, y, thisZ), BlockPlatform.EnumCorner.NW);
            if (c1 >= 2) {
                return c1 - 3;
            }
            if ((c1 += this.checkCorner(new BlockPos(thisX + 1, y, thisZ), BlockPlatform.EnumCorner.NE) * 4) >= 8) {
                return c1 - 3;
            }
            if ((c1 += this.checkCorner(new BlockPos(thisX, y, thisZ + 1), BlockPlatform.EnumCorner.SW) * 16) >= 32) {
                return c1 - 3;
            }
            if ((c1 += this.checkCorner(new BlockPos(thisX + 1, y, thisZ + 1), BlockPlatform.EnumCorner.SE) * 64) >= 128) {
                return c1 - 3;
            }
            if (c1 == 0) continue;
            if (this.motionObstructed(thisY + 1, y - thisY)) {
                return -1;
            }
            return (y - thisY) * dir;
        }
        return 0;
    }

    private int checkCorner(BlockPos blockPos, BlockPlatform.EnumCorner corner) {
        IBlockState b = this.field_145850_b.func_180495_p(blockPos);
        if (b.func_177230_c() instanceof BlockAir) {
            return 0;
        }
        if (b.func_177230_c() == GCBlocks.platform && b.func_177229_b(BlockPlatform.CORNER) == corner) {
            return this.field_145850_b.func_180495_p(blockPos.func_177981_b(1)).func_177230_c().func_176214_u() || this.field_145850_b.func_180495_p(blockPos.func_177981_b(2)).func_177230_c().func_176214_u() ? 2 : 1;
        }
        if (b.func_177230_c().func_176214_u() || b.func_177230_c().func_149730_j()) {
            return 3;
        }
        return 0;
    }

    private void setWhole(int index) {
        this.corner = index;
        this.field_145850_b.func_175656_a(this.func_174877_v(), GCBlocks.platform.func_176203_a(index));
    }

    public void onDestroy(TileEntity callingBlock) {
        if (this.corner > 0) {
            this.resetBlocks();
        }
        this.field_145850_b.func_175655_b(this.field_174879_c, true);
    }

    private void resetBlocks() {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        this.getPositions(this.field_174879_c, positions);
        for (BlockPos pos : positions) {
            TileEntity tile;
            if (!this.field_145850_b.func_175668_a(pos, false) || this.field_145850_b.func_180495_p(pos).func_177230_c() != GCBlocks.platform || !((tile = this.field_145850_b.func_175625_s(pos)) instanceof TileEntityPlatform)) continue;
            ((TileEntityPlatform)tile).setWhole(0);
        }
    }

    public void getPositions(BlockPos blockPos, List<BlockPos> positions) {
        int x = blockPos.func_177958_n();
        int y = blockPos.func_177956_o();
        int z = blockPos.func_177952_p();
        switch (this.corner) {
            case 0: {
                break;
            }
            case 1: {
                positions.add(new BlockPos(x + 1, y, z));
                positions.add(new BlockPos(x, y, z + 1));
                positions.add(new BlockPos(x + 1, y, z + 1));
                break;
            }
            case 2: {
                positions.add(new BlockPos(x + 1, y, z));
                positions.add(new BlockPos(x, y, z - 1));
                positions.add(new BlockPos(x + 1, y, z - 1));
                break;
            }
            case 3: {
                positions.add(new BlockPos(x - 1, y, z));
                positions.add(new BlockPos(x, y, z + 1));
                positions.add(new BlockPos(x - 1, y, z + 1));
                break;
            }
            case 4: {
                positions.add(new BlockPos(x - 1, y, z));
                positions.add(new BlockPos(x, y, z - 1));
                positions.add(new BlockPos(x - 1, y, z - 1));
            }
        }
    }

    private boolean checkIntact() {
        IBlockState bs = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (bs.func_177230_c() != GCBlocks.platform || ((BlockPlatform.EnumCorner)((Object)bs.func_177229_b(BlockPlatform.CORNER))).getMeta() != this.corner) {
            this.resetBlocks();
            return false;
        }
        int x = this.field_174879_c.func_177958_n();
        int y = this.field_174879_c.func_177956_o();
        int z = this.field_174879_c.func_177952_p();
        int count = 0;
        switch (this.corner) {
            case 0: {
                count = 3;
                break;
            }
            case 1: {
                count += this.checkState(new BlockPos(x + 1, y, z), 3);
                count += this.checkState(new BlockPos(x, y, z + 1), 2);
                count += this.checkState(new BlockPos(x + 1, y, z + 1), 4);
                break;
            }
            case 2: {
                count += this.checkState(new BlockPos(x + 1, y, z), 4);
                count += this.checkState(new BlockPos(x, y, z - 1), 1);
                count += this.checkState(new BlockPos(x + 1, y, z - 1), 3);
                break;
            }
            case 3: {
                count += this.checkState(new BlockPos(x - 1, y, z), 1);
                count += this.checkState(new BlockPos(x, y, z + 1), 4);
                count += this.checkState(new BlockPos(x - 1, y, z + 1), 2);
                break;
            }
            case 4: {
                count += this.checkState(new BlockPos(x - 1, y, z), 2);
                count += this.checkState(new BlockPos(x, y, z - 1), 3);
                count += this.checkState(new BlockPos(x - 1, y, z - 1), 1);
            }
        }
        if (count >= 3) {
            return count == 3;
        }
        this.resetBlocks();
        return true;
    }

    private int checkState(BlockPos blockPos, int meta) {
        TileEntity tile;
        if (!this.field_145850_b.func_175668_a(blockPos, false)) {
            return 4;
        }
        IBlockState bs = this.field_145850_b.func_180495_p(blockPos);
        if (bs.func_177230_c() == GCBlocks.platform && ((BlockPlatform.EnumCorner)((Object)bs.func_177229_b(BlockPlatform.CORNER))).getMeta() == meta && (tile = this.field_145850_b.func_175625_s(blockPos)) instanceof TileEntityPlatform) {
            ((TileEntityPlatform)tile).corner = meta;
            ((TileEntityPlatform)tile).firstTickCheck = false;
            return 1;
        }
        return 0;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public boolean noCollide() {
        return this.noCollide;
    }

    public void markNoCollide(int y, boolean b) {
        int x = this.func_174877_v().func_177958_n();
        int z = this.func_174877_v().func_177952_p();
        TileEntity te = this.field_145850_b.func_175625_s(new BlockPos(x, y += this.func_174877_v().func_177956_o(), z));
        if (te instanceof TileEntityPlatform) {
            ((TileEntityPlatform)te).noCollide = b;
        }
        if ((te = this.field_145850_b.func_175625_s(new BlockPos(x + 1, y, z))) instanceof TileEntityPlatform) {
            ((TileEntityPlatform)te).noCollide = b;
        }
        if ((te = this.field_145850_b.func_175625_s(new BlockPos(x, y, z + 1))) instanceof TileEntityPlatform) {
            ((TileEntityPlatform)te).noCollide = b;
        }
        if ((te = this.field_145850_b.func_175625_s(new BlockPos(x + 1, y, z + 1))) instanceof TileEntityPlatform) {
            ((TileEntityPlatform)te).noCollide = b;
        }
    }

    public boolean lightEnabled() {
        return this.lightOn;
    }

    public int lightColor() {
        return this.colorState;
    }

    public boolean isMoving() {
        return this.moving;
    }

    public void stopMoving() {
        this.moving = false;
    }

    @SideOnly(value=Side.CLIENT)
    public float getYOffset(float partialTicks) {
        if (this.moving) {
            EntityPlayerSP p = FMLClientHandler.instance().getClientPlayerEntity();
            float playerY = (float)(p.field_70137_T + (p.field_70163_u - p.field_70137_T) * (double)partialTicks);
            return playerY - (float)this.field_174879_c.func_177956_o() - 0.875f;
        }
        return 0.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderAABB == null) {
            this.renderAABB = new AxisAlignedBB(this.field_174879_c.func_177982_a(-1, -18, -1), this.field_174879_c.func_177982_a(1, 18, 1));
        }
        return this.renderAABB;
    }

    @SideOnly(value=Side.CLIENT)
    public float getMeanLightX(float yOffset) {
        this.lightA = this.field_145850_b.func_175626_b(this.func_174877_v(), 0);
        float a = this.lightA % 65536;
        float b = this.lightB % 65536;
        float f = yOffset / (float)this.deltaY;
        return (1.0f - f) * a + f * b;
    }

    @SideOnly(value=Side.CLIENT)
    public float getMeanLightZ(float yOffset) {
        float a = this.lightA / 65536;
        float b = this.lightB / 65536;
        float f = yOffset / (float)this.deltaY;
        return (1.0f - f) * a + f * b;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean motionObstructed(double y, double velocityY) {
        EntityPlayerSP p = FMLClientHandler.instance().getClientPlayerEntity();
        int x = this.field_174879_c.func_177958_n() + 1;
        int z = this.field_174879_c.func_177952_p() + 1;
        double size = 0.5625;
        double height = (double)p.field_70131_O + velocityY;
        double depth = velocityY < 0.0 ? 0.179 : 0.0;
        AxisAlignedBB bb = AxisAlignedBB.func_178781_a((double)((double)x - size), (double)(y - depth), (double)((double)z - size), (double)((double)x + size), (double)(y + height), (double)((double)z + size));
        BlockPlatform.ignoreCollisionTests = true;
        boolean obstructed = !this.field_145850_b.func_72945_a((Entity)p, bb).isEmpty();
        BlockPlatform.ignoreCollisionTests = false;
        return obstructed;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }
}

