/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import io.netty.buffer.ByteBuf;
import java.util.List;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockParaChest;
import micdoodle8.mods.galacticraft.core.entities.IScaleableFuelLevel;
import micdoodle8.mods.galacticraft.core.inventory.ContainerParaChest;
import micdoodle8.mods.galacticraft.core.inventory.IInventorySettable;
import micdoodle8.mods.galacticraft.core.network.PacketDynamicInventory;
import micdoodle8.mods.galacticraft.core.tile.TileEntityAdvanced;
import micdoodle8.mods.galacticraft.core.util.FluidUtil;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.relauncher.Side;

public class TileEntityParaChest
extends TileEntityAdvanced
implements IInventorySettable,
IScaleableFuelLevel {
    private final int tankCapacity = 5000;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public FluidTank fuelTank = new FluidTank(this.tankCapacity);
    public ItemStack[] chestContents = new ItemStack[3];
    public boolean adjacentChestChecked = false;
    public float lidAngle;
    public float prevLidAngle;
    public int numUsingPlayers;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public EnumDyeColor color = EnumDyeColor.RED;

    public void onLoad() {
        if (this.field_145850_b.field_72995_K) {
            GalacticraftCore.packetPipeline.sendToServer(new PacketDynamicInventory(this));
        }
    }

    @Override
    public int getScaledFuelLevel(int i) {
        double fuelLevel = this.fuelTank.getFluid() == null ? 0.0 : (double)this.fuelTank.getFluid().amount;
        return (int)(fuelLevel * (double)i / (double)this.tankCapacity);
    }

    public int func_70302_i_() {
        return this.chestContents.length;
    }

    @Override
    public void setSizeInventory(int size) {
        if ((size - 3) % 18 != 0) {
            size += 18 - (size - 3) % 18;
        }
        this.chestContents = new ItemStack[size];
    }

    public ItemStack func_70301_a(int par1) {
        return this.chestContents[par1];
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (this.chestContents[par1] != null) {
            if (this.chestContents[par1].field_77994_a <= par2) {
                ItemStack itemstack = this.chestContents[par1];
                this.chestContents[par1] = null;
                this.func_70296_d();
                return itemstack;
            }
            ItemStack itemstack = this.chestContents[par1].func_77979_a(par2);
            if (this.chestContents[par1].field_77994_a == 0) {
                this.chestContents[par1] = null;
            }
            this.func_70296_d();
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int par1) {
        if (this.chestContents[par1] != null) {
            ItemStack itemstack = this.chestContents[par1];
            this.chestContents[par1] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int par1, ItemStack par2ItemStack) {
        this.chestContents[par1] = par2ItemStack;
        if (par2ItemStack != null && par2ItemStack.field_77994_a > this.func_70297_j_()) {
            par2ItemStack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public String func_70005_c_() {
        return GCCoreUtil.translate("container.parachest.name");
    }

    public boolean func_145818_k_() {
        return true;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList nbttaglist = nbt.func_150295_c("Items", 10);
        int size = nbt.func_74762_e("chestContentLength");
        if ((size - 3) % 18 != 0) {
            size += 18 - (size - 3) % 18;
        }
        this.chestContents = new ItemStack[size];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            int j = nbttagcompound1.func_74771_c("Slot") & 0xFF;
            if (j >= this.chestContents.length) continue;
            this.chestContents[j] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
        if (nbt.func_74764_b("fuelTank")) {
            this.fuelTank.readFromNBT(nbt.func_74775_l("fuelTank"));
        }
        if (nbt.func_74764_b("color")) {
            this.color = EnumDyeColor.func_176766_a((int)nbt.func_74762_e("color"));
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("chestContentLength", this.chestContents.length);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.chestContents.length; ++i) {
            if (this.chestContents[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.chestContents[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbt.func_74782_a("Items", (NBTBase)nbttaglist);
        if (this.fuelTank.getFluid() != null) {
            nbt.func_74782_a("fuelTank", (NBTBase)this.fuelTank.writeToNBT(new NBTTagCompound()));
        }
        nbt.func_74768_a("color", this.color.func_176767_b());
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_145850_b.func_175625_s(this.func_174877_v()) == this && par1EntityPlayer.func_70092_e((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5) <= 64.0;
    }

    public void func_145836_u() {
        super.func_145836_u();
        this.adjacentChestChecked = false;
    }

    @Override
    public void func_73660_a() {
        float f;
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K && this.numUsingPlayers != 0 && (this.ticks + this.func_174877_v().func_177958_n() + this.func_174877_v().func_177956_o() + this.func_174877_v().func_177952_p()) % 200 == 0) {
            this.numUsingPlayers = 0;
            f = 5.0f;
            List list = this.field_145850_b.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_178781_a((double)((float)this.func_174877_v().func_177958_n() - f), (double)((float)this.func_174877_v().func_177956_o() - f), (double)((float)this.func_174877_v().func_177952_p() - f), (double)((float)(this.func_174877_v().func_177958_n() + 1) + f), (double)((float)(this.func_174877_v().func_177956_o() + 1) + f), (double)((float)(this.func_174877_v().func_177952_p() + 1) + f)));
            for (EntityPlayer entityplayer : list) {
                if (!(entityplayer.field_71070_bA instanceof ContainerParaChest)) continue;
                ++this.numUsingPlayers;
            }
        }
        this.prevLidAngle = this.lidAngle;
        f = 0.1f;
        if (this.numUsingPlayers > 0 && this.lidAngle == 0.0f) {
            double d1 = (double)this.func_174877_v().func_177958_n() + 0.5;
            double d0 = (double)this.func_174877_v().func_177952_p() + 0.5;
            this.field_145850_b.func_72908_a(d1, (double)this.func_174877_v().func_177956_o() + 0.5, d0, "random.chestopen", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        if (this.numUsingPlayers == 0 && this.lidAngle > 0.0f || this.numUsingPlayers > 0 && this.lidAngle < 1.0f) {
            float f2;
            float f1 = this.lidAngle;
            this.lidAngle = this.numUsingPlayers > 0 ? (this.lidAngle += f) : (this.lidAngle -= f);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            if (this.lidAngle < (f2 = 0.5f) && f1 >= f2) {
                double d0 = (double)this.func_174877_v().func_177958_n() + 0.5;
                double d2 = (double)this.func_174877_v().func_177952_p() + 0.5;
                this.field_145850_b.func_72908_a(d0, (double)this.func_174877_v().func_177956_o() + 0.5, d2, "random.chestclosed", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            this.checkFluidTankTransfer(this.chestContents.length - 1, this.fuelTank);
        }
    }

    private void checkFluidTankTransfer(int slot, FluidTank tank) {
        FluidUtil.tryFillContainerFuel(tank, this.chestContents, slot);
    }

    public boolean func_145842_c(int par1, int par2) {
        if (par1 == 1) {
            this.numUsingPlayers = par2;
            return true;
        }
        return super.func_145842_c(par1, par2);
    }

    public void func_174889_b(EntityPlayer player) {
        if (this.numUsingPlayers < 0) {
            this.numUsingPlayers = 0;
        }
        ++this.numUsingPlayers;
        this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_145838_q(), 1, this.numUsingPlayers);
        this.field_145850_b.func_175685_c(this.func_174877_v(), this.func_145838_q());
        this.field_145850_b.func_175685_c(this.func_174877_v().func_177977_b(), this.func_145838_q());
    }

    public void func_174886_c(EntityPlayer player) {
        if (this.func_145838_q() != null && this.func_145838_q() instanceof BlockParaChest) {
            --this.numUsingPlayers;
            this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_145838_q(), 1, this.numUsingPlayers);
            this.field_145850_b.func_175685_c(this.func_174877_v(), this.func_145838_q());
            this.field_145850_b.func_175685_c(this.func_174877_v().func_177977_b(), this.func_145838_q());
        }
    }

    public boolean func_94041_b(int par1, ItemStack par2ItemStack) {
        return true;
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.func_145836_u();
    }

    @Override
    public double getPacketRange() {
        return 12.0;
    }

    @Override
    public int getPacketCooldown() {
        return 3;
    }

    @Override
    public boolean isNetworkedTile() {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public IChatComponent func_145748_c_() {
        return this.func_145818_k_() ? new ChatComponentText(this.func_70005_c_()) : new ChatComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    @Override
    public void decodePacketdata(ByteBuf buffer) {
        EnumDyeColor color = this.color;
        super.decodePacketdata(buffer);
        if (this.field_145850_b.field_72995_K && color != this.color) {
            this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
        }
    }
}

