/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import micdoodle8.mods.galacticraft.api.item.IItemOxygenSupply;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.blocks.BlockMachine2;
import micdoodle8.mods.galacticraft.core.inventory.IInventoryDefaults;
import micdoodle8.mods.galacticraft.core.tile.IMachineSides;
import micdoodle8.mods.galacticraft.core.tile.IMachineSidesProperties;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygen;
import micdoodle8.mods.galacticraft.core.util.FluidUtil;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityOxygenStorageModule
extends TileEntityOxygen
implements IInventoryDefaults,
ISidedInventory,
IFluidHandler,
IMachineSides {
    public final Set<EntityPlayer> playersUsing = new HashSet<EntityPlayer>();
    public int scaledOxygenLevel;
    private int lastScaledOxygenLevel;
    public static final int OUTPUT_PER_TICK = 500;
    public static final int OXYGEN_CAPACITY = 60000;
    private ItemStack[] containingItems = new ItemStack[1];
    private IMachineSides.MachineSidePack[] machineSides;

    public TileEntityOxygenStorageModule() {
        super(60000, 40);
        this.storage.setCapacity(0.0f);
        this.storage.setMaxExtract(0.0f);
    }

    @Override
    public void func_73660_a() {
        ItemStack oxygenItemStack;
        if (!this.field_145850_b.field_72995_K && (oxygenItemStack = this.func_70301_a(0)) != null && oxygenItemStack.func_77973_b() instanceof IItemOxygenSupply) {
            IItemOxygenSupply oxygenItem = (IItemOxygenSupply)oxygenItemStack.func_77973_b();
            int oxygenDraw = (int)Math.floor(Math.min((float)this.oxygenPerTick * 2.5f, (float)(this.getMaxOxygenStored() - this.getOxygenStored())));
            this.setOxygenStored(this.getOxygenStored() + oxygenItem.discharge(oxygenItemStack, oxygenDraw));
            if (this.getOxygenStored() > this.getMaxOxygenStored()) {
                this.setOxygenStored(this.getOxygenStored());
            }
        }
        super.func_73660_a();
        this.scaledOxygenLevel = this.getScaledOxygenLevel(16);
        if (this.scaledOxygenLevel != this.lastScaledOxygenLevel) {
            this.field_145850_b.func_175679_n(this.func_174877_v());
        }
        this.lastScaledOxygenLevel = this.scaledOxygenLevel;
        this.produceOxygen(this.getFront().func_176746_e().func_176734_d());
        this.lastScaledOxygenLevel = this.scaledOxygenLevel;
    }

    @Override
    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        NBTTagList var2 = par1NBTTagCompound.func_150295_c("Items", 10);
        this.containingItems = new ItemStack[this.func_70302_i_()];
        for (int var3 = 0; var3 < var2.func_74745_c(); ++var3) {
            NBTTagCompound var4 = var2.func_150305_b(var3);
            int var5 = var4.func_74771_c("Slot") & 0xFF;
            if (var5 >= this.containingItems.length) continue;
            this.containingItems[var5] = ItemStack.func_77949_a((NBTTagCompound)var4);
        }
        this.readMachineSidesFromNBT(par1NBTTagCompound);
    }

    @Override
    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        NBTTagList list = new NBTTagList();
        for (int var3 = 0; var3 < this.containingItems.length; ++var3) {
            if (this.containingItems[var3] == null) continue;
            NBTTagCompound var4 = new NBTTagCompound();
            var4.func_74774_a("Slot", (byte)var3);
            this.containingItems[var3].func_77955_b(var4);
            list.func_74742_a((NBTBase)var4);
        }
        par1NBTTagCompound.func_74782_a("Items", (NBTBase)list);
        this.addMachineSidesToNBT(par1NBTTagCompound);
    }

    @Override
    public EnumSet<EnumFacing> getElectricalInputDirections() {
        return EnumSet.noneOf(EnumFacing.class);
    }

    @Override
    public EnumSet<EnumFacing> getElectricalOutputDirections() {
        return EnumSet.noneOf(EnumFacing.class);
    }

    @Override
    public boolean shouldPullEnergy() {
        return false;
    }

    @Override
    public boolean shouldUseEnergy() {
        return false;
    }

    @Override
    public EnumFacing getElectricInputDirection() {
        return null;
    }

    @Override
    public ItemStack getBatteryInSlot() {
        return null;
    }

    @Override
    public boolean shouldUseOxygen() {
        return false;
    }

    @Override
    public int getOxygenProvide(EnumFacing direction) {
        return this.getOxygenOutputDirections().contains(direction) ? Math.min(500, this.getOxygenStored()) : 0;
    }

    @Override
    public EnumFacing getFront() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state.func_177230_c() != GCBlocks.machineBase2) {
            return EnumFacing.NORTH;
        }
        return (EnumFacing)state.func_177229_b((IProperty)BlockMachine2.FACING);
    }

    public int func_70302_i_() {
        return this.containingItems.length;
    }

    public ItemStack func_70301_a(int par1) {
        return this.containingItems[par1];
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (this.containingItems[par1] != null) {
            if (this.containingItems[par1].field_77994_a <= par2) {
                ItemStack var3 = this.containingItems[par1];
                this.containingItems[par1] = null;
                return var3;
            }
            ItemStack var3 = this.containingItems[par1].func_77979_a(par2);
            if (this.containingItems[par1].field_77994_a == 0) {
                this.containingItems[par1] = null;
            }
            return var3;
        }
        return null;
    }

    public ItemStack func_70304_b(int par1) {
        if (this.containingItems[par1] != null) {
            ItemStack var2 = this.containingItems[par1];
            this.containingItems[par1] = null;
            return var2;
        }
        return null;
    }

    public void func_70299_a(int par1, ItemStack par2ItemStack) {
        this.containingItems[par1] = par2ItemStack;
        if (par2ItemStack != null && par2ItemStack.field_77994_a > this.func_70297_j_()) {
            par2ItemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_70005_c_() {
        return GCCoreUtil.translate("tile.machine2.6.name");
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_145850_b.func_175625_s(this.func_174877_v()) == this && par1EntityPlayer.func_70092_e((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5) <= 64.0;
    }

    @Override
    public boolean func_145818_k_() {
        return true;
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        return slotID == 0 && itemstack != null && itemstack.func_77973_b() instanceof IItemOxygenSupply;
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0};
    }

    public boolean func_180462_a(int slotID, ItemStack itemstack, EnumFacing side) {
        if (slotID == 0 && this.func_94041_b(slotID, itemstack)) {
            return itemstack.func_77952_i() < itemstack.func_77973_b().func_77612_l();
        }
        return false;
    }

    public boolean func_180461_b(int slotID, ItemStack itemstack, EnumFacing side) {
        if (slotID == 0 && itemstack != null) {
            return FluidUtil.isEmptyContainer(itemstack);
        }
        return false;
    }

    @Override
    public boolean canDrain(EnumFacing from, Fluid fluid) {
        return super.canDrain(from, fluid);
    }

    @Override
    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        return super.drain(from, resource, doDrain);
    }

    @Override
    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        return super.drain(from, maxDrain, doDrain);
    }

    @Override
    public boolean canFill(EnumFacing from, Fluid fluid) {
        return super.canFill(from, fluid);
    }

    @Override
    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        return super.fill(from, resource, doFill);
    }

    @Override
    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        return super.getTankInfo(from);
    }

    @Override
    public EnumSet<EnumFacing> getOxygenInputDirections() {
        EnumFacing dir;
        switch (this.getSide(IMachineSides.MachineSide.ELECTRIC_IN)) {
            case REAR: {
                dir = this.getFront().func_176734_d();
                break;
            }
            case TOP: {
                dir = EnumFacing.UP;
                break;
            }
            case BOTTOM: {
                dir = EnumFacing.DOWN;
                break;
            }
            case RIGHT: {
                dir = this.getFront().func_176735_f();
                break;
            }
            default: {
                dir = this.getFront().func_176746_e();
            }
        }
        return EnumSet.of(dir);
    }

    @Override
    public EnumSet<EnumFacing> getOxygenOutputDirections() {
        EnumFacing dir;
        switch (this.getSide(IMachineSides.MachineSide.PIPE_OUT)) {
            case REAR: {
                dir = this.getFront().func_176734_d();
                break;
            }
            case TOP: {
                dir = EnumFacing.UP;
                break;
            }
            case BOTTOM: {
                dir = EnumFacing.DOWN;
                break;
            }
            case LEFT: {
                dir = this.getFront().func_176746_e();
                break;
            }
            default: {
                dir = this.getFront().func_176735_f();
            }
        }
        return EnumSet.of(dir);
    }

    @Override
    public IMachineSides.MachineSide[] listConfigurableSides() {
        return new IMachineSides.MachineSide[]{IMachineSides.MachineSide.ELECTRIC_IN, IMachineSides.MachineSide.PIPE_OUT};
    }

    @Override
    public IMachineSides.Face[] listDefaultFaces() {
        return new IMachineSides.Face[]{IMachineSides.Face.LEFT, IMachineSides.Face.RIGHT};
    }

    @Override
    public IMachineSides.MachineSidePack[] getAllMachineSides() {
        if (this.machineSides == null) {
            this.initialiseSides();
        }
        return this.machineSides;
    }

    @Override
    public void setupMachineSides(int length) {
        this.machineSides = new IMachineSides.MachineSidePack[length];
    }

    public void onLoad() {
        this.clientOnLoad();
    }

    @Override
    public IMachineSidesProperties getConfigurationType() {
        return BlockMachine2.MACHINESIDES_RENDERTYPE;
    }
}

