/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import java.util.ArrayList;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.blocks.BlockAdvanced;
import micdoodle8.mods.galacticraft.core.blocks.BlockMulti;
import micdoodle8.mods.galacticraft.core.tile.IMultiBlock;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class TileEntityMulti
extends TileEntity {
    public BlockPos mainBlockPosition;

    public TileEntityMulti() {
    }

    public TileEntityMulti(BlockPos mainBlockPosition) {
        this.mainBlockPosition = mainBlockPosition;
    }

    public void onBlockRemoval() {
        TileEntity tileEntity;
        if (this.mainBlockPosition != null && (tileEntity = this.field_145850_b.func_175625_s(this.mainBlockPosition)) instanceof IMultiBlock) {
            IMultiBlock mainBlock = (IMultiBlock)tileEntity;
            mainBlock.onDestroy(this);
        }
    }

    public boolean onBlockActivated(World worldIn, BlockPos pos, EntityPlayer player) {
        TileEntity tileEntity;
        if (this.mainBlockPosition != null && (tileEntity = this.field_145850_b.func_175625_s(this.mainBlockPosition)) instanceof IMultiBlock) {
            return ((IMultiBlock)tileEntity).onActivated(player);
        }
        return false;
    }

    public boolean onBlockWrenched(World world, BlockPos pos, EntityPlayer entityPlayer, EnumFacing side, float hitX, float hitY, float hitZ) {
        IBlockState state;
        if (this.mainBlockPosition != null && (state = this.field_145850_b.func_180495_p(this.mainBlockPosition)).func_177230_c() instanceof BlockAdvanced) {
            return ((BlockAdvanced)state.func_177230_c()).func_180639_a(world, this.mainBlockPosition, state, entityPlayer, side, hitX, hitY, hitZ);
        }
        return false;
    }

    public TileEntity getMainBlockTile() {
        if (this.mainBlockPosition != null) {
            return this.field_145850_b.func_175625_s(this.mainBlockPosition);
        }
        return null;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagCompound tag = nbt.func_74775_l("mainBlockPosition");
        this.mainBlockPosition = new BlockPos(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z"));
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (this.mainBlockPosition != null) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("x", this.mainBlockPosition.func_177958_n());
            tag.func_74768_a("y", this.mainBlockPosition.func_177956_o());
            tag.func_74768_a("z", this.mainBlockPosition.func_177952_p());
            nbt.func_74782_a("mainBlockPosition", (NBTBase)tag);
        }
    }

    protected boolean initialiseMultiTiles(BlockPos pos, World world) {
        IMultiBlock thisTile = (IMultiBlock)((Object)this);
        if (world.field_72995_K) {
            thisTile.onCreate(world, pos);
        }
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        thisTile.getPositions(pos, positions);
        boolean result = true;
        for (BlockPos vecToAdd : positions) {
            TileEntity tile = world.func_175625_s(vecToAdd);
            if (tile instanceof TileEntityMulti) {
                ((TileEntityMulti)tile).mainBlockPosition = pos;
                continue;
            }
            if (tile == null) {
                Block b = world.func_180495_p(vecToAdd).func_177230_c();
                if (!(b instanceof BlockMulti)) {
                    world.func_180501_a(vecToAdd, GCBlocks.fakeBlock.func_176223_P().func_177226_a(BlockMulti.MULTI_TYPE, (Comparable)((Object)thisTile.getMultiType())), 2);
                }
                world.func_175690_a(vecToAdd, (TileEntity)new TileEntityMulti(pos));
                continue;
            }
            result = false;
        }
        if (result || !world.field_72995_K) {
            // empty if block
        }
        return result;
    }
}

