/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import micdoodle8.mods.galacticraft.api.recipe.CompressorRecipes;
import micdoodle8.mods.galacticraft.api.recipe.ShapedRecipesGC;
import micdoodle8.mods.galacticraft.api.recipe.ShapelessOreRecipeGC;
import micdoodle8.mods.galacticraft.core.inventory.IInventoryDefaults;
import micdoodle8.mods.galacticraft.core.inventory.PersistantInventoryCrafting;
import micdoodle8.mods.galacticraft.core.tile.TileEntityAdvanced;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityIngotCompressor
extends TileEntityAdvanced
implements IInventoryDefaults,
ISidedInventory {
    public static final int PROCESS_TIME_REQUIRED = 200;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int processTicks = 0;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int furnaceBurnTime = 0;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int currentItemBurnTime = 0;
    private long ticks;
    private ItemStack producingStack = null;
    private ItemStack[] containingItems = new ItemStack[2];
    public PersistantInventoryCrafting compressingCraftMatrix = new PersistantInventoryCrafting();
    public final Set<EntityPlayer> playersUsing = new HashSet<EntityPlayer>();
    private static Random random = new Random();

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            boolean flag;
            boolean updateInv = false;
            boolean bl = flag = this.furnaceBurnTime > 0;
            if (this.furnaceBurnTime > 0) {
                --this.furnaceBurnTime;
            }
            if (this.furnaceBurnTime == 0 && this.canSmelt()) {
                ItemStack fuel = this.containingItems[0];
                this.currentItemBurnTime = this.furnaceBurnTime = TileEntityFurnace.func_145952_a((ItemStack)fuel);
                if (this.furnaceBurnTime > 0) {
                    updateInv = true;
                    if (fuel != null) {
                        --fuel.field_77994_a;
                        if (fuel.field_77994_a == 0) {
                            this.containingItems[0] = fuel.func_77973_b().getContainerItem(fuel);
                        }
                    }
                }
            }
            if (this.furnaceBurnTime > 0 && this.canSmelt()) {
                ++this.processTicks;
                if (this.processTicks % 40 == 0 && this.processTicks > 100) {
                    this.field_145850_b.func_72908_a((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), "random.anvil_land", 0.2f, 0.5f);
                }
                if (this.processTicks == 200) {
                    this.processTicks = 0;
                    this.smeltItem();
                    updateInv = true;
                }
            } else {
                this.processTicks = 0;
            }
            if (flag != this.furnaceBurnTime > 0) {
                updateInv = true;
            }
            if (updateInv) {
                this.func_70296_d();
            }
        }
        ++this.ticks;
    }

    public void updateInput() {
        this.producingStack = CompressorRecipes.findMatchingRecipe(this.compressingCraftMatrix, this.field_145850_b);
    }

    private boolean canSmelt() {
        ItemStack itemstack = this.producingStack;
        if (itemstack == null) {
            return false;
        }
        if (this.containingItems[1] == null) {
            return true;
        }
        if (!this.containingItems[1].func_77969_a(itemstack)) {
            return false;
        }
        int result = this.containingItems[1].field_77994_a + itemstack.field_77994_a;
        return result <= this.func_70297_j_() && result <= itemstack.func_77976_d();
    }

    public static boolean isItemCompressorInput(ItemStack stack) {
        for (IRecipe recipe : CompressorRecipes.getRecipeList()) {
            if (recipe instanceof ShapedRecipesGC) {
                for (ItemStack itemstack1 : ((ShapedRecipesGC)recipe).recipeItems) {
                    if (stack.func_77973_b() != itemstack1.func_77973_b() || itemstack1.func_77952_i() != Short.MAX_VALUE && stack.func_77952_i() != itemstack1.func_77952_i()) continue;
                    return true;
                }
                continue;
            }
            if (!(recipe instanceof ShapelessOreRecipeGC)) continue;
            ArrayList<Object> required = new ArrayList<Object>(((ShapelessOreRecipeGC)recipe).getInput());
            Iterator<Object> req = required.iterator();
            int match = 0;
            block2: while (req.hasNext()) {
                Object next = req.next();
                if (next instanceof ItemStack) {
                    if (!OreDictionary.itemMatches((ItemStack)((ItemStack)next), (ItemStack)stack, (boolean)false)) continue;
                    ++match;
                    continue;
                }
                if (!(next instanceof List)) continue;
                for (ItemStack itemStack : (List)next) {
                    if (!OreDictionary.itemMatches((ItemStack)itemStack, (ItemStack)stack, (boolean)false)) continue;
                    ++match;
                    continue block2;
                }
            }
            if (match == 0) continue;
            if (match == 1) {
                return true;
            }
            return random.nextInt(match) == 0;
        }
        return false;
    }

    private void smeltItem() {
        if (this.canSmelt()) {
            ItemStack resultItemStack = this.producingStack;
            if (ConfigManagerCore.quickMode && resultItemStack.func_77973_b().func_77667_c(resultItemStack).contains("compressed")) {
                resultItemStack.field_77994_a *= 2;
            }
            if (this.containingItems[1] == null) {
                this.containingItems[1] = resultItemStack.func_77946_l();
            } else if (this.containingItems[1].func_77969_a(resultItemStack)) {
                if (this.containingItems[1].field_77994_a + resultItemStack.field_77994_a > 64) {
                    resultItemStack.field_77994_a += this.containingItems[1].field_77994_a - 64;
                    GCCoreUtil.spawnItem(this.field_145850_b, this.func_174877_v(), resultItemStack);
                    this.containingItems[1].field_77994_a = 64;
                } else {
                    this.containingItems[1].field_77994_a += resultItemStack.field_77994_a;
                }
            }
            for (int i = 0; i < this.compressingCraftMatrix.func_70302_i_(); ++i) {
                if (this.compressingCraftMatrix.func_70301_a(i) != null && this.compressingCraftMatrix.func_70301_a(i).func_77973_b() == Items.field_151131_as) {
                    this.compressingCraftMatrix.setInventorySlotContentsNoUpdate(i, new ItemStack(Items.field_151133_ar));
                    continue;
                }
                this.compressingCraftMatrix.func_70298_a(i, 1);
            }
            this.updateInput();
        }
    }

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        this.processTicks = par1NBTTagCompound.func_74762_e("smeltingTicks");
        NBTTagList var2 = par1NBTTagCompound.func_150295_c("Items", 10);
        this.containingItems = new ItemStack[this.func_70302_i_() - this.compressingCraftMatrix.func_70302_i_()];
        for (int var3 = 0; var3 < var2.func_74745_c(); ++var3) {
            NBTTagCompound var4 = var2.func_150305_b(var3);
            int var5 = var4.func_74771_c("Slot") & 0xFF;
            if (var5 < this.containingItems.length) {
                this.containingItems[var5] = ItemStack.func_77949_a((NBTTagCompound)var4);
                continue;
            }
            if (var5 >= this.containingItems.length + this.compressingCraftMatrix.func_70302_i_()) continue;
            this.compressingCraftMatrix.func_70299_a(var5 - this.containingItems.length, ItemStack.func_77949_a((NBTTagCompound)var4));
        }
        this.updateInput();
    }

    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        NBTTagCompound var4;
        int var3;
        super.func_145841_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("smeltingTicks", this.processTicks);
        NBTTagList var2 = new NBTTagList();
        for (var3 = 0; var3 < this.containingItems.length; ++var3) {
            if (this.containingItems[var3] == null) continue;
            var4 = new NBTTagCompound();
            var4.func_74774_a("Slot", (byte)var3);
            this.containingItems[var3].func_77955_b(var4);
            var2.func_74742_a((NBTBase)var4);
        }
        for (var3 = 0; var3 < this.compressingCraftMatrix.func_70302_i_(); ++var3) {
            if (this.compressingCraftMatrix.func_70301_a(var3) == null) continue;
            var4 = new NBTTagCompound();
            var4.func_74774_a("Slot", (byte)(var3 + this.containingItems.length));
            this.compressingCraftMatrix.func_70301_a(var3).func_77955_b(var4);
            var2.func_74742_a((NBTBase)var4);
        }
        par1NBTTagCompound.func_74782_a("Items", (NBTBase)var2);
    }

    public int func_70302_i_() {
        return this.containingItems.length + this.compressingCraftMatrix.func_70302_i_();
    }

    public ItemStack func_70301_a(int par1) {
        if (par1 >= this.containingItems.length) {
            return this.compressingCraftMatrix.func_70301_a(par1 - this.containingItems.length);
        }
        return this.containingItems[par1];
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (par1 >= this.containingItems.length) {
            ItemStack result = this.compressingCraftMatrix.func_70298_a(par1 - this.containingItems.length, par2);
            if (result != null) {
                this.updateInput();
            }
            return result;
        }
        if (this.containingItems[par1] != null) {
            if (this.containingItems[par1].field_77994_a <= par2) {
                ItemStack var3 = this.containingItems[par1];
                this.containingItems[par1] = null;
                return var3;
            }
            ItemStack var3 = this.containingItems[par1].func_77979_a(par2);
            if (this.containingItems[par1].field_77994_a == 0) {
                this.containingItems[par1] = null;
            }
            return var3;
        }
        return null;
    }

    public ItemStack func_70304_b(int par1) {
        if (par1 >= this.containingItems.length) {
            return this.compressingCraftMatrix.func_70304_b(par1 - this.containingItems.length);
        }
        if (this.containingItems[par1] != null) {
            ItemStack var2 = this.containingItems[par1];
            this.containingItems[par1] = null;
            return var2;
        }
        return null;
    }

    public void func_70299_a(int par1, ItemStack par2ItemStack) {
        if (par1 >= this.containingItems.length) {
            this.compressingCraftMatrix.func_70299_a(par1 - this.containingItems.length, par2ItemStack);
            this.updateInput();
        } else {
            this.containingItems[par1] = par2ItemStack;
            if (par2ItemStack != null && par2ItemStack.field_77994_a > this.func_70297_j_()) {
                par2ItemStack.field_77994_a = this.func_70297_j_();
            }
        }
    }

    public String func_70005_c_() {
        return GCCoreUtil.translate("tile.machine.3.name");
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_145850_b.func_175625_s(this.func_174877_v()) == this && par1EntityPlayer.func_70092_e((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5) <= 64.0;
    }

    public boolean func_94041_b(int slotID, ItemStack itemStack) {
        if (slotID == 0) {
            return TileEntityFurnace.func_145952_a((ItemStack)itemStack) > 0;
        }
        if (slotID >= 2) {
            if (this.producingStack != null) {
                ItemStack stackInSlot = this.func_70301_a(slotID);
                return stackInSlot != null && stackInSlot.func_77969_a(itemStack);
            }
            return TileEntityIngotCompressor.isItemCompressorInput(itemStack);
        }
        return false;
    }

    public int[] func_180463_a(EnumFacing side) {
        if (side == EnumFacing.DOWN) {
            return new int[]{1};
        }
        int[] slots = new int[]{0, 2, 3, 4, 5, 6, 7, 8, 9, 10};
        ArrayList<Integer> removeSlots = new ArrayList<Integer>();
        block0: for (int i = 2; i < 11; ++i) {
            ItemStack stack1;
            if (removeSlots.contains(i) || (stack1 = this.func_70301_a(i)) == null || stack1.field_77994_a <= 0) continue;
            for (int j = i + 1; j < 11; ++j) {
                ItemStack stack2;
                if (removeSlots.contains(j) || (stack2 = this.func_70301_a(j)) == null || !stack1.func_77969_a(stack2)) continue;
                if (stack2.field_77994_a >= stack1.field_77994_a) {
                    removeSlots.add(j);
                    continue block0;
                }
                removeSlots.add(i);
                continue block0;
            }
        }
        if (removeSlots.size() > 0) {
            int[] returnSlots = new int[slots.length - removeSlots.size()];
            int j = 0;
            for (int i = 0; i < slots.length; ++i) {
                if (i > 0 && removeSlots.contains(slots[i])) continue;
                returnSlots[j] = slots[i];
                ++j;
            }
            return returnSlots;
        }
        return slots;
    }

    public boolean func_180462_a(int slotID, ItemStack par2ItemStack, EnumFacing par3) {
        return this.func_94041_b(slotID, par2ItemStack);
    }

    public boolean func_180461_b(int slotID, ItemStack par2ItemStack, EnumFacing par3) {
        return slotID == 1;
    }

    @Override
    public double getPacketRange() {
        return 12.0;
    }

    @Override
    public int getPacketCooldown() {
        return 3;
    }

    @Override
    public boolean isNetworkedTile() {
        return true;
    }
}

