/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import micdoodle8.mods.galacticraft.api.tile.IColorable;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.transmission.grid.IGridNetwork;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockFluidPipe;
import micdoodle8.mods.galacticraft.core.fluid.FluidNetwork;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.tile.FluidTankGC;
import micdoodle8.mods.galacticraft.core.tile.TileEntityFluidTransmitter;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityFluidPipe
extends TileEntityFluidTransmitter
implements IColorable {
    public FluidTankGC buffer = new FluidTankGC(1000, this);
    private boolean dataRequest = false;
    private AxisAlignedBB renderAABB;

    public TileEntityFluidPipe() {
        super(100);
    }

    @Override
    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        if (oldState != newState) {
            return oldState.func_177230_c() != newState.func_177230_c();
        }
        return super.shouldRefresh(world, pos, oldState, newState);
    }

    @Override
    public boolean canConnect(EnumFacing direction, NetworkType type) {
        TileEntity adjacentTile = new BlockVec3(this).getTileEntityOnSide(this.field_145850_b, direction);
        if (type == NetworkType.FLUID) {
            if (adjacentTile instanceof IColorable) {
                byte otherCol;
                IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
                IBlockState adjacentTileState = adjacentTile.func_145831_w().func_180495_p(adjacentTile.func_174877_v());
                byte thisCol = this.getColor(state);
                return thisCol == (otherCol = ((IColorable)adjacentTile).getColor(adjacentTileState)) || thisCol == EnumDyeColor.WHITE.func_176767_b() || otherCol == EnumDyeColor.WHITE.func_176767_b();
            }
            return true;
        }
        return false;
    }

    @Override
    public double getPacketRange() {
        return 12.0;
    }

    @Override
    public int getPacketCooldown() {
        return 5;
    }

    @Override
    public boolean isNetworkedTile() {
        return false;
    }

    public void onLoad() {
        if (this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_175679_n(this.func_174877_v());
            GalacticraftCore.packetPipeline.sendToServer(new PacketSimple(PacketSimple.EnumSimplePacket.S_REQUEST_DATA, GCCoreUtil.getDimensionID(this.field_145850_b), new Object[]{GCCoreUtil.getDimensionID(this.field_145850_b), this.func_174877_v()}));
        }
    }

    @Override
    public void onColorUpdate() {
        if (this.field_145850_b != null) {
            if (this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_175679_n(this.func_174877_v());
            } else {
                this.getNetwork().split(this);
                this.resetNetwork();
            }
        }
    }

    @Override
    public byte getColor(IBlockState state) {
        if (state.func_177230_c() instanceof BlockFluidPipe) {
            return (byte)((EnumDyeColor)state.func_177229_b(BlockFluidPipe.COLOR)).func_176767_b();
        }
        return 15;
    }

    @Override
    public void onAdjacentColorChanged(EnumFacing direction) {
        this.field_145850_b.func_175689_h(this.func_174877_v());
        if (!this.field_145850_b.field_72995_K) {
            this.refresh();
        }
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        if (this.buffer.getFluid() != null) {
            tagCompound.func_74782_a("buff", (NBTBase)this.buffer.writeToNBT(new NBTTagCompound()));
        }
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        if (tagCompound.func_74764_b("pipeColor")) {
            this.field_145850_b.func_175656_a(this.func_174877_v(), this.field_145850_b.func_180495_p(this.func_174877_v()).func_177226_a(BlockFluidPipe.COLOR, (Comparable)EnumDyeColor.func_176766_a((int)tagCompound.func_74771_c("pipeColor"))));
        }
        if (tagCompound.func_74764_b("buff")) {
            this.buffer.readFromNBT(tagCompound.func_74775_l("buff"));
        }
    }

    @Override
    public FluidStack getBuffer() {
        return this.buffer.getFluid() == null ? null : this.buffer.getFluid();
    }

    @Override
    public int getCapacity() {
        return 200;
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        IGridNetwork network = this.getNetwork();
        if (network instanceof FluidNetwork) {
            FluidNetwork fluidNetwork = (FluidNetwork)network;
            return fluidNetwork.emitToBuffer(resource, doFill);
        }
        return this.buffer.fill(resource, doFill);
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        return new FluidTankInfo[0];
    }

    public boolean switchType() {
        Block block;
        if (this.ticks < 10) {
            return false;
        }
        Block currentType = this.func_145838_q();
        if (!(currentType instanceof BlockFluidPipe)) {
            return false;
        }
        switch (((BlockFluidPipe)currentType).getMode()) {
            case NORMAL: {
                block = GCBlocks.oxygenPipePull;
                break;
            }
            default: {
                block = GCBlocks.oxygenPipe;
            }
        }
        BlockFluidPipe.ignoreDrop = true;
        this.field_145850_b.func_175656_a(this.field_174879_c, block.func_176203_a(currentType.func_176201_c(this.field_145850_b.func_180495_p(this.field_174879_c))));
        BlockFluidPipe.ignoreDrop = false;
        if (this.hasNetwork()) {
            this.refresh();
            this.getNetwork().refresh();
        }
        return true;
    }

    @Override
    public boolean canTransmit() {
        Block currentType = this.func_145838_q();
        if (!(currentType instanceof BlockFluidPipe)) {
            return true;
        }
        return ((BlockFluidPipe)currentType).getMode() != BlockFluidPipe.EnumPipeMode.PULL;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderAABB == null) {
            this.renderAABB = new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 1, 1));
        }
        return this.renderAABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 16384.0;
    }
}

