/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import java.util.HashSet;
import java.util.Set;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.blocks.BlockMachineTiered;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseElectricBlockWithInventory;
import micdoodle8.mods.galacticraft.core.tile.IMachineSides;
import micdoodle8.mods.galacticraft.core.tile.IMachineSidesProperties;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;

public class TileEntityElectricFurnace
extends TileBaseElectricBlockWithInventory
implements ISidedInventory,
IMachineSides {
    public static int PROCESS_TIME_REQUIRED = 130;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int processTimeRequired = PROCESS_TIME_REQUIRED;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int processTicks = 0;
    private ItemStack[] containingItems = new ItemStack[4];
    public final Set<EntityPlayer> playersUsing = new HashSet<EntityPlayer>();
    private boolean initialised = true;
    private IMachineSides.MachineSidePack[] machineSides;

    public TileEntityElectricFurnace() {
        this(1);
    }

    public TileEntityElectricFurnace(int tier) {
        if (tier == 1) {
            this.storage.setMaxExtract(ConfigManagerCore.hardMode ? 60.0f : 45.0f);
            return;
        }
        this.setTier2();
    }

    private void setTier2() {
        this.storage.setCapacity(25000.0f);
        this.storage.setMaxExtract(ConfigManagerCore.hardMode ? 90.0f : 60.0f);
        this.processTimeRequired = 100;
        this.setTierGC(2);
    }

    @Override
    public void func_73660_a() {
        if (!this.initialised) {
            int metadata = this.func_145832_p();
            Block b = this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c();
            if (b == GCBlocks.machineBase) {
                this.field_145850_b.func_180501_a(this.func_174877_v(), GCBlocks.machineTiered.func_176223_P(), 2);
            } else if (metadata >= 8) {
                this.setTier2();
            }
            this.initialised = true;
        }
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            if (this.canProcess()) {
                if (this.hasEnoughEnergyToRun) {
                    if (this.tierGC >= 2) {
                        this.processTimeRequired = PROCESS_TIME_REQUIRED / 2 / this.poweredByTierGC;
                    }
                    if (this.processTicks == 0) {
                        this.processTicks = this.processTimeRequired;
                    } else if (--this.processTicks <= 0) {
                        this.smeltItem();
                        this.processTicks = this.canProcess() ? this.processTimeRequired : 0;
                    }
                } else if (this.processTicks > 0 && this.processTicks < this.processTimeRequired && this.field_145850_b.field_73012_v.nextInt(4) == 0) {
                    ++this.processTicks;
                }
            } else {
                this.processTicks = 0;
            }
        } else if (this.processTicks > 0 && this.processTicks < this.processTimeRequired) {
            --this.processTicks;
        }
    }

    public boolean canProcess() {
        if (this.containingItems[1] == null) {
            return false;
        }
        ItemStack result = FurnaceRecipes.func_77602_a().func_151395_a(this.containingItems[1]);
        if (result == null) {
            return false;
        }
        if (this.tierGC == 1) {
            if (this.containingItems[2] != null) {
                return this.containingItems[2].func_77969_a(result) && this.containingItems[2].field_77994_a < 64;
            }
            return true;
        }
        if (this.containingItems[2] == null || this.containingItems[3] == null) {
            return true;
        }
        int space = 0;
        if (this.containingItems[2].func_77969_a(result)) {
            space = 64 - this.containingItems[2].field_77994_a;
        }
        if (this.containingItems[3].func_77969_a(result)) {
            space += 64 - this.containingItems[3].field_77994_a;
        }
        return space >= 2;
    }

    public void smeltItem() {
        if (this.canProcess()) {
            ItemStack resultItemStack = FurnaceRecipes.func_77602_a().func_151395_a(this.containingItems[1]);
            boolean doubleResult = false;
            if (this.tierGC > 1) {
                String nameSmelted = this.containingItems[1].func_77977_a().toLowerCase();
                if ((resultItemStack.func_77977_a().toLowerCase().contains("ingot") || resultItemStack.func_77973_b() == Items.field_151128_bU) && (nameSmelted.contains("ore") || nameSmelted.contains("raw") || nameSmelted.contains("moon") || nameSmelted.contains("mars") || nameSmelted.contains("shard"))) {
                    doubleResult = true;
                }
            }
            if (doubleResult) {
                int space2 = 0;
                int space3 = 0;
                if (this.containingItems[2] == null) {
                    this.containingItems[2] = resultItemStack.func_77946_l();
                    this.containingItems[2].field_77994_a += resultItemStack.field_77994_a;
                    space2 = 2;
                } else if (this.containingItems[2].func_77969_a(resultItemStack)) {
                    space2 = (64 - this.containingItems[2].field_77994_a) / resultItemStack.field_77994_a;
                    if (space2 > 2) {
                        space2 = 2;
                    }
                    this.containingItems[2].field_77994_a += resultItemStack.field_77994_a * space2;
                }
                if (space2 < 2) {
                    if (this.containingItems[3] == null) {
                        this.containingItems[3] = resultItemStack.func_77946_l();
                        if (space2 == 0) {
                            this.containingItems[3].field_77994_a += resultItemStack.field_77994_a;
                        }
                    } else if (this.containingItems[3].func_77969_a(resultItemStack)) {
                        space3 = (64 - this.containingItems[3].field_77994_a) / resultItemStack.field_77994_a;
                        if (space3 > 2 - space2) {
                            space3 = 2 - space2;
                        }
                        this.containingItems[3].field_77994_a += resultItemStack.field_77994_a * space3;
                    }
                }
            } else if (this.containingItems[2] == null) {
                this.containingItems[2] = resultItemStack.func_77946_l();
            } else if (this.containingItems[2].func_77969_a(resultItemStack)) {
                this.containingItems[2].field_77994_a += resultItemStack.field_77994_a;
            }
            --this.containingItems[1].field_77994_a;
            if (this.containingItems[1].field_77994_a <= 0) {
                this.containingItems[1] = null;
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        if (this.storage.getEnergyStoredGC() > 16000.0f) {
            this.setTier2();
            this.initialised = true;
        } else {
            this.initialised = false;
        }
        this.processTicks = par1NBTTagCompound.func_74762_e("smeltingTicks");
        this.containingItems = this.readStandardItemsFromNBT(par1NBTTagCompound);
        this.readMachineSidesFromNBT(par1NBTTagCompound);
    }

    @Override
    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        if (this.tierGC == 1 && this.storage.getEnergyStoredGC() > 16000.0f) {
            this.storage.setEnergyStored(16000.0f);
        }
        super.func_145841_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("smeltingTicks", this.processTicks);
        this.writeStandardItemsToNBT(par1NBTTagCompound);
        this.addMachineSidesToNBT(par1NBTTagCompound);
    }

    @Override
    public int func_70302_i_() {
        return this.tierGC == 1 && this.initialised ? 3 : 4;
    }

    @Override
    protected ItemStack[] getContainingItems() {
        return this.containingItems;
    }

    public String func_70005_c_() {
        return GCCoreUtil.translate(this.tierGC == 1 ? "tile.machine.2.name" : "tile.machine.7.name");
    }

    public boolean func_94041_b(int slotID, ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        return slotID == 1 ? FurnaceRecipes.func_77602_a().func_151395_a(itemStack) != null : slotID == 0 && ItemElectricBase.isElectricItem(itemStack.func_77973_b());
    }

    public int[] func_180463_a(EnumFacing side) {
        if (this.tierGC == 2) {
            return new int[]{0, 1, 2, 3};
        }
        return new int[]{0, 1, 2};
    }

    public boolean func_180462_a(int slotID, ItemStack par2ItemStack, EnumFacing par3) {
        return this.func_94041_b(slotID, par2ItemStack);
    }

    public boolean func_180461_b(int slotID, ItemStack par2ItemStack, EnumFacing par3) {
        return slotID == 2 || this.tierGC == 2 && slotID == 3;
    }

    @Override
    public boolean shouldUseEnergy() {
        return this.canProcess();
    }

    @Override
    public boolean func_145818_k_() {
        return false;
    }

    @Override
    public EnumFacing getFront() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state.func_177230_c() instanceof BlockMachineTiered) {
            return (EnumFacing)state.func_177229_b((IProperty)BlockMachineTiered.FACING);
        }
        return EnumFacing.NORTH;
    }

    @Override
    public EnumFacing getElectricInputDirection() {
        switch (this.getSide(IMachineSides.MachineSide.ELECTRIC_IN)) {
            case RIGHT: {
                return this.getFront().func_176735_f();
            }
            case REAR: {
                return this.getFront().func_176734_d();
            }
            case TOP: {
                return EnumFacing.UP;
            }
            case BOTTOM: {
                return EnumFacing.DOWN;
            }
        }
        return this.getFront().func_176746_e();
    }

    @Override
    public IMachineSides.MachineSide[] listConfigurableSides() {
        return new IMachineSides.MachineSide[]{IMachineSides.MachineSide.ELECTRIC_IN};
    }

    @Override
    public IMachineSides.Face[] listDefaultFaces() {
        return new IMachineSides.Face[]{IMachineSides.Face.LEFT};
    }

    @Override
    public IMachineSides.MachineSidePack[] getAllMachineSides() {
        if (this.machineSides == null) {
            this.initialiseSides();
        }
        return this.machineSides;
    }

    @Override
    public void setupMachineSides(int length) {
        this.machineSides = new IMachineSides.MachineSidePack[length];
    }

    public void onLoad() {
        this.clientOnLoad();
    }

    @Override
    public IMachineSidesProperties getConfigurationType() {
        return BlockMachineTiered.MACHINESIDES_RENDERTYPE;
    }
}

